//------------------------------------------------
// Screen.cpp 摜Aʕ`̊֐
//------------------------------------------------

#include "Screen.h"
#include "../Move.h"

//tF[h
void ChangeScreen(int ImgHandle1, int ImgHandle2)
{
	for(int i=16; i<=256; i+=16){
		SetDrawBlendMode(DX_BLENDMODE_ALPHA, 256-i);
		DrawGraph( 0, 0, ImgHandle1, FALSE );
		SetDrawBlendMode(DX_BLENDMODE_ALPHA, i-1);
		DrawGraph( 0, 0, ImgHandle2, FALSE );
		WaitTimer(30);
		ScreenFlip();
	}
	SetDrawBlendMode(DX_BLENDMODE_NOBLEND, 0);	//uh[hɖ߂
}

//ԕEFCg
void WaitFrame(void)
{
	const int Wait = 1000/FRAME_RATE;	//1t[̎
	static int Time = GetNowCount();	//O̎
	int Term = GetNowCount()-Time;		//O񂩂̌oߎ
	if(Wait-Term>0) WaitTimer(Wait-Term);	//EFCg
	Time = GetNowCount();
}

//t[[g\
void DrawFps(void)
{
	static int OldTime = GetNowCount();	//O̎Ԃۑ
	static int Count = 0;	//FPSJEg
	static int Fps = 0;		//\p
	int NowTime = GetNowCount();	//̎
	
	++Count;
	if((NowTime - OldTime) >= 1000){	//1000mso
		int Diff = ((NowTime - OldTime) - 1000);
		//̎Ԃۑ 
		OldTime = NowTime - Diff;	//o߂
		Fps = Count;	//FPSۑ
		Count = 0;	//JE^
	}
	DrawFormatString(0,0,0,"FPS %d",Fps);	//ʂFPS\
}

//ʂ̍XV
void RenewScreen(void)
{
	DrawFps();	//t[[g\
	DrawRotaGraph( CenterX, CenterY, 1.0, MainScr.Rad, MainScr.StHandle, FALSE, FALSE);	//Hg]
	DrawGraph( MainScr.BallX, MainScr.BallY, MainScr.BlHandle, TRUE);	//{[̕`
}

//JEg_Es
int CountDown(int StageNum)
{
	static int CountFlag = 0;
	static int NowCount = 3;
	static int OldTime;
	const int PlaySndType[4] = {SND_START,SND_COUNT,SND_COUNT,SND_COUNT};
	const int PictHW[4] = {START_SIZEX/2,COUNT_SIZEX/2,COUNT_SIZEX/2,COUNT_SIZEX/2};
	const int PictHH[4] = {START_SIZEY/2,COUNT_SIZEY/2,COUNT_SIZEY/2,COUNT_SIZEY/2};
	
	switch(CountFlag){
	  case 0:
		PlaySoundMem(EffectSndHandle[PlaySndType[NowCount]], DX_PLAYTYPE_BACK);
		++CountFlag, OldTime = GetNowCount();
		break;
	  case 1:
		DrawGraph( CenterX-PictHW[NowCount], CenterY-PictHH[NowCount], MainFontHandle.Count[NowCount], TRUE);
		if( GetNowCount()-OldTime>=1000 ){
			if( --NowCount<0 ){
				NowCount=3, CountFlag=0;
				return 1;
			}else CountFlag=0;
			OldTime = GetNowCount();	//ݎԂi[
		}
		break;
		default: break;
	}
	return 0;
}

//Xe[W̕\
int StageScreen(void)
{
	static int StageNum = 0;
	static int StageState = 0;	//0:O,1:Q[,2:Q[I
	//int DefX, DefY;	//{[̏ʒu
	
	switch(StageState){
	  case 0:
		//t[ƃXe[W̏
		if( InitFrame(StageNum)==-1 || InitStage(StageNum)==-1 ){
			fprintf(stderr,"intialize error\n");
			exit(1);
		}
		++StageState;//, DefX = Main;
		PlaySoundMem(BgSndHandle[StageNum+1], DX_PLAYTYPE_BACK);
		break;
		
	  case 1:	//JEg_E
		DrawGraph( 0, 0, BgImgHandle[StageNum+2], FALSE );
		GetInputRad();	//px̍XV
		MoveBall(2);	//{[̈ړ
		RenewScreen();	//XN[XV
		DrawVector();	//xNg`
		if( CountDown(StageNum) )
			++StageState;
		break;
		
	  case 2:
		DrawGraph( 0, 0, BgImgHandle[StageNum+2], FALSE );
		GetInputRad();	//px̍XV
		MoveBall(0);	//{[̈ړ
		RenewScreen();	//XN[XV
		DrawVector();	//xNg`
		
		//S[ɓ(ł̓Xy[XL[)
		if( CheckHitKey(KEY_INPUT_SPACE)==1 ){
			++StageState; WaitTimer(100);
		}
		break;
		
	  case 3:
		MoveBall(1);	//px̃Zbg
		FinStage();
		FinFrame();
		StageState = 0;
		StopSoundMem(BgSndHandle[StageNum+1]);
		if( ++StageNum==3 ){
			StageNum=0; return 1;
		}
		break;
	  default: break;
	}
	return 0;
}

//^CgʂƐʂ\
int TitleScreen(void)
{
	static int TitleState=0;
	
	switch(TitleState){
	  case 0:	//yĐJn
		PlaySoundMem( BgSndHandle[0], DX_PLAYTYPE_LOOP);
		++TitleState;
		break;
		
	  case 1:	//^Cg
		if( CheckInput() ){
			ChangeScreen(BgImgHandle[0],BgImgHandle[1]);
			++TitleState;
		}
		DrawGraph( 0, 0, BgImgHandle[0], FALSE );	//wi̕`
		break;
		
	  case 2:	//
		if( CheckInput() ){
			StopSoundMem(BgSndHandle[0]);
			ChangeScreen(BgImgHandle[1],BgImgHandle[2]);
			TitleState=0;
			return 1;
		}
		DrawGraph( 0, 0, BgImgHandle[1], FALSE );	//wi̕`
		break;
		
	  default: break;
	}
	return 0;
}
//LO
int RankingScreen(void)
{
	static int RankingState=0;
	
	switch(RankingState){
	  case 0:
		PlaySoundMem( BgSndHandle[4], DX_PLAYTYPE_LOOP);
		++RankingState;
		break;
	  case 1:
		if( CheckInput() ){
			StopSoundMem(BgSndHandle[4]);
			ChangeScreen(BgImgHandle[5],BgImgHandle[0]);
			RankingState=0;
			return 1;
		}
		DrawGraph( 0, 0, BgImgHandle[5], FALSE );
		break;
	  default: break;
	}
	return 0;
}