//------------------------------------------------
// InitFin.cpp ƏI
//------------------------------------------------

#include "Screen.h"

//WiiȐ
int InitializeWii(void)
{
	wiimotes =  wiiuse_init(1);
	if ( wiiuse_find(wiimotes, 1, 5)==NULL ){
		printf("No wiimotes found.");
		return -1;
	}
	if( wiiuse_connect(wiimotes, 1)==NULL ){
		printf("Failed to connect to any wiimote.\n");
		return -1;
	}
	wiiuse_motion_sensing(wiimotes[0], 1);	//[VZTL
	return 0;
}

//DirectXCu
int InitializeDX(void)
{
	const char *BgImgFile[]  = IMG_BG;
	const char *BgSndFile[]  = SND_BG;
	const char *EffSndFile[] = SND_EFFECT;
	int i;

#if ENABLE_WII
	//WiiR
	if( InitializeWii() == -1 )
		return -1;
#endif
	SetGraphMode(DISP_WIDTH,DISP_HEIGHT,DISP_DEPTH);	//ʉ𑜓x
	SetMainWindowText(GAME_TITLE);				//LvV
	if( !IS_FULLSCR ) ChangeWindowMode(TRUE);	//EBhE[h̐ݒ
	if( DxLib_Init() == -1 ) return -1;			//DXCu
	SetDrawScreen(DX_SCREEN_BACK);				//obNOEhɕ`i_uobt@Oj
	
	//摜t@C̃[h
	for( i=0; i<6; ++i){
		if( (BgImgHandle[i]=LoadGraph(BgImgFile[i])) == -1 )
			return -1;
	}
	//BGM̃[hDd
	for( i=0; i<5; ++i){
		if( (BgSndHandle[i]=LoadSoundMem(BgSndFile[i])) == -1 )
			return -1;
	}
	//ʉ̃[h
	for( i=0; i<5; ++i){
		if( (EffectSndHandle[i]=LoadSoundMem(EffSndFile[i])) == -1 )
			return -1;
	}
	//tHg摜̃[h
	if(LoadDivGraph(IMG_FONT_COUNT,   3, 3, 1,   COUNT_SIZEX,  COUNT_SIZEY,&MainFontHandle.Count[1])==-1) return -1;
	if(LoadDivGraph(IMG_FONT_NUMBER, 10,10, 1,  NUMBER_SIZEX, NUMBER_SIZEY, MainFontHandle.Number  )==-1) return -1;
	if(LoadDivGraph(IMG_FONT_MESSAGE, 2, 1, 2, MESSAGE_SIZEX,MESSAGE_SIZEY, MainFontHandle.Message )==-1) return -1;
	if( (MainFontHandle.Count[0]=LoadGraph(IMG_FONT_START)) == -1 ) return -1;
	
	return 0;
}

//Xe[Wƃ{[̓ǂݍ
int InitStage(int StageNum)
{
	//Xe[W摜̃t@C
	const char *StageImgFile[3] = IMG_STAGE;
	
	//摜̓ǂݍ
	MainScr.StHandle = LoadGraph(StageImgFile[StageNum]);
	MainScr.BlHandle = LoadGraph(IMG_BALL);
	MainScr.BallX = MainScr.BallY = 0;
	MainScr.Rad = 0;
	if( MainScr.StHandle==-1 || MainScr.BlHandle==-1 )
		return -1;
	return 0;
}

//Xe[WỈ摜̊J
void FinStage(void)
{
	DeleteGraph(MainScr.StHandle);
	DeleteGraph(MainScr.BlHandle);
}

//I
void FinalizeDX(void)
{
#if ENABLE_WII
	wiiuse_cleanup(wiimotes, 1);	// wiiRƂ̐ڑ
#endif
	InitGraph();	//OtBbN̊J
	InitSoundMem();	//f[^̊J
	DxLib_End();	//DxCȕI
}
