﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using NMeCab;

namespace WindowsFormsSample
{
    public partial class Form1 : Form
    {
        public MeCabLatticeLevel LatticeLevel
        {
            get
            {
                if (this.LatticeLevel0RadioButton.Checked)
                    return MeCabLatticeLevel.Zero;
                else if (this.LatticeLevel1RadioButton.Checked)
                    return MeCabLatticeLevel.One;
                else if (this.LatticeLevel2RadioButton.Checked)
                    return MeCabLatticeLevel.Two;
                else
                    return MeCabLatticeLevel.Two;
            }
            set
            {
                switch (value)
                {
                    case MeCabLatticeLevel.Zero:
                        this.LatticeLevel0RadioButton.Checked = true;
                        break;
                    case MeCabLatticeLevel.One:
                        this.LatticeLevel1RadioButton.Checked = true;
                        break;
                    case MeCabLatticeLevel.Two:
                        this.LatticeLevel2RadioButton.Checked = true;
                        break;
                    default:
                        throw new ArgumentOutOfRangeException();
                }
            }
        }

        public string OutputFormat
        {
            get
            {
                if (this.OutputFormatLatticeRadioButton.Checked)
                    return this.OutputFormatLatticeRadioButton.Text;
                else if (this.OutputFormatWakatiRadioButton.Checked)
                    return this.OutputFormatWakatiRadioButton.Text;
                else if (this.OutputFormatDumpRadioButton.Checked)
                    return this.OutputFormatDumpRadioButton.Text;
                else
                    return this.OutputFormatEmRadioButton.Text;
            }
            set
            {
                switch (value)
                {
                    case "lattice":
                        this.OutputFormatLatticeRadioButton.Checked = true;
                        break;
                    case "wakati":
                        this.OutputFormatWakatiRadioButton.Checked = true;
                        break;
                    case "dump":
                        this.OutputFormatWakatiRadioButton.Checked = true;
                        break;
                    case "em":
                        this.OutputFormatWakatiRadioButton.Checked = true;
                        break;
                    default:
                        throw new NotImplementedException();
                };
            }
        }


        public Form1()
        {
            InitializeComponent();
            this.Text = Application.ProductName;
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            //this.tagger = MeCabTagger.Create();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            MeCabParam param = new MeCabParam()
            {
                LatticeLevel = this.LatticeLevel,
                OutputFormatType = this.OutputFormat
            };
            param.LoadDicRC();
            MeCabTagger tagger = MeCabTagger.Create(param);

            this.ResultTextBox.Text = tagger.Parse(this.TargetTextBox.Text);

            tagger.Dispose();
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            //this.tagger.Dispose();
        }
    }
}
