/*
 * Copyright 2013-2014 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.unicode;

import junit.framework.TestCase;

public class UnicodeUtilsTest extends TestCase {

	static final String TEST =
			"アイドルマスター(THE IDOLM@STER) 輝きの向こう側に";

	public void testToKatakana() {
		assertEquals("アイドルマスター(THE IDOLM@STER) 輝キノ向コウ側ニ",
				UnicodeUtils.toKatakana(TEST));
	}

	public void testToHiragana() {
		assertEquals("あいどるますたー(THE IDOLM@STER) 輝きの向こう側に",
				UnicodeUtils.toHiragana(TEST));
	}

	public void testToFullWidthLatin() {
		assertEquals("アイドルマスター（ＴＨＥ ＩＤＯＬＭ＠ＳＴＥＲ） 輝きの向こう側に",
				UnicodeUtils.toFullWidthLatin(TEST));
	}

}
