/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;

import net.morilib.sh.misc.XtraceStream;

public class ShTreeFor implements ShTree {

	private ShToken variable;
	private List<ShToken> list;
	private ShTree block;

	public ShTreeFor(ShToken variable, List<ShToken> list,
			ShTree block) {
		this.variable = variable;
		this.list     = list;
		this.block    = block;
	}

	public int eval(ShEnvironment env,
			ShFileSystem fs,
			ShBuiltInCommands cmds,
			ShRuntime run,
			InputStream in,
			PrintStream out,
			PrintStream err,
			XtraceStream p) throws IOException, ShSyntaxException {
		String n = variable.toString();
		List<String> l;
		int a = 0;

		l = ShTrees.substitute(env, run, fs, err, p, list);
		for(String s : l) {
			env.put(n, s);
			a = block.eval(env, fs, cmds, run, in, out, err, p);
		}
		return a;
	}

	public void compileInternally(ShTreeExpressionMachine.Builder b,
			Object brk, Object cnt) {
		Object r = new Object(), c = new Object();

		b.addPushin(list);
		b.addLabel(c);
		b.addGetin(variable.toString(), r);
		block.compileInternally(b, r, c);
		b.addJmp(c);
		b.addLabel(r);
	}

	public String toString() {
		StringBuffer b = new StringBuffer("for ");

		b.append(variable).append(" in");
		for(ShToken t : list)  b.append(" ").append(t);
		b.append("\ndo\n").append(block);
		return b.append("\ndone").toString();
	}

}
