/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.unicode;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import net.morilib.range.CharSets;
import net.morilib.range.Range;
import net.morilib.range.integer.IntCharSets;
import net.morilib.range.integer.IntRange;
import net.morilib.regex.dfa.CharSet;

public final class UnicodeUtils {
    private static final String PROPNAME = "/" + UnicodeUtils.class.getPackage().getName().replace('.', '/') + "/charset2.txt";
    private static final Map<String, IntRange> _RANGE;

    static {
        InputStream ins = null;
        _RANGE = new HashMap<String, IntRange>();
        try {
            try {
                String s;
                ins = CharSets.class.getResourceAsStream(PROPNAME);
                BufferedReader rd = new BufferedReader(new InputStreamReader(ins));
                while ((s = rd.readLine()) != null) {
                    if (s.equals("") || s.charAt(0) == '#') continue;
                    int k = s.indexOf(61);
                    if (k < 0) {
                        _RANGE.put(s, IntRange.O);
                        continue;
                    }
                    String p = s.substring(0, k);
                    String q = s.substring(k + 1);
                    _RANGE.put(p, CharSet.parse(q));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static IntRange getPropertyIntRange(String p) {
        IntRange r = _RANGE.get(p);
        if (r != null) {
            return r;
        }
        return IntRange.O;
    }

    public static Range getPropertyRange(String p) {
        return IntCharSets.toRange(UnicodeUtils.getPropertyIntRange(p));
    }

    public static int toKatakana(int c) {
        if (c < 12353) {
            return c;
        }
        if (c <= 12438) {
            return c + 96;
        }
        return c;
    }

    public static String toKatakana(String s) {
        StringBuffer b = new StringBuffer();
        int k = 0;
        while (k < s.length()) {
            b.append((char)UnicodeUtils.toKatakana(s.charAt(k)));
            ++k;
        }
        return b.toString();
    }

    public static int toHiragana(int c) {
        if (c < 12449) {
            return c;
        }
        if (c <= 12534) {
            return c + -96;
        }
        return c;
    }

    public static String toHiragana(String s) {
        StringBuffer b = new StringBuffer();
        int k = 0;
        while (k < s.length()) {
            b.append((char)UnicodeUtils.toHiragana(s.charAt(k)));
            ++k;
        }
        return b.toString();
    }

    public static boolean isFullWidthLatin(int c) {
        return c >= 65281 && c <= 65374;
    }

    public static int toFullWidthLatin(int c) {
        if (c < 33) {
            return c;
        }
        if (c <= 126) {
            return c + 65248;
        }
        return c;
    }

    public static String toFullWidthLatin(String s) {
        StringBuffer b = new StringBuffer();
        int k = 0;
        while (k < s.length()) {
            b.append((char)UnicodeUtils.toFullWidthLatin(s.charAt(k)));
            ++k;
        }
        return b.toString();
    }

    public static int toHalfWidthLatin(int c) {
        if (c < 65281) {
            return c;
        }
        if (c <= 65374) {
            return c + -65248;
        }
        return c;
    }

    public static String toHalfWidthLatin(String s) {
        StringBuffer b = new StringBuffer();
        int k = 0;
        while (k < s.length()) {
            b.append((char)UnicodeUtils.toHalfWidthLatin(s.charAt(k)));
            ++k;
        }
        return b.toString();
    }
}

