/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import net.morilib.sh.ShBuiltInCommands;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShPattern;
import net.morilib.sh.ShRuntime;
import net.morilib.sh.ShSyntaxException;
import net.morilib.sh.ShToken;
import net.morilib.sh.ShTree;
import net.morilib.sh.ShTreeExpressionMachine;
import net.morilib.sh.ShTrees;
import net.morilib.sh.misc.XtraceStream;

public class ShTreeCase
implements ShTree {
    private List<ShPattern> patterns;
    private List<ShTree> block;
    private ShToken variable;

    public ShTreeCase(ShToken variable, List<ShPattern> patterns, List<ShTree> block) {
        this.variable = variable;
        this.patterns = new ArrayList<ShPattern>(patterns);
        this.block = new ArrayList<ShTree>(block);
    }

    @Override
    public int eval(ShEnvironment env, ShFileSystem fs, ShBuiltInCommands cmds, ShRuntime run, InputStream in, PrintStream out, PrintStream err, XtraceStream p) throws IOException, ShSyntaxException {
        String s = ShTrees.substitute(env, run, fs, err, p, this.variable);
        int i = 0;
        while (i < this.patterns.size()) {
            if (this.patterns.get(i).matches(env, fs, run, err, p, s)) {
                return this.block.get(i).eval(env, fs, cmds, run, in, out, err, p);
            }
            ++i;
        }
        return 0;
    }

    @Override
    public void compileInternally(ShTreeExpressionMachine.Builder b, Object brk, Object cnt) {
        Object l1 = null;
        Object l2 = new Object();
        int i = 0;
        while (i < this.patterns.size()) {
            if (i > 0) {
                b.addLabel(l1);
            }
            b.addPtn(this.variable, this.patterns.get(i));
            l1 = new Object();
            b.addJmpZ(l1);
            this.block.get(i).compileInternally(b, brk, cnt);
            b.addJmp(l2);
            ++i;
        }
        b.addLabel(l1);
        b.addLabel(l2);
        b.addRes();
    }

    public String toString() {
        StringBuffer b = new StringBuffer("case ");
        b.append(this.variable).append(" in\n");
        int i = 0;
        while (i < this.block.size()) {
            b.append(this.patterns.get(i));
            b.append(")\n").append(this.block.get(i)).append(";;\n");
            ++i;
        }
        return b.append("esac").toString();
    }
}

