/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PushbackReader;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShKeyword;
import net.morilib.sh.ShPromptReader;
import net.morilib.sh.ShRedirectType;
import net.morilib.sh.ShRedirector;
import net.morilib.sh.ShString;
import net.morilib.sh.ShSyntaxException;
import net.morilib.sh.ShToken;

public class ShLexer {
    private static final String BGN = "@*$!?";
    private PushbackReader reader;
    private ShPromptReader prompt;
    private ShToken token;
    private ShEnvironment env;
    private PrintStream verbose;

    public ShLexer(PushbackReader reader) {
        this.prompt = null;
        this.reader = reader;
    }

    public ShLexer(ShEnvironment env, ShPromptReader reader, PrintStream verbose) {
        this.prompt = reader;
        this.reader = new PushbackReader(reader);
        this.env = env;
        this.verbose = verbose;
    }

    public static boolean isId(int c) {
        return c >= 65 && c <= 90 || c >= 97 && c <= 122 || c >= 48 && c <= 57 || c == 95 || c > 255;
    }

    public static boolean isBound(int c) {
        return Character.isWhitespace(c) || c == 124 || c == 38 || c == 59 || c == 62 || c == 60 || c == 40 || c == 41 || c < 0;
    }

    ShToken lex() throws IOException, ShSyntaxException {
        StringBuffer b = null;
        StringBuffer l = null;
        S1 stat = S1.INIT;
        String d = null;
        int m = -1;
        this.skipsp();
        while (true) {
            int c = this.reader.read();
            switch (stat) {
                case INIT: {
                    if (c == 39) {
                        b = new StringBuffer().append((char)c);
                        this.addPrompt();
                        stat = S1.SQUT;
                        break;
                    }
                    if (c == 34) {
                        b = new StringBuffer().append((char)c);
                        this.addPrompt();
                        stat = S1.DQUT;
                        break;
                    }
                    if (c == 92) {
                        stat = S1.ESC1;
                        break;
                    }
                    if (c == 36) {
                        b = new StringBuffer().append((char)c);
                        stat = S1.VAR1;
                        break;
                    }
                    if (c == 96) {
                        b = new StringBuffer("$(");
                        this.addPrompt();
                        stat = S1.CMD3;
                        break;
                    }
                    if (c == 10) {
                        return ShToken.NEWLINE;
                    }
                    if (c == 124) {
                        stat = S1.OR_P;
                        break;
                    }
                    if (c == 38) {
                        stat = S1.ANDP;
                        break;
                    }
                    if (c == 59) {
                        stat = S1.SMCL;
                        break;
                    }
                    if (c == 60) {
                        stat = S1.R_IN;
                        m = 0;
                        break;
                    }
                    if (c == 62) {
                        stat = S1.ROUT;
                        m = 1;
                        break;
                    }
                    if (c == 40) {
                        return ShToken.PAREN_B;
                    }
                    if (c == 41) {
                        return ShToken.PAREN_E;
                    }
                    if (c >= 48 && c <= 57) {
                        b = new StringBuffer().append((char)c);
                        stat = S1.RNUM;
                        break;
                    }
                    if (c < 0) {
                        return ShToken.EOF;
                    }
                    b = new StringBuffer().append((char)c);
                    stat = S1.KEYW;
                    break;
                }
                case ESC1: {
                    if (c < 0) {
                        return new ShKeyword("\\");
                    }
                    b = new StringBuffer().append('\\').append((char)c);
                    stat = S1.KEY2;
                    break;
                }
                case SQUT: {
                    b.append((char)c);
                    if (c == 39) {
                        this.removePrompt();
                        stat = S1.KEY2;
                        break;
                    }
                    if (c >= 0) break;
                    throw new ShSyntaxException();
                }
                case DQUT: {
                    if (c == 96) {
                        b.append("$(");
                        this.addPrompt();
                        stat = S1.CMD4;
                        break;
                    }
                    if (c == 92) {
                        stat = S1.ESC2;
                        break;
                    }
                    if (c < 0) {
                        throw new ShSyntaxException();
                    }
                    b.append((char)c);
                    if (c == 34) {
                        this.removePrompt();
                        stat = S1.KEY2;
                        break;
                    }
                    if (c != 36) break;
                    stat = S1.DQT2;
                    break;
                }
                case ESC2: {
                    if (c < 0) {
                        throw new ShSyntaxException();
                    }
                    b.append("\\\\\\").append((char)c);
                    stat = S1.DQUT;
                    break;
                }
                case DQT2: {
                    if (c == 34) {
                        this.removePrompt();
                        stat = S1.KEY2;
                    } else if (c == 123) {
                        stat = S1.DQT3;
                    } else if (c == 40) {
                        this.addPrompt();
                        stat = S1.CMD1;
                    } else {
                        if (c < 0) {
                            throw new ShSyntaxException();
                        }
                        if (ShLexer.isId(c) || BGN.indexOf(c) >= 0) {
                            b.append('{');
                            stat = S1.DQT4;
                        } else {
                            stat = S1.DQUT;
                        }
                    }
                    b.append((char)c);
                    break;
                }
                case DQT3: {
                    if (c < 0 || c == 34) {
                        throw new ShSyntaxException();
                    }
                    b.append((char)c);
                    if (c != 125) break;
                    stat = S1.DQUT;
                    break;
                }
                case DQT4: {
                    if (c == 34) {
                        b.append('}');
                        stat = S1.KEY2;
                    } else if (!ShLexer.isId(c)) {
                        b.append('}');
                        stat = S1.DQUT;
                    }
                    b.append((char)c);
                    break;
                }
                case KEYW: {
                    if (ShLexer.isBound(c)) {
                        if (c >= 0) {
                            this.reader.unread(c);
                        }
                        return new ShKeyword(b.toString());
                    }
                    if (c == 96) {
                        b.append("$(");
                        stat = S1.CMD3;
                        break;
                    }
                    if (c == 92) {
                        stat = S1.ESC3;
                        break;
                    }
                    b.append((char)c);
                    if (c == 36) {
                        stat = S1.VAR1;
                        break;
                    }
                    if (c == 39) {
                        this.addPrompt();
                        stat = S1.SQUT;
                        break;
                    }
                    if (c != 34) break;
                    this.addPrompt();
                    stat = S1.DQUT;
                    break;
                }
                case KEY2: {
                    if (ShLexer.isBound(c)) {
                        if (c >= 0) {
                            this.reader.unread(c);
                        }
                        return new ShString(b.toString());
                    }
                    if (c == 96) {
                        this.addPrompt();
                        b.append("$(");
                        stat = S1.CMD3;
                        break;
                    }
                    if (c == 92) {
                        stat = S1.ESC3;
                        break;
                    }
                    b.append((char)c);
                    if (c == 36) {
                        stat = S1.VAR1;
                        break;
                    }
                    if (c == 39) {
                        this.addPrompt();
                        stat = S1.SQUT;
                        break;
                    }
                    if (c != 34) break;
                    this.addPrompt();
                    stat = S1.DQUT;
                    break;
                }
                case ESC3: {
                    b.append('\\');
                    if (c < 0) {
                        return new ShString(b.toString());
                    }
                    b.append((char)c);
                    stat = S1.KEY2;
                    break;
                }
                case VAR1: {
                    if (c == 40) {
                        b.append((char)c);
                        this.addPrompt();
                        stat = S1.CMD2;
                        break;
                    }
                    if (ShLexer.isBound(c)) {
                        if (c >= 0) {
                            this.reader.unread(c);
                        }
                        return new ShString(b.toString());
                    }
                    if (c == 123) {
                        b.append((char)c);
                        stat = S1.VAR2;
                        break;
                    }
                    b.append('{').append((char)c);
                    stat = S1.VAR3;
                    break;
                }
                case VAR2: {
                    if (c < 0) {
                        throw new ShSyntaxException();
                    }
                    b.append((char)c);
                    if (c != 125) break;
                    stat = S1.KEY2;
                    break;
                }
                case VAR3: {
                    if (ShLexer.isBound(c)) {
                        if (c >= 0) {
                            this.reader.unread(c);
                        }
                        return new ShString(b.append('}').toString());
                    }
                    if (!ShLexer.isId(c)) {
                        b.append('}');
                        stat = S1.KEY2;
                    }
                    b.append((char)c);
                    break;
                }
                case ANDP: {
                    if (c == 38) {
                        return ShToken.AND;
                    }
                    if (c == 62) {
                        return new ShRedirector(ShRedirectType.OUT, -1, -1);
                    }
                    if (c >= 0) {
                        this.reader.unread(c);
                    }
                    return ShToken.BG;
                }
                case OR_P: {
                    if (c == 124) {
                        return ShToken.OR;
                    }
                    if (c >= 0) {
                        this.reader.unread(c);
                    }
                    return ShToken.PIPE;
                }
                case SMCL: {
                    if (c == 59) {
                        return ShToken.CASEEND;
                    }
                    if (c >= 0) {
                        this.reader.unread(c);
                    }
                    return ShToken.FG;
                }
                case HERE: {
                    this.addPrompt();
                    b = new StringBuffer();
                    if (Character.isWhitespace(c)) break;
                    b.append((char)c);
                    stat = S1.HRE2;
                    break;
                }
                case HRE2: {
                    if (c < 0 || c == 10) {
                        d = b.toString();
                        b = new StringBuffer();
                        l = new StringBuffer();
                        stat = S1.HRE3;
                        break;
                    }
                    b.append((char)c);
                    break;
                }
                case HRE3: {
                    if (c == 36) {
                        l.append((char)c);
                        stat = S1.HRE4;
                        break;
                    }
                    if (c >= 0 && c != 10) {
                        l.append((char)c);
                        break;
                    }
                    if (d.equals(l.toString())) {
                        if (c >= 0) {
                            this.reader.unread((char)c);
                        }
                        this.removePrompt();
                        return new ShRedirector(b.toString());
                    }
                    b.append(l).append('\n');
                    l = new StringBuffer();
                    break;
                }
                case HRE4: {
                    if (c == 40) {
                        l.append((char)c);
                        stat = S1.HRE7;
                        break;
                    }
                    if (ShLexer.isBound(c)) {
                        l.append('$').append((char)c);
                        stat = S1.HRE3;
                        break;
                    }
                    if (c == 123) {
                        l.append((char)c);
                        stat = S1.HRE5;
                        break;
                    }
                    if (c >= 0 && c != 10) {
                        l.append('{').append((char)c);
                        stat = S1.HRE6;
                        break;
                    }
                    if (d.equals(l.toString())) {
                        if (c >= 0) {
                            this.reader.unread((char)c);
                        }
                        this.removePrompt();
                        return new ShRedirector(b.toString());
                    }
                    b.append(l).append('\n');
                    l = new StringBuffer();
                    stat = S1.HRE3;
                    break;
                }
                case HRE5: {
                    if (c >= 0 && c != 10) {
                        l.append((char)c);
                        if (c != 125) break;
                        stat = S1.HRE3;
                        break;
                    }
                    if (d.equals(l.toString())) {
                        if (c >= 0) {
                            this.reader.unread((char)c);
                        }
                        this.removePrompt();
                        return new ShRedirector(b.toString());
                    }
                    b.append(l).append('\n');
                    l = new StringBuffer();
                    stat = S1.HRE3;
                    break;
                }
                case HRE6: {
                    if (ShLexer.isId(c)) {
                        l.append((char)c);
                        break;
                    }
                    if (c >= 0 && c != 10) {
                        if (c >= 0) {
                            this.reader.unread(c);
                        }
                        l.append('}');
                        stat = S1.HRE3;
                        break;
                    }
                    if (d.equals(l.toString())) {
                        if (c >= 0) {
                            this.reader.unread((char)c);
                        }
                        this.removePrompt();
                        return new ShRedirector(b.toString());
                    }
                    b.append(l).append('}').append('\n');
                    l = new StringBuffer();
                    stat = S1.HRE3;
                    break;
                }
                case HRE7: {
                    if (c >= 0 && c != 10) {
                        l.append((char)c);
                        if (c != 41) break;
                        stat = S1.HRE3;
                        break;
                    }
                    if (d.equals(l.toString())) {
                        if (c >= 0) {
                            this.reader.unread((char)c);
                        }
                        this.removePrompt();
                        return new ShRedirector(b.toString());
                    }
                    b.append(l).append('\n');
                    l = new StringBuffer();
                    break;
                }
                case CMD1: {
                    b.append((char)c);
                    if (c == 40) {
                        stat = S1.NUM1;
                    }
                    if (c == 41) {
                        this.removePrompt();
                        stat = S1.DQUT;
                        break;
                    }
                    if (c >= 0) break;
                    throw new ShSyntaxException();
                }
                case CMD2: {
                    b.append((char)c);
                    if (c == 40) {
                        stat = S1.NUM3;
                    }
                    if (c == 41) {
                        this.removePrompt();
                        stat = S1.KEY2;
                        break;
                    }
                    if (c >= 0) break;
                    throw new ShSyntaxException();
                }
                case CMD3: {
                    if (c == 96) {
                        b.append(')');
                        this.removePrompt();
                        stat = S1.KEY2;
                        break;
                    }
                    if (c < 0) {
                        throw new ShSyntaxException();
                    }
                    b.append((char)c);
                    break;
                }
                case CMD4: {
                    if (c == 96) {
                        b.append(')');
                        this.removePrompt();
                        stat = S1.DQUT;
                        break;
                    }
                    if (c < 0) {
                        throw new ShSyntaxException();
                    }
                    b.append((char)c);
                    break;
                }
                case NUM1: {
                    b.append((char)c);
                    if (c == 41) {
                        stat = S1.NUM2;
                    }
                    if (c >= 0) break;
                    throw new ShSyntaxException();
                }
                case NUM2: {
                    b.append((char)c);
                    if (c == 41) {
                        this.removePrompt();
                        stat = S1.DQUT;
                        break;
                    }
                    if (c >= 0) break;
                    throw new ShSyntaxException();
                }
                case NUM3: {
                    b.append((char)c);
                    if (c == 41) {
                        stat = S1.NUM4;
                    }
                    if (c >= 0) break;
                    throw new ShSyntaxException();
                }
                case NUM4: {
                    b.append((char)c);
                    if (c == 41) {
                        this.removePrompt();
                        stat = S1.KEY2;
                        break;
                    }
                    if (c >= 0) break;
                    throw new ShSyntaxException();
                }
                case R_IN: {
                    if (c == 60) {
                        stat = S1.HERE;
                        break;
                    }
                    if (c == 38) {
                        stat = S1.RIN3;
                        break;
                    }
                    if (c < 0) break;
                    if (c >= 0) {
                        this.reader.unread(c);
                    }
                    return ShRedirector.IN;
                }
                case ROUT: {
                    if (c == 62) {
                        return ShRedirector.APPEND;
                    }
                    if (c == 38) {
                        stat = S1.ROT3;
                        break;
                    }
                    if (c >= 0) {
                        this.reader.unread(c);
                    }
                    return ShRedirector.OUT;
                }
                case RIN2: {
                    if (c == 38) {
                        stat = S1.RIN3;
                        break;
                    }
                    if (c < 0) break;
                    if (c >= 0) {
                        this.reader.unread(c);
                    }
                    return new ShRedirector(ShRedirectType.IN, m, -1);
                }
                case ROT2: {
                    if (c == 62) {
                        return new ShRedirector(ShRedirectType.APPEND, m, -1);
                    }
                    if (c == 38) {
                        stat = S1.ROT3;
                        break;
                    }
                    if (c >= 0) {
                        this.reader.unread(c);
                    }
                    return new ShRedirector(ShRedirectType.OUT, m, -1);
                }
                case RIN3: {
                    if (c >= 48 && c <= 57) {
                        b.append((char)c);
                        break;
                    }
                    if (b.length() == 0) {
                        throw new ShSyntaxException();
                    }
                    if (c >= 0) {
                        this.reader.unread(c);
                    }
                    return new ShRedirector(ShRedirectType.IN, m, Integer.parseInt(b.toString()));
                }
                case ROT3: {
                    if (c >= 48 && c <= 57) {
                        b.append((char)c);
                        break;
                    }
                    if (b.length() == 0) {
                        throw new ShSyntaxException();
                    }
                    if (c >= 0) {
                        this.reader.unread(c);
                    }
                    return new ShRedirector(ShRedirectType.OUT, m, Integer.parseInt(b.toString()));
                }
                case RNUM: {
                    if (c >= 48 && c <= 57) {
                        b.append((char)c);
                        break;
                    }
                    if (c == 60) {
                        m = Integer.parseInt(b.toString());
                        b = new StringBuffer();
                        stat = S1.RIN2;
                        break;
                    }
                    if (c == 62) {
                        m = Integer.parseInt(b.toString());
                        b = new StringBuffer();
                        stat = S1.ROT2;
                        break;
                    }
                    if (ShLexer.isBound(c)) {
                        if (c >= 0) {
                            this.reader.unread(c);
                        }
                        return new ShKeyword(b.toString());
                    }
                    if (c == 96) {
                        b.append("$(");
                        stat = S1.CMD3;
                        break;
                    }
                    b.append((char)c);
                    if (c == 36) {
                        stat = S1.VAR1;
                    }
                    if (c == 39) {
                        stat = S1.SQUT;
                    }
                    if (c != 34) break;
                    stat = S1.DQUT;
                }
            }
        }
    }

    ShToken lexws() throws IOException, ShSyntaxException {
        this.skipws();
        return this.lex();
    }

    public ShToken getToken() {
        return this.token;
    }

    public ShToken nextToken() throws IOException, ShSyntaxException {
        this.token = this.lex();
        if (this.env != null && this.env.isSet("verbose") && this.verbose != null) {
            if (this.token == ShToken.NEWLINE || this.token == ShToken.EOF) {
                this.verbose.print('\n');
            } else {
                this.verbose.print(this.token);
                this.verbose.print(' ');
            }
        }
        return this.token;
    }

    public ShToken nextId() throws IOException, ShSyntaxException {
        this.token = this.lex();
        if (!this.token.isString()) {
            throw new ShSyntaxException(this.token.toString());
        }
        return this.token;
    }

    public void eat(ShToken s) throws IOException, ShSyntaxException {
        if (!this.getToken().equals(s)) {
            throw new ShSyntaxException();
        }
    }

    public void eatId(String s) throws IOException, ShSyntaxException {
        if (!this.getToken().equalsKeyword(s)) {
            throw new ShSyntaxException();
        }
    }

    public void skipsp() throws IOException {
        int c;
        boolean comment = false;
        while ((c = this.reader.read()) >= 0) {
            if (comment) {
                comment = c != 10;
                if (comment) continue;
                this.reader.unread(c);
                continue;
            }
            if (c == 35) {
                comment = true;
                continue;
            }
            if (c == 10 || !Character.isWhitespace(c)) break;
        }
        if (c >= 0) {
            this.reader.unread(c);
        }
    }

    public void skipws() throws IOException {
        int c;
        boolean comment = false;
        while ((c = this.reader.read()) >= 0) {
            if (comment) {
                comment = c != 10;
                continue;
            }
            if (c == 35) {
                comment = true;
                continue;
            }
            if (!Character.isWhitespace(c)) break;
        }
        if (c >= 0) {
            this.reader.unread(c);
        }
    }

    public void addPrompt() {
        if (this.prompt != null) {
            ++this.prompt.count;
        }
    }

    public void removePrompt() {
        if (this.prompt != null) {
            --this.prompt.count;
        }
    }

    public void resetPrompt() {
        if (this.prompt != null) {
            this.prompt.resetPrompt();
        }
    }

    public boolean isEof() {
        return this.prompt == null || this.prompt.isEof();
    }

    private static enum S1 {
        INIT,
        ESC1,
        SQUT,
        DQUT,
        ESC2,
        DQT2,
        DQT3,
        DQT4,
        KEYW,
        KEY2,
        ESC3,
        VAR1,
        VAR2,
        VAR3,
        ANDP,
        OR_P,
        SMCL,
        HERE,
        HRE2,
        HRE3,
        HRE4,
        HRE5,
        HRE6,
        HRE7,
        CMD1,
        CMD2,
        CMD3,
        CMD4,
        NUM1,
        NUM2,
        NUM3,
        NUM4,
        R_IN,
        ROUT,
        RIN2,
        ROT2,
        RIN3,
        ROT3,
        RNUM;

    }
}

