/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sed;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import net.morilib.sed.SedPatternEngine;
import net.morilib.sed.SedSubstituteFlags;
import net.morilib.sed.cmd.SedLabel;
import net.morilib.sh.ShFileSystem;

public class SedSpace {
    private StringBuffer patn;
    private StringBuffer hold = null;
    private Map<String, PrintStream> writers = new HashMap<String, PrintStream>();
    SedPatternEngine engine;
    private PrintStream out;
    private ShFileSystem fs;
    String lineToAppend = null;
    String lineToInsert = null;
    String fileToRead = null;
    String fileToWrite = null;
    boolean deleted = false;
    boolean display;
    SedLabel nextLabel = null;
    private boolean succeedBefore = true;
    private boolean succeed = true;

    SedSpace(ShFileSystem fs, SedPatternEngine engine, PrintStream out, boolean disp) {
        this.engine = engine;
        this.out = out;
        this.display = disp;
    }

    public void setPatternSpace(String s) {
        this.patn = new StringBuffer(s);
    }

    public void appendPatternSpace(String s) {
        this.patn.append('\n').append(s);
    }

    public void appendPatternSpace() {
        this.patn.append('\n').append(this.hold);
    }

    public void replacePatternSpace() {
        this.patn = new StringBuffer(this.hold);
    }

    public void appendHoldSpace() {
        this.hold = this.hold == null ? new StringBuffer() : this.hold.append('\n');
        this.hold.append(this.patn);
    }

    public void replaceHoldSpace() {
        this.hold = new StringBuffer(this.patn);
    }

    public void exchange() {
        StringBuffer b = this.hold;
        this.hold = this.patn;
        this.patn = b;
    }

    public void appendLines(String string) {
        this.lineToAppend = string;
    }

    public void insertLines(String string) {
        this.lineToInsert = string;
    }

    public void deleteLine() {
        this.deleted = true;
    }

    public void printImmediate() {
        if (this.display) {
            this.out.println(this.toString());
        }
    }

    public void printImmediate(String s) {
        if (this.display) {
            this.out.println(s);
        }
    }

    void clear() {
        this.lineToInsert = null;
        this.lineToAppend = null;
        this.fileToWrite = null;
        this.fileToRead = null;
        this.succeedBefore = this.succeed;
        this.deleted = false;
        this.succeed = true;
    }

    public void setNextLabel(SedLabel l) {
        this.nextLabel = l;
    }

    public void setFileToRead(String filename) {
        this.fileToRead = filename;
    }

    public void setFileToWrite(String filename) {
        this.fileToWrite = filename;
    }

    void printFileToWrite(String s, String p) throws IOException {
        if (s == null) {
            return;
        }
        PrintStream w = this.writers.get(s);
        if (w == null) {
            w = this.fs.getFile(s).getPrintStream(false);
            this.writers.put(s, w);
        }
        w.print(p);
    }

    void printFileToWrite() throws IOException {
        this.printFileToWrite(this.fileToWrite, this.toString());
    }

    void destroy() throws IOException {
        for (Closeable closeable : this.writers.values()) {
            closeable.close();
        }
    }

    public boolean isSucceedBefore() {
        return this.succeedBefore;
    }

    public boolean isSucceed() {
        return this.succeed;
    }

    public void substitute(String pattern, String replace, SedSubstituteFlags flags) throws IOException {
        String s = this.toString();
        if ((s = this.engine.replace(pattern, s, replace, flags)) != null) {
            this.patn = new StringBuffer(s);
            this.succeed = true;
        } else {
            this.succeed = false;
        }
        if (flags.isPrint()) {
            this.out.println(this.toString());
        } else if (flags.getFileToWrite() != null) {
            this.printFileToWrite(flags.getFileToWrite(), this.toString());
        }
    }

    public void print() {
        this.out.println(this.toString());
    }

    public void printVisible() {
        String s = this.toString();
        int i = 0;
        while (i < s.length()) {
            int c = s.codePointAt(i);
            if (Character.isISOControl(c)) {
                this.out.print('\\');
                switch (c) {
                    case 7: {
                        this.out.print('a');
                        break;
                    }
                    case 8: {
                        this.out.print('b');
                        break;
                    }
                    case 9: {
                        this.out.print('t');
                        break;
                    }
                    case 10: {
                        this.out.print('n');
                        break;
                    }
                    case 11: {
                        this.out.print('v');
                        break;
                    }
                    case 12: {
                        this.out.print('f');
                        break;
                    }
                    case 13: {
                        this.out.print('r');
                        break;
                    }
                    default: {
                        this.out.print(Integer.toString(c / 64 % 8));
                        this.out.print(Integer.toString(c / 8 % 8));
                        this.out.print(Integer.toString(c % 8));
                        break;
                    }
                }
            } else if (c == 92) {
                this.out.print("\\");
            } else {
                this.out.print((char)c);
            }
            i += c > 65535 ? 2 : 1;
        }
        this.out.println("$");
    }

    public void printFirstLine() {
        String s = this.toString();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\n') break;
            this.out.print(c);
            ++i;
        }
        this.out.println();
    }

    public void print(String s) {
        this.out.println(s);
    }

    public void print(int value) {
        this.out.println(value);
    }

    public void print(long value) {
        this.out.println(value);
    }

    public void deleteFirstLine() {
        String s = this.toString();
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i++) == '\n') break;
        }
        if (i >= s.length()) {
            this.deleteLine();
        } else {
            this.patn = this.patn.delete(0, i);
        }
    }

    public String toString() {
        return this.patn == null ? "" : this.patn.toString();
    }
}

