/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.range.integer;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import net.morilib.range.integer.AbstractIntRange;
import net.morilib.range.integer.IntInterval;
import net.morilib.range.integer.IntRange;

public class IntMergedRange
extends AbstractIntRange
implements Serializable {
    SortedSet<IntInterval> intervals;

    IntMergedRange() {
        this.intervals = new TreeSet<IntInterval>();
    }

    IntMergedRange(SortedSet<IntInterval> s) {
        this.intervals = s;
    }

    @Override
    public boolean contains(int x) {
        for (IntInterval i : this.intervals) {
            if (!i.contains(x)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(IntRange r) {
        block0: for (IntInterval j : r.intervals()) {
            for (IntInterval i : this.intervals) {
                if (j.isContained(i)) continue block0;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAny(IntRange r) {
        for (IntInterval i : this.intervals) {
            for (IntInterval j : r.intervals()) {
                if (!i.containsAny(j)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isIndependent(IntRange r) {
        for (IntInterval i : this.intervals) {
            for (IntInterval j : r.intervals()) {
                if (!i.isIndependent(j)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int minimum() {
        return this.intervals.first().left;
    }

    @Override
    public int maximum() {
        return this.intervals.last().right;
    }

    @Override
    public Collection<IntInterval> intervals() {
        return Collections.unmodifiableSortedSet(this.intervals);
    }

    @Override
    public long cardinality() {
        long c = 0L;
        for (IntInterval i : this.intervals) {
            c += i.cardinality();
        }
        return c;
    }
}

