/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina.lint;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.morilib.nina.NinaCompoundException;
import net.morilib.nina.NinaException;
import net.morilib.nina.lint.LintCell;
import net.morilib.nina.lint.LintCellAlphabet;
import net.morilib.nina.lint.LintCellBlank;
import net.morilib.nina.lint.LintCellBranch;
import net.morilib.nina.lint.LintCellEntranceE;
import net.morilib.nina.lint.LintCellEntranceN;
import net.morilib.nina.lint.LintCellEntranceS;
import net.morilib.nina.lint.LintCellEntranceW;
import net.morilib.nina.lint.LintCellFrame;
import net.morilib.nina.lint.LintCellPathEW;
import net.morilib.nina.lint.LintCellPathNS;
import net.morilib.nina.lint.LintCellRotateLeft;
import net.morilib.nina.lint.LintCellRotateRight;

public class LintCells {
    private List<String> warnings = new ArrayList<String>();
    private LintCell[][] cells;
    private int yOffset;

    public LintCells(int yoff, List<int[]> a) {
        this.cells = new LintCell[a.size()][];
        int y = 0;
        while (y < a.size()) {
            this.cells[y] = new LintCell[a.get(y).length];
            int x = 0;
            while (x < a.get(y).length) {
                int c = a.get(y)[x];
                this.cells[y][x] = this.createCell(c, x, y);
                ++x;
            }
            ++y;
        }
        this.yOffset = yoff;
    }

    public LintCells(int yoff, int[][] a) {
        this.cells = new LintCell[a.length][];
        int y = 0;
        while (y < a.length) {
            this.cells[y] = new LintCell[a[y].length];
            int x = 0;
            while (x < a[y].length) {
                int c = a[y][x];
                this.cells[y][x] = this.createCell(c, x, y);
                ++x;
            }
            ++y;
        }
        this.yOffset = yoff;
    }

    private LintCell createCell(int c, int x, int y) {
        switch (c) {
            case 45: {
                return new LintCellPathEW(this, c, x, y);
            }
            case 124: {
                return new LintCellPathNS(this, c, x, y);
            }
            case 43: {
                return new LintCellBranch(this, c, x, y);
            }
            case 92: {
                return new LintCellRotateRight(this, c, x, y);
            }
            case 47: {
                return new LintCellRotateLeft(this, c, x, y);
            }
            case 60: {
                return new LintCellEntranceW(this, c, x, y);
            }
            case 62: {
                return new LintCellEntranceE(this, c, x, y);
            }
            case 94: {
                return new LintCellEntranceN(this, c, x, y);
            }
            case 118: {
                return new LintCellEntranceS(this, c, x, y);
            }
            case 38: 
            case 42: 
            case 61: 
            case 64: {
                return new LintCellFrame(this, c, x, y);
            }
            case 32: {
                return new LintCellBlank(this, c, x, y);
            }
        }
        return new LintCellAlphabet(this, c, x, y);
    }

    void addWarning(String msg, Object ... args) {
        this.warnings.add(NinaException.getMessage(msg, args));
    }

    public List<String> getWarnings() {
        return Collections.unmodifiableList(this.warnings);
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public void setYOffset(int y) {
        this.yOffset = y;
    }

    public LintCell get(int x, int y) {
        if (y < 0 || y >= this.cells.length) {
            return new LintCellBlank(this, 0, x, y);
        }
        if (x < 0 || x >= this.cells[y].length) {
            return new LintCellBlank(this, 0, x, y);
        }
        return this.cells[y][x];
    }

    public void putBadfile(PrintStream out) {
        int y = 0;
        while (y < this.cells.length) {
            int x = 0;
            while (x < this.cells[y].length) {
                LintCell c = this.cells[y][x];
                if (c.isError()) {
                    out.print('X');
                } else if (c.getCharacter() >= 0) {
                    out.print((char)this.cells[y][x].getCharacter());
                }
                ++x;
            }
            out.println();
            ++y;
        }
    }

    public void putBadfile(String fname) throws IOException {
        try (PrintStream out = null;){
            out = new PrintStream(new FileOutputStream(fname));
            this.putBadfile(out);
        }
    }

    public boolean validate(PrintStream out) {
        ArrayList<NinaException> l = new ArrayList<NinaException>();
        int y = 0;
        while (y < this.cells.length) {
            if (this.cells[y].length != 0 && this.cells[y][0].getCharacter() != 35) {
                int x = 0;
                while (x < this.cells[y].length) {
                    try {
                        this.cells[y][x].validate();
                    }
                    catch (NinaException e) {
                        this.cells[y][x].error = true;
                        l.add(e);
                    }
                    ++x;
                }
            }
            ++y;
        }
        if (l.size() > 0) {
            throw new NinaCompoundException(l, this);
        }
        if (out != null && this.warnings.size() > 0) {
            String a = NinaException.getMessage("warning", new Object[0]);
            for (String s : this.warnings) {
                out.printf("%s: %s\n", a, s);
            }
            return true;
        }
        return false;
    }
}

