/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.morilib.lisp.nano.Atom;
import net.morilib.lisp.nano.LispInteger;
import net.morilib.lisp.nano.LispReal;
import net.morilib.lisp.nano.LispString;

public abstract class LispNumber
extends Atom {
    static String disp(double n) {
        if (n == Double.POSITIVE_INFINITY) {
            return "+inf.0";
        }
        if (n == Double.NEGATIVE_INFINITY) {
            return "-inf.0";
        }
        if (Double.isNaN(n)) {
            return "+nan.0";
        }
        return Double.toString(n);
    }

    public abstract LispNumber add(LispNumber var1);

    public abstract LispNumber sub(LispNumber var1);

    public abstract LispNumber mul(LispNumber var1);

    public abstract LispNumber div(LispNumber var1);

    public abstract LispNumber uminus();

    public abstract boolean isEqualTo(LispNumber var1);

    public abstract boolean isInteger();

    public abstract boolean isRational();

    public abstract boolean isReal();

    public abstract boolean isExact();

    public abstract LispNumber toExact();

    public abstract LispNumber toInexact();

    public abstract LispString toLispString(int var1);

    public abstract LispString toLispString(int var1, int var2);

    public abstract LispReal norm();

    public abstract LispNumber conjugate();

    public abstract boolean isNaN();

    public abstract boolean isOne();

    @Override
    public abstract int getInt();

    @Override
    public abstract long getLong();

    @Override
    public abstract BigInteger getBigInteger();

    @Override
    public abstract BigDecimal getBigDecimal();

    @Override
    public abstract double getRealDouble();

    @Override
    public float getRealFloat() {
        return (float)this.getRealDouble();
    }

    public abstract BigInteger getNumerator();

    public abstract BigInteger getDenominator();

    public abstract LispReal[] getImags();

    public abstract double[] getImagsDouble();

    public LispNumber pow(int n) {
        LispNumber r = LispInteger.ONE;
        if (n >= 0) {
            int i = 0;
            while (i < n) {
                r = ((LispNumber)r).mul(this);
                ++i;
            }
        } else {
            int i = 0;
            while (i < -n) {
                r = ((LispNumber)r).div(this);
                ++i;
            }
        }
        return r;
    }

    public LispNumber inv() {
        return LispInteger.ONE.div(this);
    }

    public int getExactSmallInt() {
        throw new NumberFormatException();
    }

    public LispString toLispString() {
        return this.toLispString(10);
    }

    public boolean isZero() {
        return this.isEqualTo(LispInteger.ZERO);
    }

    public abstract boolean isFinite();
}

