/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.nano.statement;

import net.morilib.awk.nano.AwkBreakException;
import net.morilib.awk.nano.AwkContinueException;
import net.morilib.awk.nano.expr.AwkExpression;
import net.morilib.awk.nano.io.AwkFiles;
import net.morilib.awk.nano.namespace.AwkNamespace;
import net.morilib.awk.nano.statement.AwkExpressionMachine;
import net.morilib.awk.nano.value.AwkUndefined;
import net.morilib.awk.nano.value.AwkValue;

public class AwkWhile
extends AwkExpression {
    private AwkExpression cond;
    private AwkExpression stmt;

    public AwkWhile(AwkExpression cond, AwkExpression stmt) {
        this.cond = cond;
        this.stmt = stmt;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AwkValue eval(AwkNamespace ns, AwkFiles o) {
        AwkValue v = AwkUndefined.UNDEF;
        try {
            while (true) {
                if (!this.cond.eval(ns, o).toBoolean(ns)) {
                    return v;
                }
                try {
                    v = this.stmt.eval(ns, o);
                }
                catch (AwkContinueException awkContinueException) {
                    // empty catch block
                }
            }
        }
        catch (AwkBreakException awkBreakException) {
            // empty catch block
        }
        return v;
    }

    @Override
    public void compileInternally(AwkExpressionMachine.Builder b, Object brk, Object cnt) {
        Object l1 = new Object();
        Object l2 = new Object();
        b.addLabel(l1);
        b.add(this.cond);
        b.addJmpZ(l2);
        this.stmt.compileInternally(b, l2, l1);
        b.addJmp(l1);
        b.addLabel(l2);
    }
}

