/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.nano.printf;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.morilib.awk.nano.printf.PrintfAction;
import net.morilib.awk.nano.printf.PrintfActionC;
import net.morilib.awk.nano.printf.PrintfActionE;
import net.morilib.awk.nano.printf.PrintfActionF;
import net.morilib.awk.nano.printf.PrintfActionG;
import net.morilib.awk.nano.printf.PrintfActionInteger;
import net.morilib.awk.nano.printf.PrintfActionS;
import net.morilib.awk.nano.value.AwkUndefined;
import net.morilib.awk.nano.value.AwkValue;

public class Printf {
    static final int ZERO = 1;
    static final int SIGN = 2;
    static final int SIGN_BLANK = 4;
    static final int LEFT = 8;
    static final int SIGN_MASK = 6;
    private Map<Integer, PrintfAction> actions;
    private int fchr;

    public Printf(int fchr, Map<Integer, PrintfAction> actions) {
        this.fchr = fchr;
        this.actions = new HashMap<Integer, PrintfAction>(actions);
    }

    Printf(int fchr, Map<Integer, PrintfAction> actions, boolean d) {
        this.fchr = fchr;
        this.actions = actions;
    }

    public static Printf getInstance() {
        HashMap<Integer, PrintfAction> a = new HashMap<Integer, PrintfAction>();
        a.put(115, new PrintfActionS());
        a.put(100, new PrintfActionInteger(10, false));
        a.put(120, new PrintfActionInteger(16, false));
        a.put(88, new PrintfActionInteger(16, true));
        a.put(111, new PrintfActionInteger(8, false));
        a.put(101, new PrintfActionE());
        a.put(102, new PrintfActionF());
        a.put(103, new PrintfActionG());
        a.put(99, new PrintfActionC());
        return new Printf(37, a, false);
    }

    public void format(Writer b, String format, final Object ... args) throws IOException {
        int flg = 0;
        int w = -1;
        int p = -1;
        int t = -1;
        S1 s = S1.INIT;
        Iterator<AwkValue> ai = new Iterator<AwkValue>(){
            int p0 = 0;

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public AwkValue next() {
                return this.p0 < args.length ? (AwkValue)args[this.p0++] : AwkUndefined.UNDEF;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        int i = 0;
        while (i < format.length()) {
            char c = format.charAt(i);
            switch (s) {
                case INIT: {
                    if (c == this.fchr) {
                        t = i;
                        s = S1.FLAG;
                        break;
                    }
                    b.append(c);
                    break;
                }
                case FLAG: {
                    if (c == this.fchr) {
                        b.append(c);
                        s = S1.INIT;
                        break;
                    }
                    if (c == '0' && !(flg & true)) {
                        flg |= 1;
                        break;
                    }
                    if (c == '+' && (flg & 6) == 0) {
                        flg |= 2;
                        break;
                    }
                    if (c == ' ' && (flg & 6) == 0) {
                        flg |= 4;
                        break;
                    }
                    if (c == '-' && (flg & 8) == 0) {
                        flg |= 8;
                        break;
                    }
                    if (c == '*') {
                        w = ((AwkValue)ai.next()).toInteger().intValue();
                        s = S1.WID2;
                        break;
                    }
                    if (c >= '1' && c <= '9') {
                        w = c - 48;
                        s = S1.WIDT;
                        break;
                    }
                    if (c == '.') {
                        p = 0;
                        s = S1.PREC;
                        break;
                    }
                    PrintfAction a = this.actions.get(c);
                    if (a == null) {
                        b.append(format.subSequence(t, i + 1));
                    } else {
                        a.action(b, flg, w, p, ai.next());
                    }
                    s = S1.INIT;
                    break;
                }
                case WIDT: {
                    if (c >= '0' && c <= '9') {
                        w = w * 10 + (c - 48);
                        break;
                    }
                }
                case WID2: {
                    if (c == '.') {
                        p = 0;
                        s = S1.PREC;
                        break;
                    }
                    PrintfAction a = this.actions.get(c);
                    if (a == null) {
                        b.append(format.subSequence(t, i + 1));
                    } else {
                        a.action(b, flg, w, p, ai.next());
                    }
                    s = c == this.fchr ? S1.FLAG : S1.INIT;
                    break;
                }
                case PREC: {
                    if (c >= '0' && c <= '9') {
                        p = p * 10 + (c - 48);
                        break;
                    }
                    if (c == '*') {
                        p = ((AwkValue)ai.next()).toInteger().intValue();
                        s = S1.PRC2;
                        break;
                    }
                }
                case PRC2: {
                    PrintfAction a = this.actions.get(c);
                    if (a == null) {
                        b.append(format.subSequence(t, i + 1));
                    } else {
                        a.action(b, flg, w, p, ai.next());
                    }
                    s = c == this.fchr ? S1.FLAG : S1.INIT;
                }
            }
            i += c > '\uffff' ? 2 : 1;
        }
    }

    public String format(String format, Object ... args) {
        StringWriter b = new StringWriter();
        try {
            this.format(b, format, args);
            return b.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void fill(Writer b, char c, int s, int e) throws IOException {
        int i = s;
        while (i < e) {
            b.append(c);
            ++i;
        }
    }

    static void indent(Writer b, String s, char c, int flags, int e) throws IOException {
        if ((flags & 8) != 0) {
            b.append(s);
            Printf.fill(b, c, s.length(), e);
        } else {
            Printf.fill(b, c, s.length(), e);
            b.append(s);
        }
    }

    static void indentNumber(Writer b, String s, int flags, int w) throws IOException {
        if (w < 0 && w <= s.length()) {
            b.append(s);
        } else if ((flags & 8) == 0 && (flags & 1) != 0) {
            char f = s.charAt(0);
            if (f == '+' || f == '-' || f == ' ') {
                s = s.substring(1);
                b.append(f);
                --w;
            }
            Printf.indent(b, s, '0', flags, w);
        } else {
            Printf.indent(b, s, ' ', flags, w);
        }
    }

    private static void flagsToString(StringBuffer b, int flags) {
        if ((flags & 1) != 0) {
            b.append('0');
        }
        if ((flags & 2) != 0) {
            b.append('+');
        }
        if ((flags & 4) != 0) {
            b.append(' ');
        }
        if ((flags & 8) != 0) {
            b.append('-');
        }
    }

    static String formatToString(int flags, int w, int p) {
        StringBuffer b = new StringBuffer("%");
        Printf.flagsToString(b, flags);
        if (w >= 0) {
            b.append(w);
        }
        if (p >= 0) {
            b.append(".").append(p);
        }
        return b.toString();
    }

    static enum S1 {
        INIT,
        FLAG,
        WIDT,
        WID2,
        PREC,
        PRC2;

    }
}

