package net.morilib.nina.interpret;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.ResourceBundle;

import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

import net.morilib.nina.NinaConsole;
import net.morilib.nina.cmd.NinaInfo;
import net.morilib.nina.cmd.NinatOptions;
import net.morilib.nina.translate.NinaTranslator;
import net.morilib.nina.translate.NinaTranslatorJavaScript;

public class NinaScript {

	private static ResourceBundle msgs =
			NinatOptions.getMessages();

	private final NinaInfo info = new NinaInfo() {

		public void print(String p, Object... a) {
			out.format(msgs.getString(p), a);
			out.println();
		}

		public void perror(String p, Object... a) {
			out.print(msgs.getString("errorheader"));
			out.format(msgs.getString(p), a);
			out.println();
		}

		public void pwarn(String p, Object... a) {
			out.print(msgs.getString("warnheader"));
			out.format(msgs.getString(p), a);
			out.println();
		}

		public void pmessage(String p) {
			out.print(msgs.getString("errorheader"));
			out.println(p);
		}

		@Override
		public String getOutputFilename() {
			return "script";
		}

		@Override
		public String getFilename() {
			return "script";
		}

		@Override
		public String getClassName() {
			return "script";
		}

		@Override
		public String getBufSize() {
			return "1024";
		}

		@Override
		public File getTitleFile(String s) {
			return null;
		}

		@Override
		public String getOutputDir() {
			return "";
		}

		@Override
		public NinaConsole getConsole() {
			return this;
		}

	};

	//
	private PrintWriter out = new PrintWriter(new StringWriter());
	private CompiledScript js;
	private Bindings bind = new SimpleBindings();

	private NinaScript() {}

	/**
	 * 
	 * @param rd
	 * @return
	 * @throws IOException
	 * @throws ScriptException
	 */
	public static NinaScript newInstance(
			Reader rd) throws IOException, ScriptException {
		NinaScript sc = new NinaScript();
		ByteArrayOutputStream ot;
		ScriptEngineManager mn;
		ScriptEngine en;
		NinaTranslator nt;
		PrintStream pt;

		nt = new NinaTranslatorJavaScript();
		ot = new ByteArrayOutputStream();
		pt = new PrintStream(ot, true);
		nt.translate("script", rd, sc.info,
				Collections.<String>emptyList(),
				new HashMap<String, String>(), pt);
		mn = new ScriptEngineManager();
		en = mn.getEngineByName("javascript");
		sc.js = ((Compilable)en).compile(ot.toString());
		return sc;
	}

	/**
	 * 
	 * @param s
	 * @return
	 * @throws ScriptException
	 */
	public static NinaScript newInstance(
			String s) throws ScriptException {
		try {
			return newInstance(new StringReader(s));
		} catch(IOException e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * 
	 * @param rd
	 * @return
	 * @throws ScriptException
	 * @throws IOException
	 */
	public static Object eval(
			Reader rd) throws ScriptException, IOException {
		return newInstance(rd).eval();
	}

	/**
	 * 
	 * @param s
	 * @return
	 * @throws ScriptException
	 */
	public static Object eval(String s) throws ScriptException {
		return newInstance(s).eval();
	}

	/**
	 * 
	 * @param name
	 * @param o
	 */
	public void bind(String name, Object o) {
		bind.put(name, o);
	}

	/**
	 * 
	 * @return
	 * @throws ScriptException
	 */
	public Object eval() throws ScriptException {
		return js.eval(bind);
	}

}
