/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2014/02/10
 */
public class NinaLanguageOptionJava implements NinaLanguageOption {

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getLookahead()
	 */
	@Override
	public String getLookahead() {
		return "LOOKAHEAD($c);";
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getLookaheadCommit()
	 */
	@Override
	public String getLookaheadCommit() {
		return "LOOKAHEAD_COMMIT();";
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getLookaheadMark()
	 */
	@Override
	public String getLookaheadMark() {
		return "LOOKAHEAD_MARK();";
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getUnget()
	 */
	@Override
	public String getUnget() {
		return "UNGET($c);";
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getAssignArray(java.lang.String, int)
	 */
	@Override
	public String getAssignArray(String s, int k) {
		return String.format("%s[%d] = (char)$c;", s, k);
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getInitBuffer(java.lang.String)
	 */
	@Override
	public String getInitBuffer(String s) {
		return s + " = new StringBuffer();";
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.NinaLanguageOption#getAppendBuffer(java.lang.String)
	 */
	@Override
	public String getAppendBuffer(String s) {
		return s + ".append((char)$c);";
	}

}
