/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina;

import java.util.Map;
import java.util.Set;

import net.morilib.automata.NFA;
import net.morilib.automata.NFAState;
import net.morilib.range.Range;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/10/13
 */
public interface NinaAction {

	/**
	 * 
	 * @param e
	 * @param rd
	 * @param accept
	 */
	public void labelAdded(NinaEvent e, NinaFrameReader rd,
			boolean accept);

	/**
	 * 
	 * @param q
	 * @param ver
	 */
	public void link(NinaEvent q, Object ver);

	/**
	 * 
	 * @return
	 */
	public String getLabel();

	/**
	 * 
	 * @return
	 */
	public Object getVertex();

	/**
	 * 
	 * @return
	 */
	public void setVertex(Object o);

	/**
	 * @param q
	 */
	public void doneBlockSearching(NinaEvent q);

	/**
	 * @param q
	 * @param o
	 */
	public void setEdge(NinaEvent q, Object o);

	/**
	 * @param q
	 * @param o
	 */
	public void setEdgeCharSequence(NinaEvent q, CharSequence o,
			int qc);

	/**
	 * 
	 * @param q
	 */
	public void setEdgeEnd(NinaEvent q);

	/**
	 * @param q
	 * @param o
	 */
	public void setUserEdge(NinaEvent q, String o);

	/**
	 * 
	 * @param c
	 */
	public void setMealyEdge(int c);

	/**
	 * 
	 * @param o
	 */
	public void setMealyEdge(Object o);

	/**
	 * 
	 * @param q
	 * @param p
	 * @param s
	 * @param map
	 * @param sub
	 */
	public void setEdgeResource(NinaEvent q,
			NinaParser p,
			String s,
			Map<String, String> map,
			Map<String, Object> sub);

	/**
	 * 
	 * @param q
	 * @param p
	 * @param s
	 */
	public void setEdgeNFA(NinaEvent q, NinaParser p,
			NFA<Object, NFAState, Void> s);

	/**
	 * 
	 * @param q
	 * @param var
	 */
	public void setEdgeDynamic(NinaEvent q, String var);

	/**
	 * 
	 * @param q
	 * @return
	 */
	public NinaAction accept(String name);

	/**
	 * 
	 * @param p
	 */
	public void setPriority(int p);

	/**
	 * 
	 * @return
	 */
	public Object createState(NinaEvent q);

	/**
	 * 
	 * @param l
	 * @param s
	 */
	public void putStateByLabel(String l, Object s);

	/**
	 * 
	 * @param l
	 * @return
	 */
	public Object getStateByLabel(String l);

	/**
	 * 
	 * @param s
	 * @return
	 */
	public String getLabelByState(Object s);

	/**
	 * 
	 * @return
	 */
	public Object getDeadState();

	/**
	 * 
	 * @return
	 */
	public Object getMachine();

	/**
	 * 
	 * @param o
	 */
	public void setStartState(Object o);

	/**
	 * 
	 * @return
	 */
	public Set<String> getLabels();

	/**
	 * 
	 * @param l
	 * @param s
	 */
	public void putTypeByLabel(String l, String s);

	/**
	 * 
	 * @param l
	 * @return
	 */
	public String getTypeByLabel(String l);

	/**
	 * 
	 * @return
	 */
	public String getName();

	/**
	 * 
	 * @param q
	 * @param len
	 */
	public void setEdgeSequence(NinaEvent q, Range r, int len);

	/**
	 * 
	 * @param c
	 */
	public void setMealyEdgeType(int c);

	/**
	 * 
	 * @param accept
	 */
	public void setAccept(boolean accept);

	/**
	 * 
	 * @param q
	 * @param name
	 */
	public void setEdgeGrammar(NinaEvent q, String name);

	/**
	 * 
	 * @return
	 */
	public Map<String, String> getDynamicTransitMap();

}
