echo '// Translated by Nina'
echo '// This source code is under public domain'
[ -z "$PACKAGE" ] || echo "package $PACKAGE;"
[ -z "$EXTENDS" ] || extends="extends $EXTENDS"
[ -z "$IMPLEMENTS" ] || implements="implements $IMPLEMENTS"
print_imports

cat << EOF

public $ABSTRACT class ${CLASSNAME}${TEMPLATE} $extends $implements {

	public static final Object ENDMARKER = new Object() {

		public String toString() {
			return "<END>";
		}

	};

	private int state;
	private Object iseof = null;
EOF
if [ -z "$TYPE" ]
then
  echo "	private $CTYPE unread = -1;"
  echo '	private String matched;'
else
  echo "	private $CTYPE unread = null;"
fi

echo
cat fragment
echo

if [ -z "$TYPE" ]
then
  cat << EOF
	private int _read(java.io.Reader rd) throws java.io.IOException {
		int c;

		if(unread >= 0) {
			c = unread;
			unread = -1;
		} else if((c = rd.read()) < 0) {
			iseof = ENDMARKER;
		}
		return c;
	}
EOF
else
  cat << EOF
	private $CTYPE _read(java.util.Iterator<$CTYPE> itr) {
		$CTYPE c;

		if(unread != null) {
			c = unread;
			unread = null;
			return c;
		} else if(itr.hasNext()) {
			return itr.next();
		} else {
			return null;
		}
	}
EOF
fi

echo
echo "	private boolean _step($CTYPE c) {"
echo '		switch(state) {'
print_states
echo '		}'
echo '		return false;'
echo '	}'
echo

echo '	private boolean _accepted() {'
print_accepts
echo '	}'
echo

if [ -z "$TYPE" ]
then
  echo '	private Object _gettoken(StringBuffer b) {'
  echo '		String $$ = b.toString();'
else
  echo "	private Object _gettoken(java.util.List<$CTYPE> b) {"
  echo "		java.util.List<$CTYPE>" '$$ = b;'
fi
echo
echo '		switch(state) {'
print_token
echo '		default:  return null;'
echo '		}'
echo '	}'
echo

if [ -z "$TYPE" ]
then
  cat << EOF
	public boolean matches(String s) {
		int n;

		state = 0;  matched = null;
		for(n = 0; n < s.length(); n++) {
			if(!_step(s.charAt(n))) {
				return false;
			}
		}

		if(_accepted()) {
			matched = s;
			return true;
		} else {
			return false;
		}
	}

	public boolean lookingAt(String s) {
		StringBuffer b = new StringBuffer();
		int n;

		state = 0;  matched = null;
		for(n = 0; n < s.length(); n++) {
			if(_accepted()) {
				matched = b.toString();
			}

			if(_step(s.charAt(n))) {
				// do nothing
			} else {
				return matched != null;
			}
			b.append(s.charAt(n));
		}

		if(_accepted()) {
			matched = b.toString();
			return true;
		} else {
			return matched != null;
		}
	}

	public boolean find(String s) {
		StringBuffer b;
		int n, k;

		state = 0;  matched = null;
		for(k = 0; k < s.length(); k++) {
			b = new StringBuffer();
			for(n = k; n < s.length(); n++) {
				if(_accepted()) {
					matched = b.toString();
				}

				if(_step(s.charAt(n))) {
					// do noting
				} else if(matched == null) {
					break;
				} else {
					return true;
				}
				b.append(s.charAt(n));
			}

			if(_accepted()) {
				matched = b.toString();
				return true;
			} else if(matched != null) {
				return true;
			} else {
				state = 0;
			}
		}
		return false;
	}

	public String group() {
		return matched;
	}

	public Object searchToken(
			java.io.Reader rd) throws java.io.IOException {
		StringBuffer b = new StringBuffer();
		boolean f = false;
		Object o = null;
		int c;

		if(iseof != null)  return iseof;
		while((c = _read(rd)) >= 0) {
			b.appendCodePoint(c);
			if(!_step(c)) {
				if(f) {
					unread = c;
					state = 0;
					return o;
				} else {
					return null;
				}
			} else if(f = _accepted()) {
				o = _gettoken(b);
			}
		}
		return f ? o : null;
	}

}
EOF
else
  cat << EOF
	public Object searchToken(java.util.Iterator<$CTYPE> itr) {
		java.util.List<$CTYPE> b = new java.util.ArrayList<$CTYPE>();
		boolean f = false;
		Object o = null;
		$CTYPE c;

		if(iseof != null)  return iseof;
		while((c = _read(itr)) != null) {
			b.add(c);
			if(!_step(c)) {
				if(f) {
					unread = c;
					state = 0;
					return o;
				} else {
					return null;
				}
			} else if(f = _accepted()) {
				o = _gettoken(b);
			}
		}
		return f ? o : null;
	}

}
EOF
fi
