/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina.translate.sh;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.nina.cmd.NinatOptions;
import net.morilib.nina.translate.sh.ShNinaRealFile;
import net.morilib.sh.AbstractShFileSystem;
import net.morilib.sh.DefaultShVirtualDirectory;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFile;
import net.morilib.sh.ShProcess;
import net.morilib.sh.ShSecurityPolicy;
import net.morilib.sh.ShStat;

public class ShNinatFileSystem
extends AbstractShFileSystem {
    private static final Pattern PTN1 = Pattern.compile("/output/([^/]+)");
    private DefaultShVirtualDirectory root = new DefaultShVirtualDirectory(null, null);
    private ShFile fragmentFile;
    private ShFile outputDir;
    private NinatOptions options;
    private String fragment;
    private File outputDirName;

    public ShNinatFileSystem(String f, NinatOptions opts) {
        this.fragment = f;
        this.options = opts;
        this.fragmentFile = new ShFile(){

            @Override
            public boolean isDirectory() {
                return false;
            }

            @Override
            public boolean isExecutable() {
                return false;
            }

            @Override
            public boolean isExist() {
                return true;
            }

            @Override
            public boolean isFile() {
                return true;
            }

            @Override
            public boolean isReadable() {
                return true;
            }

            @Override
            public boolean isWritable() {
                return false;
            }

            @Override
            public boolean isHidden() {
                return false;
            }

            @Override
            public boolean isZeroFile() {
                return ShNinatFileSystem.this.fragment.length() == 0;
            }

            @Override
            public long getLastModified() {
                return 0L;
            }

            @Override
            public String getName() {
                return "fragment";
            }

            @Override
            public Collection<ShFile> getFiles() {
                return Collections.emptySet();
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(ShNinatFileSystem.this.fragment.getBytes());
            }

            @Override
            public PrintStream getPrintStream(boolean append) throws IOException {
                return null;
            }

            @Override
            public ShProcess getProcess() {
                return null;
            }

            @Override
            public ShFile toAbsolute() {
                return this;
            }

            @Override
            public ShFile toCanonical() {
                return this;
            }

            @Override
            public boolean mkdir() {
                return false;
            }

            @Override
            public boolean renameTo(ShFile f) {
                return false;
            }

            @Override
            public void setLastModified(long time) {
            }

            @Override
            public boolean rmdir() {
                return false;
            }

            @Override
            public boolean deleteFile() {
                return false;
            }

            @Override
            public ShStat getStat() {
                return new ShStat(this.toString(), 0L, ShNinatFileSystem.this.fragment.getBytes().length, 1);
            }

            public String toString() {
                return "/fragment";
            }
        };
        this.root.addFile(this.fragmentFile);
        String s = this.options.getOption("output");
        s = s.equals("") ? "." : s;
        this.outputDirName = new File(s);
        this.outputDir = new ShNinaRealFile(this, "/output", this.outputDirName);
        this.root.addFile(this.outputDir);
    }

    @Override
    public ShFile getRoot() {
        return this.root;
    }

    @Override
    public ShFile getFile(String s) {
        if (s.equals("/")) {
            return this.root;
        }
        if (s.equals("fragment")) {
            return this.fragmentFile;
        }
        if (s.equals("/output")) {
            return this.outputDir;
        }
        Matcher m = PTN1.matcher(s);
        if (m.matches()) {
            return new ShNinaRealFile(this, s, new File(this.outputDirName, m.group(1)));
        }
        return null;
    }

    @Override
    public ShFile getFile(String dir, String name) {
        return this.getFile(this.getFile(dir), name);
    }

    @Override
    public ShFile getFile(ShFile dir, String name) {
        return null;
    }

    @Override
    public ShFile getNativeFile(String s) {
        return this.getFile(s);
    }

    @Override
    public ShSecurityPolicy getSecurityPolicy() {
        return ShSecurityPolicy.ALL_PERMITTED;
    }

    @Override
    public InputStream getProfile() {
        return null;
    }

    @Override
    public InputStream getRc() {
        return null;
    }

    @Override
    public ShFile getHome() {
        return this.getRoot();
    }

    @Override
    public ShFile searchPath(ShEnvironment env, String name) {
        return null;
    }
}

