/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina.translate;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import net.morilib.automata.DFAState;
import net.morilib.nina.NinaState;
import net.morilib.nina.translate.AbstractNinaTranslator;
import net.morilib.nina.translate.NinaTranslator;
import net.morilib.range.Interval;

public class NinaTranslatorJava
extends AbstractNinaTranslator {
    private static final Pattern RET_CONST = Pattern.compile("return +([A-Za-z][A-Za-z0-9]*\\.)*[A-Z][A-Z0-9]*;");
    private int stateNo = 0;
    private Map<DFAState<Object, ?, Void>, Integer> states = new IdentityHashMap();
    private Set<Integer> accepts = new HashSet<Integer>();
    private Stack<DFAState<Object, ?, Void>> trz = new Stack();

    private void printintv(PrintStream out, Interval v, boolean els) {
        String s = v.isInfimumClosed() ? ">=" : ">";
        String t = v.isSupremumClosed() ? "<=" : "<";
        String a = els ? "\t\t\t} else if" : "\t\t\tif";
        out.format("%s(c %s %d && c %s %d) {\n", a, s, (int)((Integer)v.getInfimumBound()), t, (int)((Integer)v.getSupremumBound()));
    }

    private void printobj(PrintStream out, Object o, boolean els) {
        String a = els ? "\t\t\t} else if" : "\t\t\tif";
        out.format("%s(c.equals(\"%s\")) {\n", a, o.toString());
    }

    private void printclass(PrintStream out, Object o, boolean els) {
        String a = els ? "\t\t\t} else if" : "\t\t\tif";
        out.format("%s(c instanceof %s) {\n", a, o.toString());
    }

    private void printState(PrintStream out, DFAState<Object, ?, Void> dfa) {
        int sn = this.getStateNo(dfa);
        boolean els = false;
        out.format("\t\tcase %d:\n", sn);
        for (Interval v : dfa.getAlphabetRanges()) {
            Object o;
            this.printintv(out, v, els);
            int c = (Integer)v.getInfimumBound();
            if (v.isInfimumOpen()) {
                ++c;
            }
            if ((o = dfa.getLabelInt(c)) != null) {
                out.format("\t\t\t\t%s\n", o.toString());
            }
            DFAState<Object, ?, Void> d = dfa.goInt(c);
            out.format("\t\t\t\tstate = %d;\n", this.getStateNo(d));
            out.println("\t\t\t\treturn true;");
            els = true;
        }
        if (els) {
            out.println("\t\t\t}");
        }
        out.println("\t\t\treturn false;");
    }

    private void printObjectState(PrintStream out, DFAState<Object, ?, Void> dfa) {
        int sn = this.getStateNo(dfa);
        boolean els = false;
        out.format("\t\tcase %d:\n", sn);
        for (Object o : dfa.getAlphabets()) {
            this.printobj(out, o, els);
            DFAState<Object, ?, Void> d = dfa.go(o);
            out.format("\t\t\t\tstate = %d;\n", this.getStateNo(d));
            out.println("\t\t\t\treturn true;");
            els = true;
        }
        if (els) {
            out.println("\t\t\t}");
        }
        out.println("\t\t\treturn false;");
    }

    private void printClassState(PrintStream out, DFAState<Object, ?, Void> dfa) {
        int sn = this.getStateNo(dfa);
        boolean els = false;
        out.format("\t\tcase %d:\n", sn);
        for (Object o : dfa.getAlphabets()) {
            this.printclass(out, o, els);
            DFAState<Object, ?, Void> d = dfa.go(o);
            out.format("\t\t\t\tstate = %d;\n", this.getStateNo(d));
            out.println("\t\t\t\treturn true;");
            els = true;
        }
        if (els) {
            out.println("\t\t\t}");
        }
        out.println("\t\t\treturn false;");
    }

    private int getStateNo(DFAState<Object, ?, Void> state) {
        if (this.states.containsKey(state)) {
            return this.states.get(state);
        }
        this.states.put(state, this.stateNo);
        if (state.isAccepted()) {
            this.accepts.add(this.stateNo);
        }
        this.trz.push(state);
        return this.stateNo++;
    }

    @Override
    public void printStates(PrintStream out) {
        DFAState<Object, Object, Object> s = this.dfa.getInitialState();
        this.getStateNo(s);
        while (!this.trz.isEmpty()) {
            s = this.trz.pop();
            this.printState(out, s);
        }
    }

    @Override
    public void printObjectStates(PrintStream out) {
        DFAState<Object, Object, Object> s = this.dfa.getInitialState();
        this.states.put(s, this.stateNo++);
        this.trz.push(s);
        while (!this.trz.isEmpty()) {
            s = this.trz.pop();
            this.printObjectState(out, s);
        }
    }

    @Override
    public void printClassStates(PrintStream out) {
        DFAState<Object, Object, Object> s = this.dfa.getInitialState();
        this.states.put(s, this.stateNo++);
        this.trz.push(s);
        while (!this.trz.isEmpty()) {
            s = this.trz.pop();
            this.printClassState(out, s);
        }
    }

    @Override
    public void printAcceptStates(PrintStream out) {
        String d = "\t\treturn (";
        if (this.accepts.size() == 0) {
            out.println("\t\treturn false;");
        } else {
            for (Integer i : this.accepts) {
                out.print(d);
                out.format("state == %d", i);
                d = " ||\n\t\t\t\t";
            }
            out.println(");");
        }
    }

    @Override
    public void printAcceptToken(PrintStream out) {
        for (DFAState<Object, ?, Void> s : this.states.keySet()) {
            if (!s.isAccepted()) continue;
            String p = null;
            out.format("\t\tcase %d:\n", this.states.get(s));
            for (Object a : s.getAccepted()) {
                String x;
                if (a == null || !(a instanceof NinaState) || (x = ((NinaState)a).getLabel()) == null || (x = x.trim()).equals("")) continue;
                if (RET_CONST.matcher(x).matches()) {
                    p = x;
                    break;
                }
                if (p != null) {
                    this.options.pwarn("ambiguousaccept", new Object[0]);
                }
                p = x;
            }
            out.format("\t\t\t%s\n", p != null ? p : "return $$;");
        }
    }

    @Override
    public void printActions(PrintStream out) {
        for (DFAState<Object, ?, Void> s : this.states.keySet()) {
            String p = null;
            out.format("\t\tcase %d:\n", this.states.get(s));
            String x = s.toString();
            if (x != null && !(x = x.trim()).equals("")) {
                p = x;
            }
            if (p == null) {
                out.println("\t\t\tbreak;");
                continue;
            }
            out.format("\t\t\t%s\n", p);
            out.println("\t\t\tbreak;");
        }
    }

    @Override
    public void printImports(List<String> imp, PrintStream out) {
        for (String s : imp) {
            out.format("import %s;\n", s);
        }
    }

    @Override
    public void reportStatistics(PrintStream std) {
        this.options.print("statheader", new Object[0]);
        this.options.print("statstates", this.states.size());
        this.options.print("stataccept", this.accepts.size());
    }

    @Override
    protected InputStream openScript() {
        return NinaTranslator.class.getResourceAsStream("/net/morilib/nina/translate/nina_template." + this.machine + ".java.sh");
    }

    @Override
    protected PrintStream openOutput() throws IOException {
        return new PrintStream(new FileOutputStream(this.options.getJavaFile()), true);
    }
}

