/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina.translate;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.List;
import net.morilib.automata.DFA;
import net.morilib.automata.dfa.ConvertedDFA;
import net.morilib.automata.dfa.ConvertedRangeDFA;
import net.morilib.automata.dfa.MinimizedRangeDFA;
import net.morilib.nina.NinaNFA;
import net.morilib.nina.NinaParser;
import net.morilib.nina.Quadro;
import net.morilib.nina.cmd.NinatOptions;
import net.morilib.nina.translate.NinaTranslator;
import net.morilib.nina.translate.sh.ShNinatBuiltInCommands;
import net.morilib.nina.translate.sh.ShNinatFileSystem;
import net.morilib.sh.DefaultShRuntime;
import net.morilib.sh.ShBuiltInCommands;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFacade;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;
import net.morilib.sh.ShRootEnvironment;
import net.morilib.sh.ShRuntime;
import net.morilib.sh.ShSyntaxException;
import net.morilib.sh.misc.XtraceStream;

public abstract class AbstractNinaTranslator
implements NinaTranslator {
    protected NinatOptions options;
    protected DFA<Object, ?, Void> dfa;
    protected String machine;
    private String fragment;

    public static NinaTranslator getTranslator(String lang) {
        try {
            String p = AbstractNinaTranslator.class.getPackage().getName();
            Class<?> c = Class.forName(String.valueOf(p) + ".NinaTranslator" + lang);
            return (NinaTranslator)c.newInstance();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract void printStates(PrintStream var1);

    public abstract void printObjectStates(PrintStream var1);

    public abstract void printClassStates(PrintStream var1);

    public abstract void printAcceptStates(PrintStream var1);

    public abstract void printAcceptToken(PrintStream var1);

    public abstract void printActions(PrintStream var1);

    public abstract void printImports(List<String> var1, PrintStream var2);

    protected abstract InputStream openScript() throws IOException;

    protected abstract PrintStream openOutput() throws IOException;

    private void processNFA(NinaNFA n, String p, String t, ShNinatBuiltInCommands cmd, ShEnvironment env) throws IOException {
        PrintStream ous = null;
        InputStream ins = null;
        this.dfa = t == null ? ConvertedRangeDFA.convertDFA(n) : ConvertedDFA.convertDFA(n);
        if (!this.options.getOption("minimize").equalsIgnoreCase("no")) {
            this.dfa = MinimizedRangeDFA.newInstance(this.dfa);
        }
        try {
            try {
                ins = this.openScript();
                ous = this.openOutput();
                ShNinatFileSystem fs = new ShNinatFileSystem(this.fragment, this.options);
                cmd.putCommand("print_token", new ShProcess(){

                    @Override
                    public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream stdout, PrintStream stderr, String ... args) throws IOException {
                        AbstractNinaTranslator.this.printAcceptToken(stdout);
                        return 0;
                    }
                });
                DefaultShRuntime run = new DefaultShRuntime(cmd);
                XtraceStream qs = new XtraceStream(System.out);
                ShFacade.execute(env, (ShFileSystem)fs, (ShBuiltInCommands)cmd, (ShRuntime)run, ins, System.in, ous, System.err, qs);
            }
            catch (ShSyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (ins != null) {
                ins.close();
            }
            if (ous != null) {
                ous.close();
            }
        }
    }

    private void processDFA(DFA<Object, Object, Void> d, String p, ShNinatBuiltInCommands cmd, ShEnvironment env) throws IOException {
        PrintStream ous = null;
        InputStream ins = null;
        this.dfa = d;
        try {
            try {
                ins = this.openScript();
                ous = this.openOutput();
                ShNinatFileSystem fs = new ShNinatFileSystem(this.fragment, this.options);
                cmd.putCommand("print_actions", new ShProcess(){

                    @Override
                    public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream stdout, PrintStream stderr, String ... args) throws IOException {
                        AbstractNinaTranslator.this.printActions(stdout);
                        return 0;
                    }
                });
                DefaultShRuntime run = new DefaultShRuntime(cmd);
                XtraceStream qs = new XtraceStream(System.out);
                ShFacade.execute(env, (ShFileSystem)fs, (ShBuiltInCommands)cmd, (ShRuntime)run, ins, System.in, ous, System.err, qs);
            }
            catch (ShSyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (ins != null) {
                ins.close();
            }
            if (ous != null) {
                ous.close();
            }
        }
    }

    private ShEnvironment getenv(String p, Quadro q) {
        ShRootEnvironment env = new ShRootEnvironment();
        char[] a = this.options.getFilename().toCharArray();
        a[0] = Character.toUpperCase(a[0]);
        env.bind("CLASSNAME", new String(a));
        env.bind("PACKAGE", p);
        env.bind("FILENAME", this.options.getFilename());
        String s = this.options.getOption("bufsize");
        s = s.equals("") ? "1024" : s;
        env.bind("BUFSIZE", s);
        env.bind("TEMPLATE", q.getOption("template"));
        env.bind("EXTENDS", q.getOption("extends"));
        env.bind("IMPLEMENTS", q.getOption("implements"));
        env.bind("ABSTRACT", q.isOptionDefined("abstract") ? "abstract" : "");
        s = q.getType();
        if (s == null || s.equals("char")) {
            env.bind("TYPE", "");
            env.bind("CTYPE", "int");
        } else if (s.equals("string")) {
            env.bind("TYPE", s);
            env.bind("CTYPE", "String");
        } else if (s.equals("class")) {
            env.bind("TYPE", s);
            env.bind("CTYPE", "Object");
        } else {
            env.bind("TYPE", s);
            env.bind("CTYPE", s);
        }
        return env;
    }

    @Override
    public void translate(Reader rd, NinatOptions opts) throws IOException {
        this.options = opts;
        final Quadro q = Quadro.read(rd);
        Object o = NinaParser.complie(q, opts.getLibraryList());
        String m = q.getOption("machine");
        if (m != null) {
            m = "unknown";
        }
        this.fragment = q.getFragment();
        String p = opts.getOption("package");
        if ((p == null || p.equals("")) && ((p = q.getRootPackage()) == null || p.equals(""))) {
            p = "";
        }
        ShEnvironment env = this.getenv(p, q);
        ShNinatBuiltInCommands cmd = new ShNinatBuiltInCommands();
        cmd.putCommand("print_states", new ShProcess(){

            @Override
            public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream stdout, PrintStream stderr, String ... args) throws IOException {
                if (q.getType() == null) {
                    AbstractNinaTranslator.this.printStates(stdout);
                } else if (q.getType().equals("class")) {
                    AbstractNinaTranslator.this.printClassStates(stdout);
                } else {
                    AbstractNinaTranslator.this.printObjectStates(stdout);
                }
                return 0;
            }
        });
        cmd.putCommand("print_accepts", new ShProcess(){

            @Override
            public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream stdout, PrintStream stderr, String ... args) throws IOException {
                AbstractNinaTranslator.this.printAcceptStates(stdout);
                return 0;
            }
        });
        cmd.putCommand("print_imports", new ShProcess(){

            @Override
            public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream stdout, PrintStream stderr, String ... args) throws IOException {
                AbstractNinaTranslator.this.printImports(q.getImports(), stdout);
                return 0;
            }
        });
        if (o instanceof NinaNFA) {
            this.machine = "nfa";
            this.processNFA((NinaNFA)o, p, q.getType(), cmd, env);
        } else if (o instanceof DFA) {
            this.machine = "dfa";
            this.processDFA((DFA)o, p, cmd, env);
        } else {
            opts.perror("machinenotsupport", m);
        }
    }
}

