/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.morilib.nina.NinaEvent;
import net.morilib.nina.QuadroImpl;

public abstract class Quadro
implements NinaEvent {
    static final int EQ_TO_LEFT = -1;
    static final int BLANKX = -2;
    static final int BLANKY = -3;
    static final int E2 = -100;
    static final int W2 = -101;
    static final int N2 = -102;
    static final int S2 = -103;
    static final int E3 = -200;
    static final int W3 = -201;
    static final int N3 = -202;
    static final int S3 = -203;
    static final int DONE = -300;
    static final int ENTRY = -301;
    static final int WARP2 = -400;
    static final int WARP3 = -402;
    Map<String, String> options = new HashMap<String, String>();
    List<String> imports = new ArrayList<String>();
    String fragment;
    String type;

    static int len(char c) {
        Character.UnicodeBlock b = Character.UnicodeBlock.of(c);
        if (b == null) {
            return 1;
        }
        if (b.equals(Character.UnicodeBlock.CJK_COMPATIBILITY) || b.equals(Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS) || b.equals(Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS) || b.equals(Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT) || b.equals(Character.UnicodeBlock.CJK_RADICALS_SUPPLEMENT) || b.equals(Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION) || b.equals(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS) || b.equals(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A) || b.equals(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B) || b.equals(Character.UnicodeBlock.KATAKANA) || b.equals(Character.UnicodeBlock.HIRAGANA) || b.equals(Character.UnicodeBlock.HANGUL_SYLLABLES)) {
            return 2;
        }
        return 1;
    }

    static int len(String s) {
        int r = 0;
        int i = 0;
        while (i < s.length()) {
            r += Quadro.len(s.charAt(i));
            ++i;
        }
        return r;
    }

    public static Quadro readResource(String name) throws IOException {
        InputStream in = null;
        try {
            in = Quadro.class.getResourceAsStream(name);
            InputStreamReader rd = new InputStreamReader(in);
            Quadro quadro = Quadro.read(rd);
            return quadro;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static Quadro read(String s) {
        try {
            StringReader r = new StringReader(s);
            return Quadro.read(r);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Quadro read(Reader rd) throws IOException {
        String s;
        BufferedReader br = new BufferedReader(rd);
        ArrayList<int[]> l = new ArrayList<int[]>();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        while ((s = br.readLine()) != null && !s.equals("%%")) {
            if (s.equals("")) continue;
            int[] a = new int[Quadro.len(s)];
            int i = 0;
            int j = 0;
            while (j < s.length()) {
                int m = Quadro.len(s.charAt(j));
                a[i] = s.charAt(j);
                int k = i + 1;
                while (k < i + m) {
                    a[k] = -1;
                    ++k;
                }
                i += m;
                ++j;
            }
            l.add(a);
        }
        while ((s = br.readLine()) != null) {
            pw.println(s);
        }
        pw.flush();
        return new QuadroImpl(l, sw.toString());
    }

    @Override
    public String getOption(String s) {
        return this.options.get(s);
    }

    public boolean isOptionDefined(String s) {
        return this.options.get(s) != null;
    }

    @Override
    public boolean getOptionBoolean(String s) {
        String x = this.options.get(s);
        if (x == null) {
            return false;
        }
        return x.equalsIgnoreCase("true") || x.equalsIgnoreCase("yes") || x.equalsIgnoreCase("oui");
    }

    public String getType() {
        return this.type;
    }

    public List<String> getImports() {
        return Collections.unmodifiableList(this.imports);
    }

    void addImports(String s) {
        this.imports.add(s);
    }

    public String getFragment() {
        return this.fragment != null ? this.fragment : "";
    }

    @Override
    public abstract String getRootResource();

    @Override
    public abstract String getRootPackage();

    public abstract void setRootResource(String var1);

    public abstract void setRootPackage(String var1);

    @Override
    public abstract Object getEdge();

    @Override
    public abstract void setEdge(Object var1);

    public abstract boolean isInBounds();

    @Override
    public abstract int get();

    @Override
    public abstract Object getScratch();

    public abstract boolean isBlankX();

    public abstract boolean isBlankY();

    public abstract boolean isLetter();

    public abstract boolean isDigit();

    public abstract boolean isArrow();

    public abstract boolean isEntry();

    public abstract boolean isDone();

    public abstract boolean isFrame();

    public abstract boolean isArrow2();

    public abstract boolean isArrow3();

    public abstract boolean isWhitespace();

    public abstract void set(int var1);

    @Override
    public abstract void setScratch(Object var1);

    public abstract Quadro move(Direction var1);

    public abstract Quadro move(int var1, int var2);

    public abstract Quadro west();

    public abstract Quadro east();

    public abstract Quadro north();

    public abstract Quadro south();

    public abstract Quadro cr();

    public void printTrace(PrintStream pr) {
        pr.println(this.toString());
    }

    public static enum Direction {
        WEST,
        EAST,
        NORTH,
        SOUTH,
        CR;

    }
}

