/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.morilib.automata.NFA;
import net.morilib.automata.NFAState;
import net.morilib.automata.nfa.NFAAccept;
import net.morilib.automata.nfa.NFAConcatenation;
import net.morilib.automata.nfa.NFAObject;
import net.morilib.automata.nfa.RegexParseException;
import net.morilib.automata.nfa.RegexpParser;
import net.morilib.automata.nfa.SingleObjectNFA;
import net.morilib.nina.Nina;
import net.morilib.nina.NinaAction;
import net.morilib.nina.NinaFrameReader;
import net.morilib.nina.NinaParseException;
import net.morilib.nina.Quadro;
import net.morilib.range.CharSets;
import net.morilib.util.CharCodes;

public class NinaParser {
    static final int _PAUSE = 1;
    static final int _PRINT = 2;
    private Map<String, String> pragmas = new HashMap<String, String>();
    private Quadro q;
    private S etat = S.INIT;
    private List<String> libs = Collections.emptyList();
    private StringBuffer buf = new StringBuffer();
    private StringBuffer bf2 = new StringBuffer();
    private Class<?> type = Character.TYPE;
    private NinaAction action;
    private int pause;
    private int chr;

    NinaParser(Quadro q, NinaAction action) {
        this.q = q;
        this.action = action;
    }

    private InputStream findLib(String n) {
        File f = new File(n);
        if (f.isFile()) {
            try {
                return new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        for (String s : this.libs) {
            f = new File(new File(s), n);
            if (!f.isFile()) continue;
            try {
                return new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    Object _compileRes(String n, NinaAction action) {
        InputStream in = null;
        try {
            in = this.findLib(n);
            Quadro q = in != null ? Quadro.read(new InputStreamReader(in)) : Quadro.readResource(n);
            Object object = NinaParser.compile(q, action, this.libs, this.pause);
            return object;
        }
        catch (IOException e) {
            throw new NinaParseException(e, "ioerror", new Object[0]);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new NinaParseException(e, "ioerror", new Object[0]);
                }
            }
        }
    }

    static Object compile(Quadro q, NinaAction action, List<String> libs, int p) {
        Object o;
        NinaParser c = new NinaParser(q, action);
        try {
            if (libs != null) {
                c.libs = libs;
            }
            while ((o = c.step()) == null) {
                if ((p & 2) == 0) continue;
                if ((p & 1) != 0 && System.in.read() == 13) {
                    System.in.read();
                }
                c.printTrace(System.out);
            }
        }
        catch (IOException e) {
            throw new NinaParseException(e, "ioerror", new Object[0]);
        }
        return o;
    }

    public static Object complie(Quadro q, List<String> libs) {
        return NinaParser.compile(q, null, (List<String>)(libs != null ? new ArrayList<String>(libs) : null), 0);
    }

    public static Object complie(Quadro q) {
        return NinaParser.compile(q, null, null, 0);
    }

    private String prendCharset() {
        String s = this.q.options.get("charset");
        return s != null ? s : "UTF-8";
    }

    private int prendCharcode(int c) {
        String s = this.prendCharset();
        try {
            int x = CharCodes.unicodeToOtherCode((char)c, s);
            return x;
        }
        catch (UnsupportedEncodingException e) {
            throw new NinaParseException(e, "unsupportedcharset", s);
        }
    }

    private void metBord(char c) {
        char[] a = new char[1];
        if (this.type.equals(Character.TYPE)) {
            int x = this.prendCharcode(c);
            this.action.setEdge(this.q, x);
        } else if (this.type.equals(String.class)) {
            a[0] = c;
            this.action.setEdge(this.q, new String(a));
        } else {
            throw new ClassCastException();
        }
    }

    private void metBord(String s) {
        if (this.type.equals(Character.TYPE)) {
            if (s.length() == 0) {
                throw new NinaParseException("emptystring", new Object[0]);
            }
            if (s.length() == 1) {
                Integer c = this.prendCharcode(s.charAt(0));
                this.action.setEdge(this.q, c);
            } else {
                NFAObject o;
                ArrayList l = new ArrayList();
                int k = 0;
                while (k < s.length()) {
                    Integer c = this.prendCharcode(s.charAt(k));
                    o = SingleObjectNFA.newInstance(c);
                    l.add(o);
                    ++k;
                }
                o = NFAConcatenation.newInstance(l);
                this.action.setEdge(this.q, NFAAccept.newInstance(o, null));
            }
        } else if (this.type.equals(String.class)) {
            this.action.setEdge(this.q, s);
        } else if (this.type.equals(Class.class)) {
            this.action.setEdge(this.q, s);
        } else if (this.type.isInstance(Integer.class) || this.type.equals(Integer.TYPE)) {
            this.action.setEdge(this.q, Integer.valueOf(s));
        } else if (this.type.isInstance(Long.class) || this.type.equals(Long.TYPE)) {
            this.action.setEdge(this.q, Long.valueOf(s));
        } else if (this.type.isInstance(Float.class) || this.type.equals(Float.TYPE)) {
            this.action.setEdge(this.q, Double.valueOf(s));
        } else if (this.type.isInstance(Double.class) || this.type.equals(Double.TYPE)) {
            this.action.setEdge(this.q, Double.valueOf(s));
        } else if (this.type.isInstance(BigInteger.class)) {
            this.action.setEdge(this.q, new BigInteger(s));
        } else if (this.type.isInstance(BigDecimal.class)) {
            this.action.setEdge(this.q, new BigDecimal(s));
        } else {
            throw new ClassCastException();
        }
    }

    private void metBordRes(String s) {
        this.action.setEdgeResource(this.q, this, s);
    }

    private void metBordCharset(String s) {
        if (!this.type.equals(Character.TYPE)) {
            throw new ClassCastException();
        }
        this.action.setEdge(this.q, CharSets.parse(s, this.prendCharset()));
    }

    private void metBordNFA(NFA<Object, NFAState, Void> s) {
        this.action.setEdge(this.q, s);
    }

    private void metmealy() {
        if (this.chr < 0) {
            this.action.setMealyEdge(this.buf.reverse().toString());
        } else {
            this.action.setMealyEdge((char)this.chr);
        }
    }

    Object step() {
        switch (this.etat) {
            case INIT: {
                if (this.q.get() == 35) {
                    this.buf = new StringBuffer();
                    this.q.east();
                    this.etat = S.PRAG;
                    break;
                }
                if (this.q.isBlankY()) {
                    throw new NinaParseException(this, "unexpectedeof", new Object[0]);
                }
                if (this.q.isBlankX()) break;
                this.etat = S.LINIT;
                break;
            }
            case PRAG: {
                if (this.q.get() == -1) {
                    this.q.east();
                    break;
                }
                if (this.q.isLetter()) {
                    this.buf.appendCodePoint(this.q.get());
                    this.q.east();
                    break;
                }
                if (!Character.isWhitespace(this.q.get())) {
                    this.q.east();
                    this.etat = S.COMNT;
                    break;
                }
                if (this.buf.toString().equals("package")) {
                    this.buf = new StringBuffer();
                    this.q.east();
                    this.etat = S.PACK;
                    break;
                }
                if (this.buf.toString().equals("machine")) {
                    this.buf = new StringBuffer();
                    this.q.east();
                    this.etat = S.MACHN;
                    break;
                }
                if (this.buf.toString().equals("type")) {
                    this.buf = new StringBuffer();
                    this.q.east();
                    this.etat = S.TYPE;
                    break;
                }
                if (this.buf.toString().equals("option")) {
                    this.buf = new StringBuffer();
                    this.q.east();
                    this.etat = S.OPTN;
                    break;
                }
                if (this.buf.toString().equals("import")) {
                    this.buf = new StringBuffer();
                    this.q.east();
                    this.etat = S.IMPR;
                    break;
                }
                this.etat = S.COMNT;
                break;
            }
            case PACK: {
                if (this.q.get() == -1) {
                    this.q.east();
                    break;
                }
                if (this.q.isLetter() || this.q.isDigit() || this.q.get() == 46) {
                    this.buf.appendCodePoint(this.q.get());
                    this.q.east();
                    break;
                }
                String s = this.buf.toString().trim();
                this.q.setRootPackage(s);
                this.q.setRootResource("/" + s.replace('.', '/'));
                this.pragmas.put("package", s);
                this.etat = S.COMNT;
                break;
            }
            case MACHN: {
                if (this.q.get() == -1) {
                    this.q.east();
                    break;
                }
                if (this.q.isLetter() || this.q.get() == 46) {
                    this.buf.appendCodePoint(this.q.get());
                    this.q.east();
                    break;
                }
                String s = this.buf.toString().trim();
                this.pragmas.put("machine", s);
                this.q.options.put("machine", s);
                if (s.indexOf(46) < 0) {
                    s = String.valueOf(this.getClass().getPackage().getName()) + "." + s;
                }
                NinaAction n = (NinaAction)Nina.prendClasse(s);
                if (this.action == null) {
                    this.action = n;
                } else if (!this.action.getClass().equals(n.getClass())) {
                    throw new NinaParseException(this, "unknownmachine", s);
                }
                this.etat = S.COMNT;
                break;
            }
            case TYPE: {
                String s = null;
                if (this.q.get() == -1) {
                    this.q.east();
                } else if (this.q.isLetter() || this.q.get() == 46) {
                    this.buf.appendCodePoint(this.q.get());
                    this.q.east();
                } else {
                    s = this.buf.toString().trim();
                    if (s.equals("char")) {
                        this.type = Character.TYPE;
                        this.etat = S.COMNT;
                    } else if (s.equals("int")) {
                        this.type = Integer.TYPE;
                        this.etat = S.COMNT;
                    } else if (s.equals("long")) {
                        this.type = Long.TYPE;
                        this.etat = S.COMNT;
                    } else if (s.equals("float")) {
                        this.type = Float.TYPE;
                        this.etat = S.COMNT;
                    } else if (s.equals("double")) {
                        this.type = Double.TYPE;
                        this.etat = S.COMNT;
                    } else if (s.equals("string")) {
                        this.type = String.class;
                        this.etat = S.COMNT;
                    } else if (s.equals("class")) {
                        this.type = Class.class;
                        this.etat = S.COMNT;
                    } else {
                        this.type = (Class)Nina.prendClasse(s);
                        this.etat = S.COMNT;
                    }
                }
                if (s == null) break;
                this.q.type = s;
                this.pragmas.put("type", this.q.type);
                break;
            }
            case OPTN: {
                if (this.q.get() == -1) {
                    this.q.east();
                    break;
                }
                if (this.q.get() == 61) {
                    this.bf2 = new StringBuffer();
                    this.q.east();
                    this.etat = S.OPTV;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.appendCodePoint(this.q.get());
                    this.q.east();
                    break;
                }
                this.q.options.put(this.buf.toString(), "");
                this.etat = S.COMNT;
                break;
            }
            case OPTV: {
                if (this.q.get() == -1) {
                    this.q.east();
                    break;
                }
                if (this.q.get() == 39) {
                    this.q.east();
                    this.etat = S.OPTQ;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.bf2.appendCodePoint(this.q.get());
                    this.q.east();
                    break;
                }
                this.q.options.put(this.buf.toString(), this.bf2.toString());
                this.etat = S.COMNT;
                break;
            }
            case OPTQ: {
                if (this.q.get() == 39) {
                    this.q.east();
                    this.etat = S.OPTV;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.bf2.appendCodePoint(this.q.get());
                    this.q.east();
                    break;
                }
                throw new NinaParseException(this, "invalidoption", new Object[0]);
            }
            case IMPR: {
                if (this.q.get() == -1) {
                    this.q.east();
                    break;
                }
                if (this.q.isLetter() || this.q.isDigit() || this.q.get() == 46) {
                    this.buf.appendCodePoint(this.q.get());
                    this.q.east();
                    break;
                }
                String s = this.buf.toString().trim();
                this.q.addImports(s);
                this.etat = S.COMNT;
                break;
            }
            case COMNT: {
                if (this.q.isBlankX()) {
                    this.q.cr();
                    this.etat = S.INIT;
                    break;
                }
                if (this.q.isBlankY()) {
                    throw new NinaParseException(this, "unexpectedeof", new Object[0]);
                }
                this.q.east();
                break;
            }
            case LINIT: {
                if (this.q.get() == 61 || this.q.get() == 38) {
                    this.etat = S.LBLE;
                    break;
                }
                if (this.q.isBlankX()) {
                    this.q.cr();
                    break;
                }
                if (this.q.isBlankY()) {
                    throw new NinaParseException(this, "unexpectedeof", new Object[0]);
                }
                this.q.east();
                break;
            }
            case LBLE: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    int c = this.q.get();
                    this.q.south().east();
                    NinaFrameReader rd = new NinaFrameReader(this.q);
                    this.action.labelAdded(this.q, rd, c == 64 || c == 38);
                    rd.close();
                    this.etat = S.FMNW;
                    break;
                }
                this.q.west();
                break;
            }
            case FMNW: {
                if (this.q.isFrame()) {
                    this.q.east();
                    this.etat = S.FMNW2;
                    break;
                }
                throw new NinaParseException(this, "invalidframe", new Object[0]);
            }
            case FMNW2: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.etat = S.FM_E;
                } else {
                    throw new NinaParseException(this, "invalidframe", new Object[0]);
                }
            }
            case FM_E: {
                this.q.setScratch(this.action.getVertex());
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.q.east();
                    break;
                }
                if (this.q.isDone()) {
                    this.q.west();
                    this.etat = S.FRR_W;
                    break;
                }
                this.q.west();
                this.etat = S.FMNE;
                break;
            }
            case FMNE: {
                if (this.q.isFrame()) {
                    this.q.south();
                    this.etat = S.FMNE2;
                    break;
                }
                throw new NinaParseException(this, "invalidframe", new Object[0]);
            }
            case FMNE2: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.etat = S.FM_S;
                    break;
                }
                throw new NinaParseException(this, "invalidframe", new Object[0]);
            }
            case FM_S: {
                this.q.setScratch(this.action.getVertex());
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.q.south();
                    break;
                }
                if (this.q.isDone()) {
                    this.q.north();
                    this.etat = S.FRR_N;
                    break;
                }
                this.q.north();
                this.etat = S.FMSE;
                break;
            }
            case FMSE: {
                if (this.q.isFrame()) {
                    this.q.west();
                    this.etat = S.FMSE2;
                    break;
                }
                throw new NinaParseException(this, "invalidframe", new Object[0]);
            }
            case FMSE2: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.etat = S.FM_W;
                    break;
                }
                throw new NinaParseException(this, "invalidframe", new Object[0]);
            }
            case FM_W: {
                this.q.setScratch(this.action.getVertex());
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.q.west();
                    break;
                }
                if (this.q.isDone()) {
                    this.q.east();
                    this.etat = S.FRR_E;
                    break;
                }
                this.q.east();
                this.etat = S.FMSW;
                break;
            }
            case FMSW: {
                if (this.q.isFrame()) {
                    this.etat = S.FMSW2;
                    break;
                }
                throw new NinaParseException(this, "invalidframe", new Object[0]);
            }
            case FMSW2: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.etat = S.FM_N;
                    break;
                }
                throw new NinaParseException(this, "invalidframe", new Object[0]);
            }
            case FM_N: {
                this.q.setScratch(this.action.getVertex());
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.q.north();
                    break;
                }
                if (this.q.isDone()) {
                    this.q.south();
                    this.etat = S.FRNW;
                    break;
                }
                this.q.south();
                this.etat = S.FRNW;
                this.action.doneBlockSearching(this.q);
                break;
            }
            case FRNW: {
                if (this.q.isFrame()) {
                    this.q.east();
                    this.etat = S.FRNW2;
                    break;
                }
                throw new NinaParseException(this, "invalidframe", new Object[0]);
            }
            case FRNW2: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.etat = S.FR_E;
                } else {
                    throw new NinaParseException(this, "invalidframe", new Object[0]);
                }
            }
            case FR_E: {
                if (this.q.get() == 94) {
                    this.action.setVertex(this.q.getScratch());
                    this.action.setEdge(this.q, null);
                    this.q.north();
                    this.etat = S.AR_N;
                    break;
                }
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.q.east();
                    break;
                }
                if (this.q.isDone()) {
                    this.q.west();
                    this.etat = S.FRR_W;
                    break;
                }
                this.q.west();
                this.etat = S.FRNE;
                break;
            }
            case FRNE: {
                if (this.q.isFrame()) {
                    this.q.south();
                    this.etat = S.FRNE2;
                    break;
                }
                throw new NinaParseException(this, "invalidframe", new Object[0]);
            }
            case FRNE2: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.etat = S.FR_S;
                    break;
                }
                throw new NinaParseException(this, "invalidframe", new Object[0]);
            }
            case FR_S: {
                if (this.q.get() == 62) {
                    this.action.setVertex(this.q.getScratch());
                    this.action.setEdge(this.q, null);
                    this.q.east();
                    this.etat = S.AR_E;
                    break;
                }
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.q.south();
                    break;
                }
                if (this.q.isDone()) {
                    this.q.north();
                    this.etat = S.FRR_N;
                    break;
                }
                this.q.north();
                this.etat = S.FRSE;
                break;
            }
            case FRSE: {
                if (this.q.isFrame()) {
                    this.q.west();
                    this.etat = S.FRSE2;
                    break;
                }
                throw new NinaParseException(this, "invalidframe", new Object[0]);
            }
            case FRSE2: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.etat = S.FR_W;
                    break;
                }
                throw new NinaParseException(this, "invalidframe", new Object[0]);
            }
            case FR_W: {
                if (this.q.get() == 118) {
                    this.action.setVertex(this.q.getScratch());
                    this.action.setEdge(this.q, null);
                    this.q.south();
                    this.etat = S.AR_S;
                    break;
                }
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.q.west();
                    break;
                }
                if (this.q.isDone()) {
                    this.q.east();
                    this.etat = S.FRR_E;
                    break;
                }
                this.q.east();
                this.etat = S.FRSW;
                break;
            }
            case FRSW: {
                if (this.q.isFrame()) {
                    this.etat = S.FRSW2;
                    break;
                }
                throw new NinaParseException(this, "invalidframe", new Object[0]);
            }
            case FRSW2: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.etat = S.FR_N;
                    break;
                }
                throw new NinaParseException(this, "invalidframe", new Object[0]);
            }
            case FR_N: {
                if (this.q.get() == 60) {
                    this.action.setVertex(this.q.getScratch());
                    this.action.setEdge(this.q, null);
                    this.q.west();
                    this.etat = S.AR_W;
                    break;
                }
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.q.north();
                    break;
                }
                if (this.q.isDone()) {
                    this.q.south();
                    this.etat = S.FRR_S;
                    break;
                }
                this.q.south();
                this.etat = S.FRR_S;
                this.action.doneBlockSearching(this.q);
                break;
            }
            case AR_N: {
                if (this.q.get() == 47) {
                    this.q.set(-103);
                    this.q.east();
                    this.etat = S.AR_E;
                    break;
                }
                if (this.q.get() == 92) {
                    this.q.set(-103);
                    this.q.west();
                    this.etat = S.AR_W;
                    break;
                }
                if (this.q.get() == 124) {
                    this.q.set(-103);
                    this.q.north();
                    break;
                }
                if (this.q.get() == 43) {
                    this.q.setScratch(new Z(this.action.getVertex(), this.q.getEdge()));
                    this.q.north();
                    this.etat = S.BR_N;
                    break;
                }
                if (this.q.get() == 46) {
                    this.q.setEdge(CharSets.ALL_CHAR);
                    this.q.set(-103);
                    this.q.north();
                    break;
                }
                if (this.q.get() == 94) {
                    Object o = this.q.getScratch();
                    this.action.link(this.q, o);
                    if (o != null) {
                        this.q.south();
                        this.etat = S.ARR_S;
                        break;
                    }
                    this.q.set(-301);
                    this.etat = S.F2_W;
                    break;
                }
                if (this.q.isLetter() || this.q.isDigit()) {
                    this.q.setEdge((char)this.q.get());
                    this.q.set(-103);
                    this.q.north();
                    break;
                }
                if (this.q.isArrow2() || this.q.isArrow3()) {
                    this.q.south();
                    this.etat = S.AR_ZE;
                    break;
                }
                if (this.q.get() == -300) {
                    this.action.link(this.q, this.q.getScratch());
                    this.q.south();
                    this.etat = S.ARR_S;
                    break;
                }
                throw new NinaParseException(this, "invalidedge", new Object[0]);
            }
            case AR_ZE: {
                this.q.set(94);
                this.q.east();
                this.etat = S.FR_E;
                break;
            }
            case AR_E: {
                if (this.q.get() == 47) {
                    this.q.set(-101);
                    this.q.north();
                    this.etat = S.AR_N;
                    break;
                }
                if (this.q.get() == 92) {
                    this.q.set(-101);
                    this.q.south();
                    this.etat = S.AR_S;
                    break;
                }
                if (this.q.get() == 45) {
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                if (this.q.get() == 43) {
                    this.q.setScratch(new Z(this.action.getVertex(), this.q.getEdge()));
                    this.q.north();
                    this.etat = S.BR_N;
                    break;
                }
                if (this.q.get() == 46) {
                    this.q.setEdge(CharSets.ALL_CHAR);
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                if (this.q.get() == 62) {
                    Object o = this.q.getScratch();
                    this.action.link(this.q, o);
                    if (o != null) {
                        this.q.west();
                        this.etat = S.ARR_W;
                        break;
                    }
                    this.q.set(-301);
                    this.etat = S.F2_N;
                    break;
                }
                if (this.q.get() == 39) {
                    this.q.set(-101);
                    this.q.east();
                    this.buf = new StringBuffer();
                    this.etat = S.AR_EQ;
                    break;
                }
                if (this.q.get() == 123) {
                    this.q.set(-101);
                    this.q.east();
                    this.buf = new StringBuffer();
                    this.etat = S.AR_ER;
                    break;
                }
                if (this.q.get() == 91) {
                    this.q.set(-101);
                    this.q.east();
                    this.buf = new StringBuffer();
                    this.etat = S.AR_EI;
                    break;
                }
                if (this.q.get() == 40) {
                    this.q.set(-400);
                    this.q.east();
                    this.buf = new StringBuffer();
                    this.etat = S.WP_E1;
                    break;
                }
                if (this.q.isLetter() || this.q.isDigit()) {
                    this.metBord((char)this.q.get());
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_ES;
                    break;
                }
                if (this.q.isArrow2() || this.q.isArrow3()) {
                    this.q.west();
                    this.etat = S.AR_ZS;
                    break;
                }
                if (this.q.get() == 96) {
                    this.q.set(-101);
                    this.q.east();
                    this.buf = new StringBuffer();
                    this.etat = S.AR_EG;
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                if (this.q.get() == -300) {
                    this.action.link(this.q, this.q.getScratch());
                    this.q.west();
                    this.etat = S.ARR_W;
                    break;
                }
                throw new NinaParseException(this, "invalidedge", new Object[0]);
            }
            case AR_ZS: {
                this.q.set(62);
                this.q.south();
                this.etat = S.FR_S;
                break;
            }
            case AR_EQ: {
                if (this.q.isBlankX()) {
                    throw new NinaParseException(this, "invalidquote", new Object[0]);
                }
                if (this.q.get() == 39) {
                    this.metBord(this.buf.toString());
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_ES;
                    break;
                }
                if (this.q.get() == 92) {
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_Eq;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.append((char)this.q.get());
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                throw new NinaParseException(this, "invalidquote", new Object[0]);
            }
            case AR_Eq: {
                if (this.q.isBlankX()) {
                    throw new NinaParseException(this, "invalidquote", new Object[0]);
                }
                if (this.q.get() >= 0) {
                    if (this.q.get() == 110) {
                        this.buf.append('\n');
                    } else if (this.q.get() == 114) {
                        this.buf.append('\r');
                    } else if (this.q.get() == 116) {
                        this.buf.append('\t');
                    } else if (this.q.get() != 39 && this.q.get() != 92) {
                        this.buf.append('\\');
                        this.buf.append((char)this.q.get());
                    } else {
                        this.buf.append((char)this.q.get());
                    }
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_EQ;
                    break;
                }
                throw new NinaParseException(this, "invalidquote", new Object[0]);
            }
            case AR_ER: {
                if (this.q.isBlankX()) {
                    throw new NinaParseException(this, "invalidsubfa", new Object[0]);
                }
                if (this.q.get() == 125) {
                    this.metBordRes(this.buf.toString());
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_E;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.append((char)this.q.get());
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                throw new NinaParseException(this, "invalidsubfa", new Object[0]);
            }
            case AR_EI: {
                if (this.q.isBlankX()) {
                    throw new NinaParseException(this, "invalidchrst", new Object[0]);
                }
                if (this.q.get() == 92) {
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_Ei;
                    break;
                }
                if (this.q.get() == 93) {
                    this.metBordCharset(this.buf.toString());
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_E;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.append((char)this.q.get());
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                throw new NinaParseException(this, "invalidchrst", new Object[0]);
            }
            case AR_Ei: {
                if (this.q.isBlankX()) {
                    throw new NinaParseException(this, "invalidchrst", new Object[0]);
                }
                if (this.q.get() >= 0) {
                    this.buf.append('\\');
                    this.buf.append((char)this.q.get());
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_EI;
                    break;
                }
                throw new NinaParseException(this, "invalidchrst", new Object[0]);
            }
            case AR_EG: {
                if (this.q.isBlankX()) {
                    throw new NinaParseException(this, "invalidregex", new Object[0]);
                }
                if (this.q.get() == 92) {
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_Eg;
                    break;
                }
                if (this.q.get() == 96) {
                    try {
                        NFAObject<Object, NFAState, Void> nz = RegexpParser.parse(this.buf.toString());
                        this.metBordNFA(nz);
                    }
                    catch (RegexParseException e) {
                        throw new NinaParseException(this, "invalidregex", new Object[0]);
                    }
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_E;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.append((char)this.q.get());
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                throw new NinaParseException(this, "invalidregex", new Object[0]);
            }
            case AR_Eg: {
                if (this.q.isBlankX()) {
                    throw new NinaParseException(this, "invalidchrst", new Object[0]);
                }
                if (this.q.get() >= 0) {
                    this.buf.append('\\');
                    this.buf.append((char)this.q.get());
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_EG;
                    break;
                }
                throw new NinaParseException(this, "invalidchrst", new Object[0]);
            }
            case AR_ES: {
                if (this.q.isBlankX()) {
                    throw new NinaParseException(this, "invalidmealy", new Object[0]);
                }
                if (this.q.get() == 47) {
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_EM;
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                this.etat = S.AR_E;
                break;
            }
            case AR_EM: {
                if (this.q.isBlankX()) {
                    throw new NinaParseException(this, "invalidmealy", new Object[0]);
                }
                if (this.q.isWhitespace()) {
                    this.q.set(-101);
                    this.q.north().west();
                    this.etat = S.AR_N;
                    break;
                }
                if (this.q.get() == 39) {
                    this.q.set(-101);
                    this.q.east();
                    this.buf = new StringBuffer();
                    this.etat = S.AR_EX;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.action.setMealyEdge(this.q.get());
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_E;
                    break;
                }
                throw new NinaParseException(this, "invalidmealy", new Object[0]);
            }
            case AR_EX: {
                if (this.q.isBlankX()) {
                    throw new NinaParseException(this, "invalidmealy", new Object[0]);
                }
                if (this.q.get() == 39) {
                    this.action.setMealyEdge(this.buf.toString());
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_E;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.append((char)this.q.get());
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                throw new NinaParseException(this, "invalidmealy", new Object[0]);
            }
            case WP_E1: {
                if (this.q.get() == 41) {
                    this.q.set(-400);
                    this.etat = S.TOIX1;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.appendCodePoint(this.q.get());
                    this.q.east();
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.east();
                    break;
                }
                throw new NinaParseException(this, "invalidedge", new Object[0]);
            }
            case AR_S: {
                if (this.q.get() == 47) {
                    this.q.set(-102);
                    this.q.west();
                    this.etat = S.AR_W;
                    break;
                }
                if (this.q.get() == 92) {
                    this.q.set(-102);
                    this.q.east();
                    this.etat = S.AR_E;
                    break;
                }
                if (this.q.get() == 124) {
                    this.q.set(-102);
                    this.q.south();
                    break;
                }
                if (this.q.get() == 43) {
                    this.q.setScratch(new Z(this.action.getVertex(), this.q.getEdge()));
                    this.q.north();
                    this.etat = S.BR_N;
                    break;
                }
                if (this.q.get() == 46) {
                    this.q.setEdge(CharSets.ALL_CHAR);
                    this.q.set(-102);
                    this.q.south();
                    break;
                }
                if (this.q.get() == 118) {
                    Object o = this.q.getScratch();
                    this.action.link(this.q, o);
                    if (o != null) {
                        this.q.north();
                        this.etat = S.ARR_N;
                        break;
                    }
                    this.q.set(-301);
                    this.etat = S.F3_W;
                    break;
                }
                if (this.q.isLetter() || this.q.isDigit()) {
                    this.metBord((char)this.q.get());
                    this.q.set(-102);
                    this.q.south();
                    break;
                }
                if (this.q.isArrow2() || this.q.isArrow3()) {
                    this.q.north();
                    this.etat = S.AR_ZW;
                    break;
                }
                if (this.q.get() == -300) {
                    this.action.link(this.q, this.q.getScratch());
                    this.q.north();
                    this.etat = S.ARR_N;
                    break;
                }
                throw new NinaParseException(this, "invalidedge", new Object[0]);
            }
            case AR_ZW: {
                this.q.set(118);
                this.q.west();
                this.etat = S.FR_W;
                break;
            }
            case AR_W: {
                if (this.q.get() == 47) {
                    this.q.set(-100);
                    this.q.south();
                    this.etat = S.AR_S;
                    break;
                }
                if (this.q.get() == 92) {
                    this.q.set(-100);
                    this.q.north();
                    this.etat = S.AR_N;
                    break;
                }
                if (this.q.get() == 45) {
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                if (this.q.get() == 43) {
                    this.q.setScratch(new Z(this.action.getVertex(), this.q.getEdge()));
                    this.q.north();
                    this.etat = S.BR_N;
                    break;
                }
                if (this.q.get() == 46) {
                    this.q.setEdge(CharSets.ALL_CHAR);
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                if (this.q.get() == 60) {
                    Object o = this.q.getScratch();
                    this.action.link(this.q, o);
                    if (o != null) {
                        this.q.east();
                        this.etat = S.ARR_E;
                        break;
                    }
                    this.q.set(-301);
                    this.etat = S.F3_N;
                    break;
                }
                if (this.q.get() == 39) {
                    this.buf = new StringBuffer();
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WQ;
                    this.buf = new StringBuffer();
                    break;
                }
                if (this.q.get() == 125) {
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WR;
                    this.buf = new StringBuffer();
                    break;
                }
                if (this.q.get() == 93) {
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WI;
                    this.buf = new StringBuffer();
                    break;
                }
                if (this.q.get() == 41) {
                    this.q.set(-400);
                    this.q.west();
                    this.buf = new StringBuffer();
                    this.etat = S.WP_W1;
                    break;
                }
                if (this.q.get() == 96) {
                    this.q.set(-100);
                    this.q.west();
                    this.buf = new StringBuffer();
                    this.etat = S.AR_WG;
                    break;
                }
                if (this.q.isLetter() || this.q.isDigit()) {
                    this.chr = this.q.get();
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WS;
                    break;
                }
                if (this.q.isArrow2() || this.q.isArrow3()) {
                    this.q.east();
                    this.etat = S.AR_ZN;
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                if (this.q.get() == -300) {
                    this.action.link(this.q, this.q.getScratch());
                    this.q.east();
                    this.etat = S.ARR_E;
                    break;
                }
                throw new NinaParseException(this, "invalidedge", new Object[0]);
            }
            case AR_ZN: {
                this.q.set(60);
                this.q.north();
                this.etat = S.FR_N;
                break;
            }
            case AR_WQ: {
                if (this.q.isBlankX()) {
                    throw new NinaParseException(this, "invalidquote", new Object[0]);
                }
                if (this.q.get() == 39) {
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_Wq;
                    break;
                }
                if (this.q.get() == 92) {
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_Wy;
                    break;
                }
                if (this.q.get() == 110) {
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_Wn;
                    break;
                }
                if (this.q.get() == 114) {
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_Wr;
                    break;
                }
                if (this.q.get() == 116) {
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_Wt;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.append((char)this.q.get());
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                throw new NinaParseException(this, "invalidquote", new Object[0]);
            }
            case AR_Wq: {
                if (this.q.isBlankX()) {
                    throw new NinaParseException(this, "invalidquote", new Object[0]);
                }
                if (this.q.get() == 92) {
                    this.buf.append('\'');
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WQ;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.chr = -1;
                    this.etat = S.AR_WS;
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                throw new NinaParseException(this, "invalidquote", new Object[0]);
            }
            case AR_Wy: {
                if (this.q.isBlankX()) {
                    throw new NinaParseException(this, "invalidquote", new Object[0]);
                }
                if (this.q.get() == 39) {
                    this.buf.append('\\');
                    this.chr = -1;
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WS;
                    break;
                }
                if (this.q.get() >= 0) {
                    if (this.q.get() != 92) {
                        this.buf.append('\\');
                    }
                    this.buf.append((char)this.q.get());
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WQ;
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                throw new NinaParseException(this, "invalidquote", new Object[0]);
            }
            case AR_Wn: {
                if (this.q.isBlankX()) {
                    throw new NinaParseException(this, "invalidquote", new Object[0]);
                }
                if (this.q.get() == 39) {
                    this.buf.append('n');
                    this.chr = -1;
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WS;
                    break;
                }
                if (this.q.get() >= 0) {
                    if (this.q.get() != 92) {
                        this.buf.append('n');
                        this.buf.append((char)this.q.get());
                    } else {
                        this.buf.append('\n');
                    }
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WQ;
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                throw new NinaParseException(this, "invalidquote", new Object[0]);
            }
            case AR_Wr: {
                if (this.q.isBlankX()) {
                    throw new NinaParseException(this, "invalidquote", new Object[0]);
                }
                if (this.q.get() == 39) {
                    this.buf.append('r');
                    this.chr = -1;
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WS;
                    break;
                }
                if (this.q.get() >= 0) {
                    if (this.q.get() != 92) {
                        this.buf.append('r');
                        this.buf.append((char)this.q.get());
                    } else {
                        this.buf.append('\r');
                    }
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WQ;
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                throw new NinaParseException(this, "invalidquote", new Object[0]);
            }
            case AR_Wt: {
                if (this.q.isBlankX()) {
                    throw new NinaParseException(this, "invalidquote", new Object[0]);
                }
                if (this.q.get() == 39) {
                    this.buf.append('t');
                    this.chr = -1;
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WS;
                    break;
                }
                if (this.q.get() >= 0) {
                    if (this.q.get() != 92) {
                        this.buf.append('t');
                        this.buf.append((char)this.q.get());
                    } else {
                        this.buf.append('\t');
                    }
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WQ;
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                throw new NinaParseException(this, "invalidquote", new Object[0]);
            }
            case AR_WR: {
                if (this.q.isBlankX()) {
                    throw new NinaParseException(this, "invalidsubfa", new Object[0]);
                }
                if (this.q.get() == 123) {
                    this.metBordRes(this.buf.reverse().toString());
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_W;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.append((char)this.q.get());
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                throw new NinaParseException(this, "invalidsubfa", new Object[0]);
            }
            case AR_WI: {
                if (this.q.isBlankX()) {
                    throw new NinaParseException(this, "invalidchrst", new Object[0]);
                }
                if (this.q.get() == 91) {
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_Wi;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.append((char)this.q.get());
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                throw new NinaParseException(this, "invalidchrst", new Object[0]);
            }
            case AR_Wi: {
                if (this.q.get() == 92) {
                    this.buf.append('\\');
                    this.buf.append('[');
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WI;
                    break;
                }
                this.metBordCharset(this.buf.reverse().toString());
                this.etat = S.AR_W;
                break;
            }
            case AR_WG: {
                if (this.q.isBlankX()) {
                    throw new NinaParseException(this, "invalidregex", new Object[0]);
                }
                if (this.q.get() == 96) {
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_Wg;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.append((char)this.q.get());
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                throw new NinaParseException(this, "invalidregex", new Object[0]);
            }
            case AR_Wg: {
                if (this.q.get() == 92) {
                    this.buf.append('`');
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WG;
                    break;
                }
                try {
                    NFAObject<Object, NFAState, Void> nz = RegexpParser.parse(this.buf.reverse().toString());
                    this.metBordNFA(nz);
                }
                catch (RegexParseException e) {
                    throw new NinaParseException(this, "invalidregex", new Object[0]);
                }
                this.etat = S.AR_W;
                break;
            }
            case AR_WS: {
                if (this.q.isBlankX()) {
                    throw new NinaParseException(this, "invalidmealy", new Object[0]);
                }
                if (this.q.get() == 47) {
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WM;
                    break;
                }
                if (this.chr < 0) {
                    this.metBord(this.buf.reverse().toString());
                    this.etat = S.AR_W;
                    break;
                }
                this.metBord((char)this.chr);
                this.etat = S.AR_W;
                break;
            }
            case AR_WM: {
                if (this.q.isBlankX()) {
                    throw new NinaParseException(this, "invalidmealy", new Object[0]);
                }
                if (this.q.isWhitespace()) {
                    this.q.south().east();
                    this.etat = S.AR_S;
                    break;
                }
                if (this.q.get() == 39) {
                    this.metmealy();
                    this.q.set(-100);
                    this.q.west();
                    this.buf = new StringBuffer();
                    this.etat = S.AR_WX;
                    break;
                }
                if (this.q.get() == 125) {
                    this.metmealy();
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WR;
                    this.buf = new StringBuffer();
                    break;
                }
                if (this.q.get() == 93) {
                    this.metmealy();
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WI;
                    this.buf = new StringBuffer();
                    break;
                }
                if (this.q.get() == 41) {
                    this.metmealy();
                    this.q.set(-400);
                    this.q.west();
                    this.buf = new StringBuffer();
                    this.etat = S.WP_W1;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.metmealy();
                    this.metBord((char)this.q.get());
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                throw new NinaParseException(this, "invalidmealy", new Object[0]);
            }
            case AR_WX: {
                if (this.q.isBlankX()) {
                    throw new NinaParseException(this, "invalidmealy", new Object[0]);
                }
                if (this.q.get() == 39) {
                    this.metBord(this.buf.reverse().toString());
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_W;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.append((char)this.q.get());
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                throw new NinaParseException(this, "invalidmealy", new Object[0]);
            }
            case WP_W1: {
                if (this.q.get() == 40) {
                    this.buf.reverse();
                    this.q.set(-400);
                    this.etat = S.TOIX1;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.appendCodePoint(this.q.get());
                    this.q.west();
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.west();
                    break;
                }
                throw new NinaParseException(this, "invalidedge", new Object[0]);
            }
            case F2_W: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.q.west();
                    break;
                }
                if (this.q.isDone()) {
                    this.q.east();
                    this.etat = S.FRR_E;
                    break;
                }
                this.q.east();
                this.etat = S.F2_N;
                break;
            }
            case F2_N: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.q.north();
                    break;
                }
                if (this.q.isDone()) {
                    this.q.south();
                    this.etat = S.FRR_S;
                    break;
                }
                this.q.south();
                this.etat = S.LBLE;
                break;
            }
            case F3_W: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.q.west();
                    break;
                }
                this.q.east();
                this.etat = S.LBLE;
                break;
            }
            case F3_N: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.q.north();
                    break;
                }
                this.q.south();
                this.etat = S.F3_W;
                break;
            }
            case FRR_S: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isDone()) {
                    this.q.set(-300);
                    this.q.south();
                    break;
                }
                if (this.q.isEntry()) {
                    this.q.set(-300);
                    this.q.west();
                    this.etat = S.ARR_W;
                    break;
                }
                this.q.north().east();
                this.etat = S.FRR_E;
                break;
            }
            case FRR_E: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isDone()) {
                    this.q.set(-300);
                    this.q.east();
                    break;
                }
                if (this.q.isEntry()) {
                    this.q.set(-300);
                    this.q.south();
                    this.etat = S.ARR_S;
                    break;
                }
                this.q.north().west();
                this.etat = S.FRR_N;
                break;
            }
            case FRR_N: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isDone()) {
                    this.q.set(-300);
                    this.q.north();
                    break;
                }
                if (this.q.isEntry()) {
                    this.q.set(-300);
                    this.q.east();
                    this.etat = S.ARR_E;
                    break;
                }
                this.q.south().west();
                this.etat = S.FRR_W;
                break;
            }
            case FRR_W: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isDone()) {
                    this.q.set(-300);
                    this.q.west();
                    break;
                }
                if (this.q.isEntry()) {
                    this.q.set(-300);
                    this.q.north();
                    this.etat = S.ARR_N;
                    break;
                }
                return this.action.accept();
            }
            case ARR_N: {
                if (this.q.get() == -102) {
                    this.q.set(-203);
                    this.q.north();
                    this.etat = S.ARR_N;
                    break;
                }
                if (this.q.get() == -100) {
                    this.q.set(-201);
                    this.q.east();
                    this.etat = S.ARR_E;
                    break;
                }
                if (this.q.get() == -103) {
                    this.q.set(-202);
                    this.q.south();
                    this.etat = S.ARR_S;
                    break;
                }
                if (this.q.get() == -101) {
                    this.q.set(-200);
                    this.q.west();
                    this.etat = S.ARR_W;
                    break;
                }
                if (this.q.get() == 43) {
                    this.q.setEdge(((Z)this.q.getScratch()).edge);
                    this.action.setVertex(((Z)this.q.getScratch()).vertex);
                    this.q.north();
                    this.etat = S.BR_N;
                    break;
                }
                if (this.q.isArrow()) {
                    this.action.setVertex(this.q.getScratch());
                    this.q.west();
                    this.etat = S.FR_W;
                    break;
                }
                if (this.q.isDone()) {
                    this.q.east();
                    this.etat = S.FRR_E;
                    break;
                }
                if (this.q.isArrow3()) {
                    this.q.south();
                    this.etat = S.ARRZW;
                    break;
                }
                throw new NinaParseException(this, "invalidedge", new Object[0]);
            }
            case ARRZW: {
                this.q.set(-300);
                this.etat = S.FRR_W;
                break;
            }
            case ARR_E: {
                if (this.q.get() == -102) {
                    this.q.set(-203);
                    this.q.north();
                    this.etat = S.ARR_N;
                    break;
                }
                if (this.q.get() == -100) {
                    this.q.set(-201);
                    this.q.east();
                    this.etat = S.ARR_E;
                    break;
                }
                if (this.q.get() == -103) {
                    this.q.set(-202);
                    this.q.south();
                    this.etat = S.ARR_S;
                    break;
                }
                if (this.q.get() == -101) {
                    this.q.set(-200);
                    this.q.west();
                    this.etat = S.ARR_W;
                    break;
                }
                if (this.q.get() == -400) {
                    this.q.set(-402);
                    this.q.east();
                    this.buf = new StringBuffer();
                    this.etat = S.WP_E2;
                    break;
                }
                if (this.q.get() == 43) {
                    this.q.setEdge(((Z)this.q.getScratch()).edge);
                    this.action.setVertex(((Z)this.q.getScratch()).vertex);
                    this.q.north();
                    this.etat = S.BR_N;
                    break;
                }
                if (this.q.isArrow()) {
                    this.action.setVertex(this.q.getScratch());
                    this.q.north();
                    this.etat = S.FR_N;
                    break;
                }
                if (this.q.isDone()) {
                    this.q.south();
                    this.etat = S.FRR_S;
                    break;
                }
                if (this.q.isArrow3()) {
                    this.q.west();
                    this.etat = S.ARRZN;
                    break;
                }
                throw new NinaParseException(this, "invalidedge", new Object[0]);
            }
            case WP_E2: {
                if (this.q.get() == -400) {
                    this.q.set(-402);
                    this.etat = S.TOIX2;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.appendCodePoint(this.q.get());
                    this.q.east();
                    break;
                }
                throw new NinaParseException(this, "invalidedge", new Object[0]);
            }
            case ARRZN: {
                this.q.set(-300);
                this.etat = S.FRR_N;
                break;
            }
            case ARR_S: {
                if (this.q.get() == -102) {
                    this.q.set(-203);
                    this.q.north();
                    this.etat = S.ARR_N;
                    break;
                }
                if (this.q.get() == -100) {
                    this.q.set(-201);
                    this.q.east();
                    this.etat = S.ARR_E;
                    break;
                }
                if (this.q.get() == -103) {
                    this.q.set(-202);
                    this.q.south();
                    this.etat = S.ARR_S;
                    break;
                }
                if (this.q.get() == -101) {
                    this.q.set(-200);
                    this.q.west();
                    this.etat = S.ARR_W;
                    break;
                }
                if (this.q.get() == 43) {
                    this.q.setEdge(((Z)this.q.getScratch()).edge);
                    this.action.setVertex(((Z)this.q.getScratch()).vertex);
                    this.q.north();
                    this.etat = S.BR_N;
                    break;
                }
                if (this.q.isArrow()) {
                    this.action.setVertex(this.q.getScratch());
                    this.q.east();
                    this.etat = S.FR_E;
                    break;
                }
                if (this.q.isDone()) {
                    this.q.west();
                    this.etat = S.FRR_W;
                    break;
                }
                if (this.q.isArrow3()) {
                    this.q.north();
                    this.etat = S.ARRZE;
                    break;
                }
                throw new NinaParseException(this, "invalidedge", new Object[0]);
            }
            case ARRZE: {
                this.q.set(-300);
                this.etat = S.FRR_S;
                break;
            }
            case ARR_W: {
                if (this.q.get() == -102) {
                    this.q.set(-203);
                    this.q.north();
                    this.etat = S.ARR_N;
                    break;
                }
                if (this.q.get() == -100) {
                    this.q.set(-201);
                    this.q.east();
                    this.etat = S.ARR_E;
                    break;
                }
                if (this.q.get() == -103) {
                    this.q.set(-202);
                    this.q.south();
                    this.etat = S.ARR_S;
                    break;
                }
                if (this.q.get() == -101) {
                    this.q.set(-200);
                    this.q.west();
                    this.etat = S.ARR_W;
                    break;
                }
                if (this.q.get() == -400) {
                    this.q.set(-402);
                    this.q.west();
                    this.buf = new StringBuffer();
                    this.etat = S.WP_W2;
                    break;
                }
                if (this.q.get() == 43) {
                    this.q.setEdge(((Z)this.q.getScratch()).edge);
                    this.action.setVertex(((Z)this.q.getScratch()).vertex);
                    this.q.north();
                    this.etat = S.BR_N;
                    break;
                }
                if (this.q.isArrow()) {
                    this.action.setVertex(this.q.getScratch());
                    this.q.south();
                    this.etat = S.FR_S;
                    break;
                }
                if (this.q.isDone()) {
                    this.q.north();
                    this.etat = S.FRR_N;
                    break;
                }
                if (this.q.isArrow3()) {
                    this.q.east();
                    this.etat = S.ARRZS;
                    break;
                }
                throw new NinaParseException(this, "invalidedge", new Object[0]);
            }
            case WP_W2: {
                if (this.q.get() == -400) {
                    this.buf.reverse();
                    this.q.set(-402);
                    this.etat = S.TOIX2;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.appendCodePoint(this.q.get());
                    this.q.west();
                    break;
                }
                throw new NinaParseException(this, "invalidedge", new Object[0]);
            }
            case ARRZS: {
                this.q.set(-300);
                this.etat = S.FRR_S;
                break;
            }
            case BR_N: {
                if (this.q.get() == 124) {
                    this.q.set(-103);
                    this.q.north();
                    this.etat = S.AR_N;
                    break;
                }
                if (this.q.get() == 92) {
                    this.q.set(-103);
                    this.q.west();
                    this.etat = S.AR_W;
                    break;
                }
                if (this.q.get() == 47) {
                    this.q.set(-103);
                    this.q.east();
                    this.etat = S.AR_E;
                    break;
                }
                this.q.south().east();
                this.etat = S.BR_E;
                break;
            }
            case BR_E: {
                if (this.q.get() == 45) {
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_E;
                    break;
                }
                if (this.q.get() == 92) {
                    this.q.set(-101);
                    this.q.south();
                    this.etat = S.AR_S;
                    break;
                }
                if (this.q.get() == 47) {
                    this.q.set(-101);
                    this.q.north();
                    this.etat = S.AR_N;
                    break;
                }
                this.q.west().south();
                this.etat = S.BR_S;
                break;
            }
            case BR_S: {
                if (this.q.get() == 124) {
                    this.q.set(-102);
                    this.q.south();
                    this.etat = S.AR_S;
                    break;
                }
                if (this.q.get() == 92) {
                    this.q.set(-102);
                    this.q.east();
                    this.etat = S.AR_E;
                    break;
                }
                if (this.q.get() == 47) {
                    this.q.set(-102);
                    this.q.west();
                    this.etat = S.AR_W;
                    break;
                }
                this.q.north().west();
                this.etat = S.BR_W;
                break;
            }
            case BR_W: {
                if (this.q.get() == 45) {
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_W;
                    break;
                }
                if (this.q.get() == 92) {
                    this.q.set(-100);
                    this.q.north();
                    this.etat = S.AR_N;
                    break;
                }
                if (this.q.get() == 47) {
                    this.q.set(-100);
                    this.q.south();
                    this.etat = S.AR_S;
                    break;
                }
                this.q.east().north();
                this.etat = S.BR2_N;
                break;
            }
            case BR2_N: {
                if (this.q.get() == -102) {
                    this.q.set(-203);
                    this.q.north();
                    this.etat = S.ARR_N;
                    break;
                }
                this.q.south().east();
                this.etat = S.BR2_E;
                break;
            }
            case BR2_E: {
                if (this.q.get() == -100) {
                    this.q.set(-201);
                    this.q.east();
                    this.etat = S.ARR_E;
                    break;
                }
                this.q.west().south();
                this.etat = S.BR2_S;
                break;
            }
            case BR2_S: {
                if (this.q.get() == -103) {
                    this.q.set(-202);
                    this.q.south();
                    this.etat = S.ARR_S;
                    break;
                }
                this.q.north().west();
                this.etat = S.BR2_W;
                break;
            }
            case BR2_W: {
                if (this.q.get() == -101) {
                    this.q.set(-200);
                    this.q.west();
                    this.etat = S.ARR_W;
                    break;
                }
                throw new NinaParseException(this, "invalidedge", new Object[0]);
            }
            case TOIX1: {
                if (this.q.isBlankX()) {
                    this.q.east();
                    this.etat = S.TOIY1;
                    break;
                }
                this.q.west();
                break;
            }
            case TOIY1: {
                if (this.q.isBlankY() || this.q.get() == 35) {
                    this.q.south();
                    this.etat = S.SER1E;
                    break;
                }
                this.q.north();
                break;
            }
            case SER1E: {
                if (this.q.isBlankY()) {
                    throw new NinaParseException(this, "labelnotfound", this.buf.toString());
                }
                if (this.q.isBlankX()) {
                    this.q.cr();
                    break;
                }
                if (this.q.get() == 39) {
                    this.q.east();
                    this.etat = S.SER1q;
                    break;
                }
                if (this.q.get() == 91) {
                    this.q.east();
                    this.etat = S.SER1c;
                    break;
                }
                if (this.q.get() == 96) {
                    this.q.east();
                    this.etat = S.SER1r;
                    break;
                }
                if (this.q.get() == 40) {
                    this.q.east();
                    this.etat = S.SER1F;
                    this.bf2 = new StringBuffer();
                    break;
                }
                if (this.q.get() == 45) {
                    this.q.east();
                    this.etat = S.SER1W;
                    break;
                }
                this.q.east();
                break;
            }
            case SER1q: {
                if (this.q.isBlankY()) {
                    throw new NinaParseException(this, "labelnotfound", this.buf.toString());
                }
                if (this.q.isBlankX()) {
                    this.q.cr();
                    break;
                }
                if (this.q.get() == 39) {
                    this.q.east();
                    this.etat = S.SER1E;
                    break;
                }
                this.q.east();
                break;
            }
            case SER1c: {
                if (this.q.isBlankY()) {
                    throw new NinaParseException(this, "labelnotfound", this.buf.toString());
                }
                if (this.q.isBlankX()) {
                    this.q.cr();
                    break;
                }
                if (this.q.get() == 93) {
                    this.q.east();
                    this.etat = S.SER1E;
                    break;
                }
                this.q.east();
                break;
            }
            case SER1r: {
                if (this.q.isBlankY()) {
                    throw new NinaParseException(this, "labelnotfound", this.buf.toString());
                }
                if (this.q.isBlankX()) {
                    this.q.cr();
                    break;
                }
                if (this.q.get() == 96) {
                    this.q.east();
                    this.etat = S.SER1E;
                    break;
                }
                this.q.east();
                break;
            }
            case SER1F: {
                if (this.q.get() == 41) {
                    if (this.buf.toString().equals(this.bf2.toString())) {
                        this.q.west();
                        this.etat = S.SER1G;
                        break;
                    }
                    this.etat = S.SER1E;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.bf2.appendCodePoint(this.q.get());
                    this.q.east();
                    break;
                }
                throw new NinaParseException(this, "labelnotfound", this.buf.toString());
            }
            case SER1G: {
                if (this.q.get() == 40) {
                    this.q.set(-400);
                    this.q.east();
                    this.etat = S.SER1H;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.q.west();
                    break;
                }
                throw new NinaParseException(this, "labelnotfound", this.buf.toString());
            }
            case SER1H: {
                if (this.q.get() == 41) {
                    this.q.set(-400);
                    this.q.east();
                    this.etat = S.AR_E;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.q.east();
                    break;
                }
                throw new NinaParseException(this, "labelnotfound", this.buf.toString());
            }
            case SER1W: {
                if (this.q.isBlankY()) {
                    throw new NinaParseException(this, "labelnotfound", this.buf.toString());
                }
                if (this.q.isBlankX()) {
                    this.q.cr();
                    break;
                }
                if (this.q.get() == 39) {
                    this.q.east();
                    this.etat = S.SER1Q;
                    break;
                }
                if (this.q.get() == 91) {
                    this.q.east();
                    this.etat = S.SER1C;
                    break;
                }
                if (this.q.get() == 96) {
                    this.q.east();
                    this.etat = S.SER1R;
                    break;
                }
                if (this.q.get() == 40) {
                    this.q.east();
                    this.etat = S.SER1X;
                    this.bf2 = new StringBuffer();
                    break;
                }
                if (this.q.get() != 45) {
                    this.q.east();
                    this.etat = S.SER1E;
                    break;
                }
                this.q.east();
                break;
            }
            case SER1Q: {
                if (this.q.isBlankY()) {
                    throw new NinaParseException(this, "labelnotfound", this.buf.toString());
                }
                if (this.q.isBlankX()) {
                    this.q.cr();
                    break;
                }
                if (this.q.get() == 39) {
                    this.q.east();
                    this.etat = S.SER1W;
                    break;
                }
                this.q.east();
                break;
            }
            case SER1C: {
                if (this.q.isBlankY()) {
                    throw new NinaParseException(this, "labelnotfound", this.buf.toString());
                }
                if (this.q.isBlankX()) {
                    this.q.cr();
                    break;
                }
                if (this.q.get() == 93) {
                    this.q.east();
                    this.etat = S.SER1W;
                    break;
                }
                this.q.east();
                break;
            }
            case SER1R: {
                if (this.q.isBlankY()) {
                    throw new NinaParseException(this, "labelnotfound", this.buf.toString());
                }
                if (this.q.isBlankX()) {
                    this.q.cr();
                    break;
                }
                if (this.q.get() == 96) {
                    this.q.east();
                    this.etat = S.SER1W;
                    break;
                }
                this.q.east();
                break;
            }
            case SER1X: {
                if (this.q.get() == 41) {
                    if (this.buf.toString().equals(this.bf2.toString())) {
                        this.q.set(-400);
                        this.q.west();
                        this.etat = S.SER1Y;
                        break;
                    }
                    this.etat = S.SER1W;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.bf2.appendCodePoint(this.q.get());
                    this.q.east();
                    break;
                }
                throw new NinaParseException(this, "labelnotfound", this.buf.toString());
            }
            case SER1Y: {
                if (this.q.get() == 40) {
                    this.q.set(-400);
                    this.q.west();
                    this.etat = S.AR_W;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.q.west();
                    break;
                }
                throw new NinaParseException(this, "labelnotfound", this.buf.toString());
            }
            case TOIX2: {
                if (this.q.isBlankX()) {
                    this.q.east();
                    this.etat = S.TOIY2;
                    break;
                }
                this.q.west();
                break;
            }
            case TOIY2: {
                if (this.q.isBlankY() || this.q.get() == 35) {
                    this.q.south();
                    this.etat = S.SER2E;
                    break;
                }
                this.q.north();
                break;
            }
            case SER2E: {
                if (this.q.isBlankY()) {
                    throw new NinaParseException(this, "labelnotfound", this.buf.toString());
                }
                if (this.q.isBlankX()) {
                    this.q.cr();
                    break;
                }
                if (this.q.get() == -400) {
                    this.q.east();
                    this.etat = S.SER2F;
                    this.bf2 = new StringBuffer();
                    break;
                }
                if (this.q.get() == -101) {
                    this.q.east();
                    this.etat = S.SER2W;
                    break;
                }
                this.q.east();
                break;
            }
            case SER2F: {
                if (this.q.get() >= 0) {
                    this.bf2.appendCodePoint(this.q.get());
                    this.q.east();
                    break;
                }
                if (this.q.get() != -400) {
                    this.q.east();
                    this.etat = S.SER2E;
                    break;
                }
                if (this.buf.toString().equals(this.bf2.toString())) {
                    this.q.west();
                    this.etat = S.SER2G;
                    break;
                }
                this.etat = S.SER2E;
                break;
            }
            case SER2G: {
                if (this.q.get() >= 0) {
                    this.q.west();
                    break;
                }
                if (this.q.get() == -400) {
                    this.q.set(-402);
                    this.q.east();
                    this.etat = S.SER2H;
                    break;
                }
                throw new NinaParseException(this, "labelnotfound", this.buf.toString());
            }
            case SER2H: {
                if (this.q.get() >= 0) {
                    this.q.east();
                    break;
                }
                if (this.q.get() == -400) {
                    this.q.set(-402);
                    this.q.east();
                    this.etat = S.ARR_E;
                    break;
                }
                throw new NinaParseException(this, "labelnotfound", this.buf.toString());
            }
            case SER2W: {
                if (this.q.isBlankY()) {
                    throw new NinaParseException(this, "labelnotfound", this.buf.toString());
                }
                if (this.q.isBlankX()) {
                    this.q.cr();
                    break;
                }
                if (this.q.get() == -400) {
                    this.q.east();
                    this.etat = S.SER2X;
                    this.bf2 = new StringBuffer();
                    break;
                }
                if (this.q.get() != -101) {
                    this.q.east();
                    this.etat = S.SER2E;
                    break;
                }
                this.q.east();
                break;
            }
            case SER2X: {
                if (this.q.get() >= 0) {
                    this.bf2.appendCodePoint(this.q.get());
                    this.q.east();
                    break;
                }
                if (this.q.get() != -400) {
                    this.q.east();
                    this.etat = S.SER2E;
                    break;
                }
                if (this.buf.toString().equals(this.bf2.toString())) {
                    this.q.set(-402);
                    this.q.west();
                    this.etat = S.SER2Y;
                    break;
                }
                this.etat = S.SER2E;
                break;
            }
            case SER2Y: {
                if (this.q.get() >= 0) {
                    this.q.west();
                    break;
                }
                if (this.q.get() == -400) {
                    this.q.set(-402);
                    this.q.west();
                    this.etat = S.ARR_W;
                    break;
                }
                throw new NinaParseException(this, "labelnotfound", this.buf.toString());
            }
        }
        return null;
    }

    public String getPragma(String s) {
        return this.pragmas.get(s);
    }

    public void printTrace(PrintStream pr) {
        pr.println((Object)this.etat);
        pr.println(this.q.toString());
        pr.println((int)((char)(this.q.get() < 0 ? this.q.get() : (char)this.q.get())));
    }

    private static enum S {
        INIT,
        PRAG,
        PACK,
        MACHN,
        TYPE,
        OPTN,
        OPTV,
        OPTQ,
        IMPR,
        COMNT,
        LINIT,
        FMNW,
        FMNW2,
        FM_E,
        FMNE,
        FMNE2,
        FM_S,
        FMSE,
        FMSE2,
        FM_W,
        FMSW,
        FMSW2,
        FM_N,
        FRNW,
        FRNW2,
        FR_E,
        FRNE,
        FRNE2,
        FR_S,
        FRSE,
        FRSE2,
        FR_W,
        FRSW,
        FRSW2,
        FR_N,
        LBLE,
        AR_N,
        AR_E,
        AR_EQ,
        AR_Eq,
        AR_ER,
        AR_EI,
        AR_Ei,
        AR_EG,
        AR_Eg,
        AR_ES,
        AR_EM,
        AR_EX,
        AR_S,
        AR_W,
        AR_WQ,
        AR_Wq,
        AR_Wy,
        AR_Wn,
        AR_Wr,
        AR_Wt,
        AR_WR,
        AR_WI,
        AR_Wi,
        AR_WG,
        AR_Wg,
        AR_WS,
        AR_WM,
        AR_WX,
        AR_ZN,
        AR_ZS,
        AR_ZE,
        AR_ZW,
        F2_W,
        F2_N,
        F3_W,
        F3_N,
        BR_N,
        BR_E,
        BR_S,
        BR_W,
        BR2_N,
        BR2_E,
        BR2_S,
        BR2_W,
        FRR_S,
        FRR_E,
        FRR_N,
        FRR_W,
        ARR_N,
        ARR_E,
        ARR_S,
        ARR_W,
        ARRZN,
        ARRZS,
        ARRZE,
        ARRZW,
        WP_E1,
        WP_W1,
        TOIX1,
        TOIY1,
        SER1E,
        SER1q,
        SER1c,
        SER1r,
        SER1F,
        SER1G,
        SER1H,
        SER1W,
        SER1Q,
        SER1C,
        SER1R,
        SER1X,
        SER1Y,
        WP_E2,
        WP_W2,
        TOIX2,
        TOIY2,
        SER2E,
        SER2F,
        SER2G,
        SER2H,
        SER2W,
        SER2X,
        SER2Y;

    }

    private static class Z {
        Object vertex;
        Object edge;

        Z(Object v, Object e) {
            this.vertex = v;
            this.edge = e;
        }
    }
}

