/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina;

import java.io.PrintStream;
import java.util.ResourceBundle;
import net.morilib.nina.NinaParser;
import net.morilib.nina.Quadro;

public class NinaParseException
extends RuntimeException {
    private static final String CLSNAME = NinaParseException.class.getPackage().getName().replace('.', '/');
    private static ResourceBundle msgs = ResourceBundle.getBundle(String.valueOf(CLSNAME) + "/nina_messages");
    private NinaParser parser = null;
    private Quadro quadro = null;

    static String getmsg(String s, Object ... os) {
        String t = msgs.getString(s);
        if (t != null) {
            return String.format(t, os);
        }
        return "unknown";
    }

    public NinaParseException(String msgcode, Object ... os) {
        super(NinaParseException.getmsg(msgcode, os));
    }

    public NinaParseException(NinaParser q, String msgcode, Object ... os) {
        super(NinaParseException.getmsg(msgcode, os));
        this.parser = q;
    }

    public NinaParseException(Quadro q, String msgcode, Object ... os) {
        super(NinaParseException.getmsg(msgcode, os));
        this.quadro = q;
    }

    public NinaParseException(Throwable cause, String msgcode, Object ... os) {
        super(NinaParseException.getmsg(msgcode, os), cause);
    }

    public void printTrace(PrintStream o) {
        if (this.parser != null) {
            this.parser.printTrace(o);
        } else if (this.quadro != null) {
            this.quadro.printTrace(o);
        }
    }
}

