/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina;

import java.io.Reader;
import net.morilib.nina.NinaParseException;
import net.morilib.nina.Quadro;

public class NinaFrameReader
extends Reader {
    private Quadro quadro;
    private E etat = E.INIT;
    private int count = 0;

    NinaFrameReader(Quadro q) {
        this.quadro = q;
    }

    private boolean isfrm2() {
        return this.quadro.isFrame() || this.quadro.isArrow() || this.quadro.get() < 0;
    }

    @Override
    public int read() {
        block11: while (true) {
            switch (this.etat) {
                case INIT: {
                    if (this.isfrm2()) {
                        this.quadro.north();
                        this.etat = E.EOF;
                        continue block11;
                    }
                    if (this.quadro.get() == 123) {
                        this.quadro.setScratch(this);
                        this.etat = E.BLC2;
                        ++this.count;
                        int c = this.quadro.get();
                        this.quadro.east();
                        return c < 0 ? 0 : c;
                    }
                    this.quadro.setScratch(this);
                    this.etat = E.CHR0;
                    int c = this.quadro.get();
                    this.quadro.east();
                    return c < 0 ? 0 : c;
                }
                case CHR0: {
                    if (this.isfrm2() && this.quadro.get() != 118) {
                        this.quadro.west();
                        this.etat = E.CRLF;
                        continue block11;
                    }
                    if (this.quadro.get() == 123) {
                        this.etat = E.BLC2;
                        ++this.count;
                        int c = this.quadro.get();
                        this.quadro.east();
                        return c < 0 ? 0 : c;
                    }
                    int c = this.quadro.get();
                    this.quadro.east();
                    return c < 0 ? 0 : c;
                }
                case BLC1: {
                    if (this.isfrm2()) {
                        this.quadro.north();
                        this.etat = E.EOF;
                        continue block11;
                    }
                    if (this.quadro.get() == 125) {
                        this.quadro.setScratch(this);
                        this.etat = --this.count > 0 ? E.BLC2 : E.CHR0;
                        int c = this.quadro.get();
                        this.quadro.east();
                        return c < 0 ? 0 : c;
                    }
                    if (this.quadro.get() == 59) {
                        this.quadro.setScratch(this);
                        int c = this.quadro.get();
                        this.quadro.south();
                        return c < 0 ? 0 : c;
                    }
                    this.quadro.setScratch(this);
                    this.etat = E.BLC2;
                    int c = this.quadro.get();
                    this.quadro.east();
                    return c < 0 ? 0 : c;
                }
                case BLC2: {
                    if (this.quadro.isBlankX()) {
                        throw new NinaParseException(this.quadro, "invalidaction", new Object[0]);
                    }
                    if (this.quadro.get() == 125) {
                        this.etat = --this.count > 0 ? E.BLC2 : E.CHR0;
                        int c = this.quadro.get();
                        this.quadro.east();
                        return c < 0 ? 0 : c;
                    }
                    if (this.quadro.get() == 59) {
                        this.etat = E.SEM1;
                        int c = this.quadro.get();
                        this.quadro.east();
                        return c < 0 ? 0 : c;
                    }
                    int c = this.quadro.get();
                    this.quadro.east();
                    return c < 0 ? 0 : c;
                }
                case SEM1: {
                    if (this.quadro.isBlankX()) {
                        throw new NinaParseException(this.quadro, "invalidaction", new Object[0]);
                    }
                    if (this.quadro.get() == 125) {
                        this.etat = --this.count > 0 ? E.BLC2 : E.CHR0;
                        int c = this.quadro.get();
                        this.quadro.east();
                        return c < 0 ? 0 : c;
                    }
                    if (this.isfrm2()) {
                        this.quadro.west();
                        this.etat = E.CR2;
                    } else {
                        int c = this.quadro.get();
                        this.quadro.east();
                        return c < 0 ? 0 : c;
                    }
                }
                case CRLF: {
                    if (this.quadro.getScratch() == this) {
                        this.quadro.south();
                        this.etat = E.INIT;
                        return 10;
                    }
                    this.quadro.west();
                    continue block11;
                }
                case CR2: {
                    if (this.quadro.getScratch() == this) {
                        this.quadro.south();
                        this.etat = E.BLC1;
                        return 10;
                    }
                    this.quadro.west();
                    continue block11;
                }
                case EOF: {
                    if (this.isfrm2()) {
                        this.quadro.west();
                        this.etat = E.FIN;
                        continue block11;
                    }
                    this.quadro.north();
                    continue block11;
                }
                case FIN: {
                    return -1;
                }
            }
        }
    }

    @Override
    public int read(char[] b, int off, int len) {
        int i = off;
        while (i < off + len) {
            int c = this.read();
            if (c < 0) {
                return i > off ? i - off : -1;
            }
            b[i] = (char)c;
            ++i;
        }
        return len;
    }

    @Override
    public int read(char[] cbuf) {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public void close() {
        switch (this.etat) {
            case INIT: {
                this.quadro.west();
                while (this.isfrm2()) {
                    this.quadro.north();
                }
                this.quadro.south();
                return;
            }
            case CHR0: {
                while (!this.isfrm2()) {
                    this.quadro.west();
                }
                while (this.isfrm2()) {
                    this.quadro.north();
                }
                this.quadro.south();
                return;
            }
        }
    }

    private static enum E {
        INIT,
        CHR0,
        BLC1,
        BLC2,
        SEM1,
        CRLF,
        CR2,
        EOF,
        FIN;

    }
}

