/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina;

import java.io.StringWriter;
import net.morilib.automata.NFA;
import net.morilib.automata.NFAState;
import net.morilib.nina.NinaAction;
import net.morilib.nina.NinaEvent;
import net.morilib.nina.NinaFrameReader;
import net.morilib.nina.NinaNFA;
import net.morilib.nina.NinaParseException;
import net.morilib.nina.NinaParser;
import net.morilib.nina.NinaState;
import net.morilib.range.Range;

public class NFABuilder
implements NinaAction {
    private NinaNFA nfa = new NinaNFA();
    private NinaState vertex;
    private String label;

    @Override
    public void labelAdded(NinaEvent q, NinaFrameReader rd, boolean accept) {
        int l;
        StringWriter wr = new StringWriter();
        char[] a = new char[1024];
        while ((l = rd.read(a)) >= 0) {
            wr.write(a, 0, l);
        }
        if (this.vertex == null) {
            this.nfa.initial = this.vertex = new NinaState();
        }
        this.vertex.label = wr.toString();
        if (accept) {
            this.nfa.accept.put(this.vertex, null);
        }
    }

    @Override
    public void link(NinaEvent q, Object ver) {
        NinaState v = this.vertex;
        NinaState ninaState = this.vertex = ver != null ? (NinaState)ver : new NinaState();
        if (q.getEdge() instanceof NFA) {
            this.nfa.linkNFA(v, this.vertex, (NFA)q.getEdge());
        } else if (q.getEdge() instanceof Range) {
            this.nfa.linkAlphabet((NFAState)v, (NFAState)this.vertex, (Range)q.getEdge());
        } else {
            this.nfa.linkAlphabet((NFAState)v, (NFAState)this.vertex, q.getEdge());
        }
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public Object getVertex() {
        return this.vertex;
    }

    @Override
    public void setVertex(Object o) {
        this.vertex = (NinaState)o;
    }

    @Override
    public void doneBlockSearching(NinaEvent q) {
        this.vertex = (NinaState)q.getScratch();
    }

    @Override
    public void setEdge(NinaEvent q, Object o) {
        q.setEdge(o);
    }

    @Override
    public void setEdgeResource(NinaEvent q, NinaParser p, String s) {
        q.setEdge(p._compileRes(s, new NFABuilder()));
    }

    @Override
    public void setEdgeNFA(NinaEvent q, NinaParser p, NFA<Object, NFAState, Void> s) {
        q.setEdge(s);
    }

    @Override
    public Object accept() {
        return this.nfa;
    }

    @Override
    public void setMealyEdge(int c) {
        throw new NinaParseException("isnotdfa", new Object[0]);
    }

    @Override
    public void setMealyEdge(Object o) {
        throw new NinaParseException("isnotdfa", new Object[0]);
    }
}

