/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.morilib.automata.DFA;
import net.morilib.automata.DFAState;
import net.morilib.automata.NFA;
import net.morilib.automata.NFAState;
import net.morilib.automata.TextBound;
import net.morilib.automata.dfa.DFAs;
import net.morilib.nina.NinaAction;
import net.morilib.nina.NinaEvent;
import net.morilib.nina.NinaFrameReader;
import net.morilib.nina.NinaNondeterministicException;
import net.morilib.nina.NinaParseException;
import net.morilib.nina.NinaParser;
import net.morilib.range.Interval;
import net.morilib.range.Range;
import net.morilib.util.TreeSectionMap;
import net.morilib.util.Tuple2;

public class DFABuilder
implements NinaAction {
    private DBS initial;
    private DBS vertex;
    private Object mealy;

    private DBS prendEtat(NinaEvent q) {
        DBS s = new DBS();
        s.nomFichier = q.getOption("out");
        s.moore = q.getOptionBoolean("moore");
        return s;
    }

    @Override
    public void labelAdded(NinaEvent q, NinaFrameReader rd, boolean accept) {
        int l;
        StringWriter wr = new StringWriter();
        char[] a = new char[1024];
        while ((l = rd.read(a)) >= 0) {
            wr.write(a, 0, l);
        }
        if (this.vertex == null) {
            this.vertex = this.prendEtat(q);
            this.vertex.initial = true;
            this.initial = this.vertex;
        }
        this.vertex.accepted = accept;
        this.vertex.label = wr.toString();
    }

    @Override
    public void link(NinaEvent q, Object ver) {
        DBS v = this.vertex;
        DBS dBS = this.vertex = ver != null ? (DBS)ver : this.prendEtat(q);
        if (q.getEdge() instanceof Range) {
            v.linkAlphabet(this.vertex, (Range)q.getEdge(), this.mealy);
        } else {
            v.linkAlphabet(this.vertex, q.getEdge(), this.mealy);
        }
    }

    @Override
    public String getLabel() {
        return this.vertex.label;
    }

    @Override
    public Object getVertex() {
        return this.vertex;
    }

    @Override
    public void setVertex(Object o) {
        this.vertex = (DBS)o;
    }

    @Override
    public void doneBlockSearching(NinaEvent q) {
        this.vertex = (DBS)q.getScratch();
    }

    @Override
    public void setEdge(NinaEvent q, Object o) {
        q.setEdge(o);
    }

    @Override
    public void setEdgeResource(NinaEvent q, NinaParser p, String s) {
        throw new NinaParseException("cannotaddnfa", new Object[0]);
    }

    @Override
    public void setEdgeNFA(NinaEvent q, NinaParser p, NFA<Object, NFAState, Void> s) {
        throw new NinaParseException("cannotaddnfa", new Object[0]);
    }

    @Override
    public Object accept() {
        return new DFA<Object, Object, Void>(){

            @Override
            public DFAState<Object, Object, Void> getInitialState() {
                DFABuilder.this.initial.sortirMoore();
                return DFABuilder.this.initial;
            }
        };
    }

    @Override
    public void setMealyEdge(int c) {
        this.mealy = Character.valueOf((char)c);
    }

    @Override
    public void setMealyEdge(Object o) {
        this.mealy = o;
    }

    static class DBS
    implements DFAState<Object, Object, Void> {
        TreeSectionMap<Interval, Object, DBS> edges;
        TreeSectionMap<Interval, Object, Object> mealy;
        boolean initial;
        boolean accepted;
        boolean moore;
        String nomFichier;
        String label;
        PrintWriter out = null;
        int devoirFermer = 0;

        DBS() {
        }

        void linkAlphabet(DBS d, Object o, Object m) {
            if (this.edges == null) {
                this.edges = new TreeSectionMap(Interval.newPoint(o), d);
                this.mealy = new TreeSectionMap(Interval.newPoint(o), m);
            } else if (this.edges.map(o) == null) {
                this.edges.insert(Interval.newPoint(o), d);
                this.mealy.insert(Interval.newPoint(o), m);
            } else {
                throw new NinaNondeterministicException(o.toString());
            }
        }

        void linkAlphabet(DBS d, Range o, Object m) {
            for (Interval v : o.intervals()) {
                if (this.edges == null) {
                    this.edges = new TreeSectionMap(v, d);
                    this.mealy = new TreeSectionMap(v, m);
                    continue;
                }
                for (Tuple2<Interval, DBS> w : this.edges.entries()) {
                    if (o.independentOf(w.getA()) || d.equals(w.getB())) continue;
                    throw new NinaNondeterministicException(o + "," + d + "," + w);
                }
                this.edges.insert(v, d);
            }
        }

        void sortir(Object o) {
            try {
                if (this.nomFichier == null || this.nomFichier.equals("")) {
                    return;
                }
                if (this.out == null) {
                    if (this.nomFichier.equals("/dev/stdout")) {
                        this.out = new PrintWriter(System.out, true);
                        this.devoirFermer = -1;
                    } else if (this.nomFichier.equals("/dev/stderr")) {
                        this.out = new PrintWriter(System.err, true);
                        this.devoirFermer = -1;
                    } else if (this.nomFichier.equals("/dev/null")) {
                        this.out = null;
                    } else {
                        this.out = new PrintWriter(new FileOutputStream(this.nomFichier, this.devoirFermer > 0), true);
                        this.devoirFermer = 1;
                    }
                }
                if (this.out != null && o != null) {
                    this.out.print(o);
                    this.out.flush();
                }
                if (this.devoirFermer > 0) {
                    this.out.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        void sortirMoore() {
            if (this.moore) {
                this.sortir(this.label.trim());
            }
        }

        @Override
        public DFAState<Object, Object, Void> go(Object a) {
            DFAState d;
            this.sortir(this.mealy.map(a));
            if (this.edges == null || (d = (DFAState)this.edges.map(a)) == null) {
                return DFAs.deadState();
            }
            if (d instanceof DBS) {
                ((DBS)d).sortirMoore();
            }
            return d;
        }

        @Override
        public DFAState<Object, Object, Void> goInt(int x) {
            return this.go((Object)x);
        }

        @Override
        public DFAState<Object, Object, Void> goChar(char x) {
            return this.go((Object)x);
        }

        @Override
        public DFAState<Object, Object, Void> goBound(TextBound b) {
            return DFAs.deadState();
        }

        @Override
        public boolean isInitialState() {
            return this.initial;
        }

        @Override
        public Set<Object> getAccepted() {
            return this.accepted ? Collections.singleton(this.label) : Collections.emptySet();
        }

        @Override
        public boolean isDead() {
            return this.edges == null;
        }

        @Override
        public boolean isAccepted() {
            return this.accepted;
        }

        @Override
        public Set<Object> getAlphabets() {
            HashSet<Object> r = new HashSet<Object>();
            for (Interval v : this.edges.keys()) {
                Object b;
                Object a = v.getInfimumBound();
                if (a.equals(b = v.getSupremumBound())) {
                    r.add(a);
                    continue;
                }
                if (a instanceof Integer) {
                    int x;
                    int i = x = ((Integer)a).intValue();
                    while (v.contains(i)) {
                        r.add(i);
                        ++i;
                    }
                    continue;
                }
                throw new NinaParseException("invalidalphabet", a);
            }
            return r;
        }

        @Override
        public Iterable<Interval> getAlphabetRanges() {
            return this.edges != null ? this.edges.keys() : Collections.emptySet();
        }

        @Override
        public Object getLabel(Object a) {
            return this.mealy.map(a);
        }

        @Override
        public Object getLabelInt(int x) {
            return this.getLabel((Object)x);
        }

        @Override
        public Object getLabelChar(char x) {
            return this.getLabel((Object)x);
        }

        public String toString() {
            return this.label;
        }
    }
}

