/*------------*/
/* conffile.h */
/*------------*/
#define BITMAPFILELISTNAME "bitmapfilelist.lst"

#include "bitmap.h"
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <GL/glut.h>
int g_picturenum=0;

class bitmapfilelist {
  private:
    char *filelist;
    int filelistcnt;
    bool rememset();
    int memsize;
  public:
     bitmapfilelist();
    ~bitmapfilelist();
    bool add_bitmapfile_to_list(char *filename);
};

bitmapfilelist makefilelist;


typedef struct _bitmapheader {
    char distinct1, distinct2;  //B
    int filesize;               //総ファイルサイズ
    short reserve1, reserve2;   //予約領域　常に0だそうです
    int offset;
} bitmap_header;


typedef struct _bitmapinfoheader {
    int header;
    int width, height;
    short plane;
    short bits;
    int compression;
    int comp_image_size;
    int x_resolution, y_resolution;
    int pallet_num;
    int important_pallet_num;
} bitmap_info_header;




void init_headers(bitmap_header * header, bitmap_info_header * info)
{
    header->distinct1 = 'B';
    header->distinct2 = 'M';
    header->filesize = 0;
    header->reserve1 = 0;
    header->reserve2 = 0;
    header->offset = 54;

    info->header = 40;
    info->width = 0;
    info->height = 0;
    info->plane = 1;
    info->bits = 24;
    info->compression = 0;
    info->x_resolution = 0;
    info->y_resolution = 0;
    info->pallet_num = 0;
    info->important_pallet_num = 0;
}

void write_header(bitmap_header * header, FILE * fp)
{
    fwrite(&(header->distinct1), sizeof(char), 1, fp);
    fwrite(&(header->distinct2), sizeof(char), 1, fp);
    fwrite(&(header->filesize), sizeof(int), 1, fp);
    fwrite(&(header->reserve1), sizeof(short), 1, fp);
    fwrite(&(header->reserve2), sizeof(short), 1, fp);
    fwrite(&(header->offset), sizeof(int), 1, fp);
}

void write_info_header(bitmap_info_header * info, FILE * fp)
{
    fwrite(&(info->header), sizeof(int), 1, fp);
    fwrite(&(info->width), sizeof(int), 1, fp);
    fwrite(&(info->height), sizeof(int), 1, fp);
    fwrite(&(info->plane), sizeof(short), 1, fp);
    fwrite(&(info->bits), sizeof(short), 1, fp);
    fwrite(&(info->compression), sizeof(int), 1, fp);
    fwrite(&(info->comp_image_size), sizeof(int), 1, fp);
    fwrite(&(info->x_resolution), sizeof(int), 1, fp);
    fwrite(&(info->y_resolution), sizeof(int), 1, fp);
    fwrite(&(info->pallet_num), sizeof(int), 1, fp);
}


bool write_bitmap(const char *filename, GLubyte * data, int width, int height)
{
    FILE *fp;
    bitmap_header header;
    bitmap_info_header info;

    int i = 0, j = 0, x, y;

    if ((fp = fopen(filename, "wb")) == NULL)
      {
          return false;
      }
    init_headers(&header, &info);       //ヘッダ構造体の初期化

    //Bitmapサイズ
    info.width = width;
    info.height = height;
    int write_width;

    //*** データの幅のバイト数が4の倍数でなければならない。***//
    //1pxにRGBの3byte
    //widthは横方向。1行のデータサイズを計算してる(多分)
    //4の倍数か
    if (width * 3 % 4 == 0)     //4の倍数になってる！
      {
          write_width = width * 3;
    } else                      //4の倍数じゃない！
      {
          //width*3 + (4の倍数に足りない数)
          write_width = width * 3 + (4 - ((width * 3) % 4));
      }
    //*** ファイル容量の計算 ***//

    // write_width * height      1行のバイト数*行数
    // 14  bitmap header構造体サイズ
    //40   bitmap info header構造体サイズ
    header.filesize = write_width + 14 + 40;
    write_header(&header, fp);
    write_info_header(&info, fp);

    unsigned char zero = 0;
    //イメージデータの書き込み
    //各ピクセルに対する処理の為の二重ループ
    for (y = 0; y < height; y++)
      {
          for (x = 0; x < width; x++)
            {
                //各ピクセルに3つ(RGB)のデータ
                j = fwrite((data + x * 3 + 3 * y * width + 2), sizeof(GLubyte),
                           1, fp);
                j = fwrite((data + x * 3 + 3 * y * width + 1), sizeof(GLubyte),
                           1, fp);
                j = fwrite((data + x * 3 + 3 * y * width + 0), sizeof(GLubyte),
                           1, fp);
            }
          //幅が4の倍数出ないときは0で埋める
          if (width * 3 % 4 != 0)
            {
                for (j = 0; j < 4 - (width * 3) % 4; j++)
                  {
                      fwrite(&zero, sizeof(GLubyte), 1, fp);
                  }
            }
      }
    fclose(fp);
    return true;
}

void capture_screen(int width, int height)
{
    GLubyte *pixel_data =
        (GLubyte *) malloc(width * height * 3 * (sizeof(GLubyte)));
    glPixelStorei(GL_PACK_ALIGNMENT, 1);
    glReadPixels(0, 0, width, height, GL_RGB, GL_UNSIGNED_BYTE, pixel_data);
    char filename[1024];
    sprintf(filename, "%05dscreenshot.bmp", g_picturenum);
    write_bitmap(filename, pixel_data, width, height);
    makefilelist.add_bitmapfile_to_list(filename);
    g_picturenum++;
    char hoge[1024];
    free(pixel_data);
}

bitmapfilelist::bitmapfilelist()
{
    memsize = 1024;
    filelistcnt = 0;
    filelist = (char *) malloc(memsize * sizeof(char));
    *filelist = '\0';
}

bitmapfilelist::~bitmapfilelist()
{
    FILE *fp = fopen(BITMAPFILELISTNAME, "w");
    fprintf(fp, "%s", filelist);
    fclose(fp);
    free(filelist);
}


bool bitmapfilelist::add_bitmapfile_to_list(char *filename)
{
    char *c;
    //もし、filelistに改行コードが付いていなかったら付加
    c = strrchr(filename, '\n');
    if (c == NULL)              //改行コード無
        strcat(filelist, "\n");

    //メモリが足りるか調べる
    if (memsize < (strlen(filelist) + strlen(filename) + 1))
      {
          //メモリが足りなかったら確保し直し
          rememset();
      }
    //ファイルリストに追加
    strcat(filelist, filename);
    //改行コードを消す
    //*strrchr(filename,'\n')='\0';
    return true;
}

bool bitmapfilelist::rememset()
{
    char *mbuf;
    memsize += 1024;
    //mbuf=(char *)realloc(filelist,memsize);
    mbuf = (char *) malloc(memsize * sizeof(char));
    strcpy(mbuf, filelist);
    free(filelist);
    filelist = mbuf;
}
