/* TEhfoCXn */

#include "bootpack.h"

/* Adlib֘A */

/* ẼXs[J[ */
#define	LEFT_SPEKER_D	0x0220	/* Left Data W */
#define LEFT_SPEKER_A	0x0221	/* Left Addresss R/W */
#define RIGHT_SPEKER_D	0x0222	/* Right Data W */
#define RIGHT_SPEKER_A	0x0223	/* Right Address R/W */

/* p */
#define DATA_PORT		0x0389	/* Both Data W */
#define ADDRESS_PORT	0x0388	/* Both Address R/W */

/* Adlib݂̑mF */
int detect_fmchip(void)
{
	int exist1 = 0, exist2 = 0;

	/* AdLib̗LmF tF[Y1 */
	io_out8(ADDRESS_PORT, 4);
	io_out8(DATA_PORT, 0x60);
	io_out8(ADDRESS_PORT, 4);
	io_out8(DATA_PORT, 0x80);
	exist1 = io_in8(ADDRESS_PORT);
	
	/* AdLib̗LmF tF[Y2 */
	io_out8(ADDRESS_PORT, 2);
	io_out8(DATA_PORT, 0xff);
	io_out8(ADDRESS_PORT, 4);
	io_out8(DATA_PORT, 0x21);
	
	/* 80}CNb̒ẍׂ1b̃EGCg */
	kernel_sleep(100);
	
	exist2 = io_in8(ADDRESS_PORT);
	
	/* AdLib̗LmF tF[Y3 */
	io_out8(ADDRESS_PORT, 4);
	io_out8(DATA_PORT, 0x60);
	io_out8(ADDRESS_PORT, 4);
	io_out8(DATA_PORT, 0x80);
	exist1 &= 0xe0;
	exist2 &= 0xe0;
	if (exist1 == 0x00 && exist2 == 0xc0) 
		return 1;
	else 
		return 0;
}

/* adlibփf[^𑗂 */
void senddata_adlib(int port, int data)
{
	io_out8(ADDRESS_PORT, port);
	io_out8(DATA_PORT, data);
	return;
}

/* adlibf[^ǂ */
int readdata_adlib(void)
{
	return io_in8(ADDRESS_PORT);
}

/* ̃eXg D# */
/* ڍׂosdev-j̃y[W */
void test_adlib(void)
{
	senddata_adlib(20, 1);
	senddata_adlib(40, 10);
	senddata_adlib(60, 0xf0);
	senddata_adlib(80, 77);
	senddata_adlib(0xa0, 98);
	senddata_adlib(23, 1);
	senddata_adlib(43, 0);
	senddata_adlib(63, 0xf0);
	senddata_adlib(83, 77);
	senddata_adlib(0xb0, 31);
	kernel_sleep(100);
	senddata_adlib(0xb0, 11);
	return;
}

/* SoundBlaster16 */

/* I/O Ports */
#define DSP_RESET	0x0226
#define DSP_READ	0x022A
#define DSP_WRITE	0x022C
#define DSP_STETUS	0x022E

#define	DSP_RETSTAT	0x0AA

int reset_dsp(void)
{
	int r;

	io_out8(DSP_RESET, 1);
	kernel_sleep(50);
	io_out8(DSP_RESET, 0);
	
	for (r = 0;r < 5;r++) {
		if (!(io_in8(DSP_STETUS) & 7)) {
			if (io_in8(DSP_READ) == DSP_RETSTAT) 
				return 1;
		}
		kernel_sleep(100);
	}
	
	return 0;
}

void write_dsp(int data)
{
	for (;;) {
		if ((io_in8(DSP_WRITE) & 7))
			io_out8(DSP_WRITE, data);
	}
	return;
}

int read_dsp(void)
{
	for (;;) {
		if (!(io_in8(DSP_STETUS) & 7))
			return io_in8(DSP_READ);
	}
}

int getdata_dsp(int id)
{
	if (id == DSP_VERSION) write_dsp(0xe1);
	else if (id == DSP_SPKSTAT) write_dsp(0xd8);
	return read_dsp();
}

