<?php
	require("../__common__/__define_common.php");
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="author" content="ok.2nd">
<link rel="stylesheet" href="<?= _STYLE_SHEET_FOLDER ?>/tools_common.css?20120406">
<title>縦計だけの表計算</title>
<?php
	if (!defined("CALC_ROWS_NUM")) {
		define("CALC_ROWS_NUM", 20);
	}
	if (!defined("CALC_COLS_NUM")) {
		define("CALC_COLS_NUM", 5);
	}
	if (!defined("CALC_INPUT_SIZE")) {
		define("CALC_INPUT_SIZE", 20);
	}
?>
<style>
body {
	margin: 10px;
}
#title{
	font-size: 120%;
	font-weight: bold;
}
#total {
	background-color: #ffffff;
}
.inputRow input {
	ime-mode: disabled;
}
td.totalRow {
	border-style: solid;
	border-color: #ff0000;
	border-width: 3px 0 0 0;
}
</style>
<script>
// EnterキーをTabキーに変換(Google Chrome対応)
// by http://code.nanigac.com/source/view/686
document.onkeydown = Enter2Tab;
function Enter2Tab(Event,quoi) {
	if (navigator.appName == "Microsoft Internet Explorer") {
		if(event.keyCode == 13){		// Enter
			event.keyCode = 9;		// Tab
		}
	} else {
		var cle;
		cle = Event.keyCode;
		if (cle=='13') {
			var target = Event.srcElement ? Event.srcElement : Event.target;
			var targetTabIndex = target.tabIndex;
			var nextTabIndex = targetTabIndex+1;
			var nextElement = getElementByTabIndex(nextTabIndex);
			if (nextElement) {
				nextElement.focus();
				Event.cancelBubble = true;
				Event.returnValue = false;
				if (Event.preventDefault) Event.preventDefault();
				if (Event.stopPropagation) Event.stopPropagation();
					return false;
			}
			return true;
		}
	}
}
function getElementByTabIndex(tabIndex) {
	var form = document.forms[0];
	for (var i=0; i<form.elements.length; i++) {
		 var el = form.elements[i];
		 if (el.tabIndex && el.tabIndex == tabIndex) {
			return el;
		 }
	}
	return null;
}
function calcSum(col) {
	total = 0;
	for (ix=1; ix<=<?= CALC_ROWS_NUM ?>; ix++) {
		inp = document.getElementById('input'+col+'_'+ix).value;
		if (inp != '') {
			if (!isNaN(inp)) {
				total += parseFloat(inp);
				document.getElementById('val'+col+'_'+ix).innerHTML = '';
			} else {
				val = evalNum(inp);
				if (!isNaN(val)) {
					total += val;
				}
				if (navigator.appName != "Microsoft Internet Explorer") {
					val = '<font>'+val+'</font>';	// Chrome 改行防止のおまじない(?)
				}
				document.getElementById('val'+col+'_'+ix).innerHTML = val;
			}
		} else {
			document.getElementById('val'+col+'_'+ix).innerHTML = '';
		}
	}
	document.getElementById('total'+col).value = total;
}
function evalNum(str) {
	if (str == '') return 0;
	try {
		res = eval(str);
	} catch(e) {
		return '<font color=red>Err</font>';
	}
	return res;
}
function cellClear(col) {
	for(ix=1; ix<=<?= CALC_ROWS_NUM ?>; ix++){
		document.getElementById('input'+col+'_'+ix).value = '';
		document.getElementById('val'+col+'_'+ix).innerHTML = '';
	}
	document.getElementById('total'+col).value = '';
}
</script>
</head>
<body bgcolor="#e0e0e0" onload="document.getElementById('input1_1').focus()">
<p id="tool_title_area">
<a href="../tools/" class="return_index">■</a>
<span id="tool_title">縦計だけの表計算</span>
</p>
<form>
<table cellpadding=0 cellspacing=0>
<tr>
<?php
	for ($col=1; $col<=CALC_COLS_NUM; $col++) {
?>
	<td>
	<table cellpadding=0 cellspacing=0>
	<? for ($ix=1; $ix<=CALC_ROWS_NUM; $ix++) { ?>
	<tr>
	<td class="inputRow"><input class="text" type="text" tabindex="<?= $col*(CALC_ROWS_NUM-1)+$ix ?>" id="input<?= $col ?>_<?= $ix ?>" size="<?= CALC_INPUT_SIZE ?>" value="" onChange="calcSum(<?= $col ?>)"><span id="val<?= $col ?>_<?= $ix ?>" style="color:green;>"></span></td>
	</tr>
	<? } ?>
	<tr>
	<td class="totalRow"><input class="text" type="text" id="total<?= $col ?>" size="<?= CALC_INPUT_SIZE ?>" value=""></td>
	</tr>
	</table>
	<input class="input_form_button" type="button" onClick="cellClear(<?= $col ?>)" value="クリア">
	</td>
<?php
	}
?>
</tr>
</table>
</form>
<p style="margin-top:10px; color:#808080;">
セルには()付きの数式を入力できます。eval()で評価していますので、数学関数(<a href="http://ja.wikibooks.org/wiki/JavaScript_%E6%A8%99%E6%BA%96%E3%83%A9%E3%82%A4%E3%83%96%E3%83%A9%E3%83%AA_Math" target="_blank">Math</a>)なども使えます。<br>
数字以外は、JavaScriptとして評価して実行しますので、ご注意ください。<br>
例えば、「<a href='#' onClick='alert(Date());return false'>alert(Date());</a>」なども実行できます。<br>
</p>
</body>
</html>
