/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.framework.utils;

import jp.mosp.framework.base.MospParams;

/**
 * メッセージに関するユーティリティクラス。<br>
 * <br>
 * フレームワークにおいてサーバ側プログラムで作成されるメッセージは、
 * 全てこのクラスを通じて作成される(予定)。<br>
 * <br>
 */
public class MessageUtility {
	
	/**
	 * 他クラスからのインスタンス化を防止する。<br>
	 */
	private MessageUtility() {
		// 処理無し
	}
	
	/**
	 * 行番号が付加されたフィールド名を取得する。<br>
	 * 行インデックスがnullでない場合、エラーメッセージに行番号が加えられる。<br>
	 * @param mospParams MosP処理情報
	 * @param fieldName 対象フィールド名
	 * @param row       対象行インデックス
	 * @return 行番号が付加されたフィールド名
	 */
	public static String getRowedFieldName(MospParams mospParams, String fieldName, Integer row) {
		// 対象行インデックス確認
		if (row == null) {
			return fieldName;
		}
		// メッセージ置換文字列追加
		return getRowColonName(mospParams, row.intValue()) + fieldName;
	}
	
	/**
	 * 名称(行row+1：)を取得する。<br>
	 * @param mospParams MosP処理情報
	 * @param row 対象行インデックス
	 * @return 名称(行row+1：)
	 */
	protected static String getRowColonName(MospParams mospParams, int row) {
		return mospParams.getName("Row") + String.valueOf(row + 1) + mospParams.getName("Colon");
	}
	
	/**
	 * 列名称を取得する。<br>
	 * @param mospParams MosP処理情報
	 * @return 列名称
	 */
	protected static String getNameRow(MospParams mospParams) {
		return mospParams.getName("Row");
	}
	
	/**
	 * ：名称を取得する。<br>
	 * @param mospParams MosP処理情報
	 * @return ：名称
	 */
	protected static String getNameColon(MospParams mospParams) {
		return mospParams.getName("Colon");
	}
	
}
