/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.nntp;

import gnu.inet.nntp.NNTPConnection;
import java.io.FilterOutputStream;
import java.io.IOException;

public final class PostStream
extends FilterOutputStream {
    NNTPConnection connection;
    boolean isTakethis;
    byte last;

    PostStream(NNTPConnection connection, boolean isTakethis) {
        super(connection.out);
        this.connection = connection;
        this.isTakethis = isTakethis;
    }

    @Override
    public void write(int c) throws IOException {
        super.write(c);
        this.last = (byte)c;
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] bytes, int pos, int len) throws IOException {
        super.write(bytes, pos, len);
        if (len > 0) {
            this.last = bytes[pos + len - 1];
        }
    }

    @Override
    public void close() throws IOException {
        if (this.last != 13) {
            this.write(13);
        }
        if (this.isTakethis) {
            this.connection.takethisComplete();
        } else {
            this.connection.postComplete();
        }
    }
}

