/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.table;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.ColumnFactory;
import net.sf.jasperreports.components.table.TableComponent;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.util.JRCloneUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardTable
implements TableComponent,
Serializable,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_DATASET_RUN = "datasetRun";
    public static final String PROPERTY_COLUMNS = "columns";
    private JRDatasetRun datasetRun;
    private List<BaseColumn> columns;
    private transient JRPropertyChangeSupport eventSupport;

    public StandardTable() {
        this.columns = new ArrayList<BaseColumn>();
    }

    public StandardTable(TableComponent table, JRBaseObjectFactory factory) {
        this.datasetRun = factory.getDatasetRun(table.getDatasetRun());
        ColumnFactory columnFactory = new ColumnFactory(factory);
        this.columns = columnFactory.createColumns(table.getColumns());
    }

    @Override
    public List<BaseColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(List<BaseColumn> columns) {
        List<BaseColumn> old = this.columns;
        this.columns = columns;
        this.getEventSupport().firePropertyChange(PROPERTY_COLUMNS, old, this.columns);
    }

    public void addColumn(BaseColumn column) {
        this.columns.add(column);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_COLUMNS, column, this.columns.size() - 1);
    }

    public boolean removeColumn(BaseColumn column) {
        int idx = this.columns.indexOf(column);
        if (idx >= 0) {
            this.columns.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_COLUMNS, column, idx);
        }
        return idx >= 0;
    }

    @Override
    public JRDatasetRun getDatasetRun() {
        return this.datasetRun;
    }

    public void setDatasetRun(JRDatasetRun datasetRun) {
        JRDatasetRun old = this.datasetRun;
        this.datasetRun = datasetRun;
        this.getEventSupport().firePropertyChange(PROPERTY_DATASET_RUN, old, this.datasetRun);
    }

    @Override
    public Object clone() {
        try {
            StandardTable clone = (StandardTable)super.clone();
            clone.datasetRun = (JRDatasetRun)JRCloneUtils.nullSafeClone(this.datasetRun);
            clone.columns = JRCloneUtils.cloneList(this.columns);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        StandardTable standardTable = this;
        synchronized (standardTable) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }
}

