/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.Font;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import net.sf.jasperreports.engine.util.JRFontUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextClassLoaderObjectInputStream
extends ObjectInputStream {
    public ContextClassLoaderObjectInputStream(InputStream in) throws IOException {
        super(in);
        try {
            this.enableResolveObject(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        try {
            return super.resolveClass(desc);
        }
        catch (ClassNotFoundException e) {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader == null) {
                throw e;
            }
            String name = desc.getName();
            try {
                return Class.forName(name, false, contextClassLoader);
            }
            catch (ClassNotFoundException e2) {
                throw e;
            }
        }
    }

    @Override
    protected Object resolveObject(Object obj) throws IOException {
        String fontName;
        Font newFont;
        Font font;
        Font font2 = font = obj instanceof Font ? (Font)obj : null;
        if (font != null && (newFont = JRFontUtil.getAwtFontFromBundles(fontName = font.getName(), font.getStyle(), font.getSize(), null, true)) != null) {
            return newFont.deriveFont(font.getAttributes());
        }
        return obj;
    }
}

