/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.type.SortFieldTypeEnum;
import net.sf.jasperreports.engine.type.SortOrderEnum;

public class JRBaseSortField
implements JRSortField,
Serializable,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_ORDER = "order";
    protected String name;
    protected SortOrderEnum orderValue = SortOrderEnum.ASCENDING;
    protected SortFieldTypeEnum type = SortFieldTypeEnum.FIELD;
    private transient JRPropertyChangeSupport eventSupport;
    private int PSEUDO_SERIAL_VERSION_UID = 40103;
    private byte order;

    protected JRBaseSortField() {
    }

    protected JRBaseSortField(JRSortField sortField, JRBaseObjectFactory factory) {
        factory.put(sortField, this);
        this.name = sortField.getName();
        this.orderValue = sortField.getOrderValue();
        this.type = sortField.getType();
    }

    public String getName() {
        return this.name;
    }

    public SortOrderEnum getOrderValue() {
        return this.orderValue;
    }

    public void setOrder(SortOrderEnum orderValue) {
        SortOrderEnum old = this.orderValue;
        this.orderValue = orderValue;
        this.getEventSupport().firePropertyChange(PROPERTY_ORDER, old, this.orderValue);
    }

    public SortFieldTypeEnum getType() {
        return this.type;
    }

    public Object clone() {
        try {
            JRBaseSortField clone = (JRBaseSortField)super.clone();
            clone.eventSupport = null;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        JRBaseSortField jRBaseSortField = this;
        synchronized (jRBaseSortField) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.orderValue = SortOrderEnum.getByValue((byte)(this.order + 1));
        }
        if (this.PSEUDO_SERIAL_VERSION_UID < 30705) {
            this.type = SortFieldTypeEnum.FIELD;
        }
    }
}

