/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.Deduplicable;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRParagraph;
import net.sf.jasperreports.engine.JRParagraphContainer;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.TabStop;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.type.LineSpacingEnum;
import net.sf.jasperreports.engine.util.JRCloneUtils;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.util.ObjectUtils;

public class JRBaseParagraph
implements JRParagraph,
Serializable,
Cloneable,
JRChangeEventsSupport,
Deduplicable {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_LINE_SPACING = "lineSpacing";
    public static final String PROPERTY_LINE_SPACING_SIZE = "lineSpacingSize";
    public static final String PROPERTY_FIRST_LINE_INDENT = "firstLineIndent";
    public static final String PROPERTY_LEFT_INDENT = "leftIndent";
    public static final String PROPERTY_RIGHT_INDENT = "rightIndent";
    public static final String PROPERTY_SPACING_BEFORE = "spacingBefore";
    public static final String PROPERTY_SPACING_AFTER = "spacingAfter";
    public static final String PROPERTY_TAB_STOP_WIDTH = "tabStopWidth";
    public static final String PROPERTY_TAB_STOPS = "tabStops";
    protected JRParagraphContainer paragraphContainer;
    protected LineSpacingEnum lineSpacing;
    protected Float lineSpacingSize;
    protected Integer firstLineIndent;
    protected Integer leftIndent;
    protected Integer rightIndent;
    protected Integer spacingBefore;
    protected Integer spacingAfter;
    protected Integer tabStopWidth;
    protected List<TabStop> tabStops;
    private transient JRPropertyChangeSupport eventSupport;

    public JRBaseParagraph(JRParagraphContainer paragraphContainer) {
        this.paragraphContainer = paragraphContainer;
    }

    public JRDefaultStyleProvider getDefaultStyleProvider() {
        if (this.paragraphContainer != null) {
            return this.paragraphContainer.getDefaultStyleProvider();
        }
        return null;
    }

    public JRStyle getStyle() {
        if (this.paragraphContainer != null) {
            return this.paragraphContainer.getStyle();
        }
        return null;
    }

    public String getStyleNameReference() {
        if (this.paragraphContainer != null) {
            return this.paragraphContainer.getStyleNameReference();
        }
        return null;
    }

    public JRParagraphContainer getParagraphContainer() {
        return this.paragraphContainer;
    }

    public LineSpacingEnum getLineSpacing() {
        return JRStyleResolver.getLineSpacing(this);
    }

    public LineSpacingEnum getOwnLineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(LineSpacingEnum lineSpacing) {
        LineSpacingEnum old = this.lineSpacing;
        this.lineSpacing = lineSpacing;
        this.getEventSupport().firePropertyChange(PROPERTY_LINE_SPACING, old, this.lineSpacing);
    }

    public Float getLineSpacingSize() {
        return JRStyleResolver.getLineSpacingSize(this);
    }

    public Float getOwnLineSpacingSize() {
        return this.lineSpacingSize;
    }

    public void setLineSpacingSize(Float lineSpacingSize) {
        Float old = this.lineSpacingSize;
        this.lineSpacingSize = lineSpacingSize;
        this.getEventSupport().firePropertyChange(PROPERTY_LINE_SPACING_SIZE, old, this.lineSpacingSize);
    }

    public Integer getFirstLineIndent() {
        return JRStyleResolver.getFirstLineIndent(this);
    }

    public Integer getOwnFirstLineIndent() {
        return this.firstLineIndent;
    }

    public void setFirstLineIndent(Integer firstLineIndent) {
        Integer old = this.firstLineIndent;
        this.firstLineIndent = firstLineIndent;
        this.getEventSupport().firePropertyChange(PROPERTY_FIRST_LINE_INDENT, old, this.firstLineIndent);
    }

    public Integer getLeftIndent() {
        return JRStyleResolver.getLeftIndent(this);
    }

    public Integer getOwnLeftIndent() {
        return this.leftIndent;
    }

    public void setLeftIndent(Integer leftIndent) {
        Integer old = this.leftIndent;
        this.leftIndent = leftIndent;
        this.getEventSupport().firePropertyChange(PROPERTY_LEFT_INDENT, old, this.leftIndent);
    }

    public Integer getRightIndent() {
        return JRStyleResolver.getRightIndent(this);
    }

    public Integer getOwnRightIndent() {
        return this.rightIndent;
    }

    public void setRightIndent(Integer rightIndent) {
        Integer old = this.rightIndent;
        this.rightIndent = rightIndent;
        this.getEventSupport().firePropertyChange(PROPERTY_RIGHT_INDENT, old, this.rightIndent);
    }

    public Integer getSpacingBefore() {
        return JRStyleResolver.getSpacingBefore(this);
    }

    public Integer getOwnSpacingBefore() {
        return this.spacingBefore;
    }

    public void setSpacingBefore(Integer spacingBefore) {
        Integer old = this.spacingBefore;
        this.spacingBefore = spacingBefore;
        this.getEventSupport().firePropertyChange(PROPERTY_SPACING_BEFORE, old, this.spacingBefore);
    }

    public Integer getSpacingAfter() {
        return JRStyleResolver.getSpacingAfter(this);
    }

    public Integer getOwnSpacingAfter() {
        return this.spacingAfter;
    }

    public void setSpacingAfter(Integer spacingAfter) {
        Integer old = this.spacingAfter;
        this.spacingAfter = spacingAfter;
        this.getEventSupport().firePropertyChange(PROPERTY_SPACING_AFTER, old, this.spacingAfter);
    }

    public Integer getTabStopWidth() {
        return JRStyleResolver.getTabStopWidth(this);
    }

    public Integer getOwnTabStopWidth() {
        return this.tabStopWidth;
    }

    public void setTabStopWidth(Integer tabStopWidth) {
        Integer old = this.tabStopWidth;
        this.tabStopWidth = tabStopWidth;
        this.getEventSupport().firePropertyChange(PROPERTY_TAB_STOP_WIDTH, old, this.tabStopWidth);
    }

    public TabStop[] getTabStops() {
        return JRStyleResolver.getTabStops(this);
    }

    public TabStop[] getOwnTabStops() {
        if (this.tabStops == null || this.tabStops.size() == 0) {
            return null;
        }
        return this.tabStops.toArray(new TabStop[this.tabStops.size()]);
    }

    public void addTabStop(TabStop tabStop) {
        if (this.tabStops == null) {
            this.tabStops = new ArrayList<TabStop>();
        }
        this.tabStops.add(tabStop);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_TAB_STOPS, tabStop, this.tabStops.size() - 1);
    }

    public void addTabStop(int index, TabStop tabStop) {
        if (this.tabStops == null) {
            this.tabStops = new ArrayList<TabStop>();
        }
        this.tabStops.add(index, tabStop);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_TAB_STOPS, tabStop, index);
    }

    public void removeTabStop(TabStop tabStop) {
        int index;
        if (this.tabStops != null && (index = this.tabStops.indexOf(tabStop)) >= 0) {
            this.tabStops.remove(index);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_TAB_STOPS, tabStop, index);
        }
    }

    public void removeTabStop(int index) {
        if (this.tabStops != null && index >= 0 && index < this.tabStops.size()) {
            TabStop tabStop = this.tabStops.remove(index);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_TAB_STOPS, tabStop, index);
        }
    }

    public JRParagraph clone(JRParagraphContainer paragraphContainer) {
        JRBaseParagraph clone = null;
        try {
            clone = (JRBaseParagraph)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        clone.paragraphContainer = paragraphContainer;
        clone.tabStops = JRCloneUtils.cloneList(this.tabStops);
        clone.eventSupport = null;
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        JRBaseParagraph jRBaseParagraph = this;
        synchronized (jRBaseParagraph) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    public int getHashCode() {
        ObjectUtils.HashCode hash = ObjectUtils.hash();
        hash.add(this.lineSpacing);
        hash.add(this.lineSpacingSize);
        hash.add(this.firstLineIndent);
        hash.add(this.leftIndent);
        hash.add(this.rightIndent);
        hash.add(this.spacingBefore);
        hash.add(this.spacingAfter);
        hash.add(this.tabStopWidth);
        hash.addIdentical(this.tabStops);
        return hash.getHashCode();
    }

    public boolean isIdentical(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JRBaseParagraph)) {
            return false;
        }
        JRBaseParagraph para = (JRBaseParagraph)object;
        return ObjectUtils.equals(this.lineSpacing, para.lineSpacing) && ObjectUtils.equals(this.lineSpacingSize, para.lineSpacingSize) && ObjectUtils.equals(this.firstLineIndent, para.firstLineIndent) && ObjectUtils.equals(this.leftIndent, para.leftIndent) && ObjectUtils.equals(this.rightIndent, para.rightIndent) && ObjectUtils.equals(this.spacingBefore, para.spacingBefore) && ObjectUtils.equals(this.spacingAfter, para.spacingAfter) && ObjectUtils.equals(this.tabStopWidth, para.tabStopWidth) && ObjectUtils.identical(this.tabStops, para.tabStops);
    }
}

