/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.table;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.Cell;
import net.sf.jasperreports.components.table.Column;
import net.sf.jasperreports.components.table.ColumnExpressionCollector;
import net.sf.jasperreports.components.table.ColumnGroup;
import net.sf.jasperreports.components.table.ColumnVisitor;
import net.sf.jasperreports.components.table.GroupCell;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.components.table.TableComponent;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentCompiler;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRVerifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableCompiler
implements ComponentCompiler {
    @Override
    public void collectExpressions(Component component, JRExpressionCollector collector) {
        TableComponent table = (TableComponent)component;
        JRDatasetRun datasetRun = table.getDatasetRun();
        collector.collect(datasetRun);
        JRExpressionCollector datasetCollector = collector.getDatasetCollector(datasetRun.getDatasetName());
        ColumnExpressionCollector columnCollector = new ColumnExpressionCollector(collector, datasetCollector);
        columnCollector.collectColumns(table.getColumns());
    }

    @Override
    public Component toCompiledComponent(Component component, JRBaseObjectFactory baseFactory) {
        TableComponent table = (TableComponent)component;
        return new StandardTable(table, baseFactory);
    }

    @Override
    public void verify(Component component, JRVerifier verifier) {
        TableComponent table = (TableComponent)component;
        JRDatasetRun datasetRun = table.getDatasetRun();
        if (datasetRun == null) {
            verifier.addBrokenRule("No list subdataset run set", (Object)table);
        } else {
            verifier.verifyDatasetRun(datasetRun);
        }
        List<BaseColumn> columns = table.getColumns();
        if (columns == null || columns.isEmpty()) {
            verifier.addBrokenRule("No columns defined in the table", (Object)table);
        } else if (!this.detectLoops(verifier, columns)) {
            this.verifyColumns(table, verifier);
            this.verifyColumnHeights(table, verifier);
        }
    }

    protected boolean detectLoops(JRVerifier verifier, List<BaseColumn> columns) {
        HashSet<BaseColumn> parents = new HashSet<BaseColumn>();
        return this.detectLoops(verifier, columns, parents);
    }

    protected boolean detectLoops(final JRVerifier verifier, List<BaseColumn> columns, final Set<BaseColumn> parents) {
        boolean loop = false;
        for (BaseColumn column : columns) {
            if (parents.contains(column)) {
                verifier.addBrokenRule("Table column is its own ancestor", (Object)column);
                loop = true;
            } else {
                loop = column.visitColumn(new ColumnVisitor<Boolean>(){

                    @Override
                    public Boolean visitColumn(Column column) {
                        return false;
                    }

                    @Override
                    public Boolean visitColumnGroup(ColumnGroup columnGroup) {
                        parents.add(columnGroup);
                        boolean loopDetected = TableCompiler.this.detectLoops(verifier, columnGroup.getColumns(), parents);
                        parents.remove(columnGroup);
                        return loopDetected;
                    }
                });
            }
            if (!loop) continue;
            break;
        }
        return false;
    }

    protected void verifyColumns(final TableComponent table, final JRVerifier verifier) {
        ColumnVisitor<Void> columnVerifier = new ColumnVisitor<Void>(){

            @Override
            public Void visitColumn(Column column) {
                TableCompiler.this.verifyColumn(table, column, verifier);
                return null;
            }

            @Override
            public Void visitColumnGroup(ColumnGroup columnGroup) {
                TableCompiler.this.verifyBaseColumn(table, columnGroup, verifier);
                List<BaseColumn> subcolumns = columnGroup.getColumns();
                if (subcolumns == null || subcolumns.isEmpty()) {
                    verifier.addBrokenRule("No columns defined in column group", (Object)columnGroup);
                } else {
                    int subwidth = 0;
                    boolean subwidthValid = true;
                    for (BaseColumn column : columnGroup.getColumns()) {
                        column.visitColumn(this);
                        Integer width = column.getWidth();
                        if (width == null) {
                            subwidthValid = false;
                            continue;
                        }
                        subwidth += width.intValue();
                    }
                    if (subwidthValid && columnGroup.getWidth() != null && columnGroup.getWidth() != subwidth) {
                        verifier.addBrokenRule("Column group width " + columnGroup.getWidth() + " does not match sum of subcolumn widths " + subwidth, (Object)columnGroup);
                    }
                }
                return null;
            }
        };
        for (BaseColumn column : table.getColumns()) {
            column.visitColumn(columnVerifier);
        }
    }

    protected void verifyBaseColumn(TableComponent table, BaseColumn column, JRVerifier verifier) {
        Integer width = column.getWidth();
        if (width == null) {
            verifier.addBrokenRule("Column width not set", (Object)column);
        } else if (width < 0) {
            verifier.addBrokenRule("Negative column width", (Object)column);
        } else {
            this.verifyCell(column.getTableHeader(), width, "table header", verifier);
            this.verifyCell(column.getTableFooter(), width, "table footer", verifier);
            this.verifyGroupCells(table, column.getGroupHeaders(), width, "group header", verifier);
            this.verifyGroupCells(table, column.getGroupFooters(), width, "group footer", verifier);
            this.verifyCell(column.getColumnHeader(), width, "column header", verifier);
            this.verifyCell(column.getColumnFooter(), width, "column footer", verifier);
        }
    }

    protected void verifyGroupCells(TableComponent table, List<GroupCell> cells, int width, String cellName, JRVerifier verifier) {
        if (cells != null) {
            HashSet<String> groupNames = new HashSet<String>();
            for (GroupCell groupCell : cells) {
                String groupName = groupCell.getGroupName();
                if (groupName == null) {
                    verifier.addBrokenRule("No group name set for table column group cell", (Object)groupCell);
                } else {
                    JRDesignDataset dataset;
                    JRDatasetRun datasetRun;
                    if (!groupNames.add(groupName)) {
                        verifier.addBrokenRule("Duplicate " + cellName + " for group \"" + groupName + "\"", (Object)groupCell);
                    }
                    if ((datasetRun = table.getDatasetRun()) != null && (dataset = (JRDesignDataset)verifier.getReportDesign().getDatasetMap().get(datasetRun.getDatasetName())) != null && dataset.getGroupsMap().get(groupName) == null) {
                        verifier.addBrokenRule("No group named " + groupName + "\" found in subdataset " + datasetRun.getDatasetName(), (Object)groupCell);
                    }
                }
                this.verifyCell(groupCell.getCell(), width, cellName, verifier);
            }
        }
    }

    protected void verifyCell(Cell cell, int width, String cellName, JRVerifier verifier) {
        Integer height;
        if (cell == null) {
            return;
        }
        if (cell.getRowSpan() != null && cell.getRowSpan() < 1) {
            verifier.addBrokenRule("Negative or zero cell row span", (Object)cell);
        }
        if ((height = cell.getHeight()) == null) {
            verifier.addBrokenRule("Cell height not set", (Object)cell);
        } else if (height < 0) {
            verifier.addBrokenRule("Negative cell height", (Object)cell);
        } else {
            JRElement[] elements = cell.getElements();
            if (elements != null && elements.length > 0) {
                int topPadding = cell.getLineBox().getTopPadding();
                int leftPadding = cell.getLineBox().getLeftPadding();
                int bottomPadding = cell.getLineBox().getBottomPadding();
                int rightPadding = cell.getLineBox().getRightPadding();
                int avlblWidth = width - leftPadding - rightPadding;
                int avlblHeight = height - topPadding - bottomPadding;
                for (JRElement element : elements) {
                    verifier.verifyElement(element);
                    if (element.getX() < 0 || element.getY() < 0) {
                        verifier.addBrokenRule("Element must be placed at positive coordinates.", (Object)element);
                    }
                    if (element.getY() + element.getHeight() > avlblHeight) {
                        verifier.addBrokenRule("Element reaches outside table " + cellName + " contents height: y = " + element.getY() + ", height = " + element.getHeight() + ", cell available height = " + avlblHeight + ".", (Object)element);
                    }
                    if (element.getX() + element.getWidth() <= avlblWidth) continue;
                    verifier.addBrokenRule("Element reaches outside table " + cellName + " contents width: x = " + element.getX() + ", width = " + element.getWidth() + ", cell available width = " + avlblWidth + ".", (Object)element);
                }
            }
        }
    }

    protected void verifyColumn(TableComponent table, Column column, JRVerifier verifier) {
        this.verifyBaseColumn(table, column, verifier);
        if (column.getWidth() != null) {
            Cell detailCell = column.getDetailCell();
            this.verifyCell(detailCell, column.getWidth(), "detail", verifier);
        }
    }

    protected void verifyColumnHeights(TableComponent table, JRVerifier verifier) {
        JRGroup[] groups;
        JRDesignDataset dataset;
        this.verifyColumnHeights(table, verifier, new BaseColumnCellSelector(){

            protected Cell getCell(BaseColumn column) {
                return column.getTableHeader();
            }

            public String getCellName() {
                return "table header";
            }
        });
        this.verifyColumnHeights(table, verifier, new BaseColumnCellSelector(){

            protected Cell getCell(BaseColumn column) {
                return column.getTableFooter();
            }

            public String getCellName() {
                return "table footer";
            }
        });
        JRDatasetRun datasetRun = table.getDatasetRun();
        if (datasetRun != null && (dataset = (JRDesignDataset)verifier.getReportDesign().getDatasetMap().get(datasetRun.getDatasetName())) != null && (groups = dataset.getGroups()) != null) {
            for (int i = 0; i < groups.length; ++i) {
                final String groupName = groups[i].getName();
                this.verifyColumnHeights(table, verifier, new BaseColumnCellSelector(){

                    protected Cell getCell(BaseColumn column) {
                        return column.getGroupHeader(groupName);
                    }

                    public String getCellName() {
                        return "group " + groupName + " header";
                    }
                });
                this.verifyColumnHeights(table, verifier, new BaseColumnCellSelector(){

                    protected Cell getCell(BaseColumn column) {
                        return column.getGroupFooter(groupName);
                    }

                    public String getCellName() {
                        return "group " + groupName + " footer";
                    }
                });
            }
        }
        this.verifyColumnHeights(table, verifier, new BaseColumnCellSelector(){

            protected Cell getCell(BaseColumn column) {
                return column.getColumnHeader();
            }

            public String getCellName() {
                return "column header";
            }
        });
        this.verifyColumnHeights(table, verifier, new BaseColumnCellSelector(){

            protected Cell getCell(BaseColumn column) {
                return column.getColumnFooter();
            }

            public String getCellName() {
                return "column footer";
            }
        });
        this.verifyColumnHeights(table, verifier, new ColumnCellSelector(){

            public Cell getCell(Column column) {
                return column.getDetailCell();
            }

            public Cell getCell(ColumnGroup group) {
                return null;
            }

            public String getCellName() {
                return "detail";
            }
        });
    }

    protected void verifyColumnHeights(TableComponent table, JRVerifier verifier, final ColumnCellSelector cellSelector) {
        final ArrayList tableCellRows = new ArrayList();
        ColumnVisitor<Void> cellCollector = new ColumnVisitor<Void>(){
            int rowIdx = 0;

            protected List<Cell> getRow() {
                int currentRowCount = tableCellRows.size();
                if (this.rowIdx >= currentRowCount) {
                    for (int i = currentRowCount; i <= this.rowIdx; ++i) {
                        tableCellRows.add(new ArrayList());
                    }
                }
                return (List)tableCellRows.get(this.rowIdx);
            }

            @Override
            public Void visitColumn(Column column) {
                Cell cell = cellSelector.getCell(column);
                if (cell != null) {
                    this.getRow().add(cell);
                }
                return null;
            }

            @Override
            public Void visitColumnGroup(ColumnGroup columnGroup) {
                int span;
                Cell cell = cellSelector.getCell(columnGroup);
                if (cell != null) {
                    this.getRow().add(cell);
                }
                int n = span = cell == null ? 0 : 1;
                if (cell != null && cell.getRowSpan() != null && cell.getRowSpan() > 1) {
                    span = cell.getRowSpan();
                }
                this.rowIdx += span;
                for (BaseColumn subcolumn : columnGroup.getColumns()) {
                    subcolumn.visitColumn(this);
                }
                this.rowIdx -= span;
                return null;
            }
        };
        for (BaseColumn column : table.getColumns()) {
            column.visitColumn(cellCollector);
        }
        boolean validRowHeights = true;
        ArrayList<Integer> rowHeights = new ArrayList<Integer>(tableCellRows.size());
        for (int rowIdx = 0; rowIdx < tableCellRows.size(); ++rowIdx) {
            Integer rowHeight = null;
            int spanHeight = 0;
            block2: for (int idx = rowIdx; idx >= 0; --idx) {
                for (Cell cell : (List)tableCellRows.get(idx)) {
                    int rowSpan = cell.getRowSpan() == null ? 1 : cell.getRowSpan();
                    if (idx + rowSpan - 1 != rowIdx || cell.getHeight() == null) continue;
                    rowHeight = cell.getHeight() - spanHeight;
                    break block2;
                }
                if (rowIdx <= 0) continue;
                spanHeight += ((Integer)rowHeights.get(rowIdx - 1)).intValue();
            }
            if (rowHeight == null) {
                verifier.addBrokenRule("Unable to determine " + cellSelector.getCellName() + " row #" + (rowIdx + 1) + " height.", (Object)table);
                validRowHeights = false;
                continue;
            }
            rowHeights.add(rowHeight);
        }
        if (validRowHeights) {
            ListIterator rowIt = tableCellRows.listIterator();
            while (rowIt.hasNext()) {
                List row = (List)rowIt.next();
                int rowIdx = rowIt.previousIndex();
                int rowHeight = (Integer)rowHeights.get(rowIdx);
                for (Cell cell : row) {
                    int span;
                    Integer rowSpan = cell.getRowSpan();
                    Integer height = cell.getHeight();
                    if (rowSpan != null && rowSpan < 1 || height == null) continue;
                    int n = span = rowSpan == null ? 1 : rowSpan;
                    if (rowIdx + span > tableCellRows.size()) {
                        verifier.addBrokenRule("Row span of " + cellSelector.getCellName() + " exceeds number of rows", (Object)cell);
                        continue;
                    }
                    int spanHeight = rowHeight;
                    for (int idx = 1; idx < span; ++idx) {
                        spanHeight += ((Integer)rowHeights.get(rowIdx + idx)).intValue();
                    }
                    if (cell.getHeight() == spanHeight) continue;
                    verifier.addBrokenRule("Height " + cell.getHeight() + " of " + cellSelector.getCellName() + " does not match computed row height of " + spanHeight, (Object)cell);
                }
            }
        }
    }

    protected abstract class BaseColumnCellSelector
    implements ColumnCellSelector {
        protected BaseColumnCellSelector() {
        }

        public Cell getCell(Column column) {
            return this.getCell((BaseColumn)column);
        }

        public Cell getCell(ColumnGroup group) {
            return this.getCell((BaseColumn)group);
        }

        protected abstract Cell getCell(BaseColumn var1);
    }

    protected static interface ColumnCellSelector {
        public Cell getCell(Column var1);

        public Cell getCell(ColumnGroup var1);

        public String getCellName();
    }
}

