/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.platform.base;

import java.util.ArrayList;
import java.util.List;

import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;

/**
 * MosPプラットフォームにおける画面の基本情報を格納する。<br>
 */
public class PlatformVo extends BaseVo {
	
	private static final long					serialVersionUID	= -8491195829751058929L;
	
	/**
	 * 編集モード。<br>
	 */
	private String								modeCardEdit;
	
	/**
	 * 有効日モード。<br>
	 */
	private String								modeActivateDate;
	
	/**
	 * ページ繰りコマンド。<br>
	 * 一覧表示時に用いる。<br>
	 */
	private String								pageCommand;
	
	/**
	 * 選択ページ番号。<br>
	 * 一覧表示時に用いる。<br>
	 */
	private String								selectIndex;
	
	/**
	 * 1ページ当たりの表示件数。<br>
	 * 一覧表示時に用いる。<br>
	 */
	private int									dataPerPage;
	
	/**
	 * 昇順降順フラグ。<br>
	 * 一覧表示時に用いる。<br>
	 */
	private boolean								isAscending;
	
	/**
	 * ソート用比較クラス名。<br>
	 * 一覧表示時に用いる。<br>
	 */
	private String								comparatorName;
	
	/**
	 * リスト。<br>
	 * 一覧表示時に用いる。<br>
	 */
	private List<? extends BaseDtoInterface>	list;
	

	/**
	 * VOの初期設定を行う。<br>
	 * <br>
	 */
	public PlatformVo() {
		// 一覧表示用リスト初期化
		list = new ArrayList<PlatformDtoInterface>();
	}
	
	/**
	 * @return modeCardEdit
	 */
	public String getModeCardEdit() {
		return modeCardEdit;
	}
	
	/**
	 * @param modeCardEdit セットする modeCardEdit
	 */
	public void setModeCardEdit(String modeCardEdit) {
		this.modeCardEdit = modeCardEdit;
	}
	
	/**
	 * @return modeActivateDate
	 */
	public String getModeActivateDate() {
		return modeActivateDate;
	}
	
	/**
	 * @param modeActivateDate セットする modeActivateDate
	 */
	public void setModeActivateDate(String modeActivateDate) {
		this.modeActivateDate = modeActivateDate;
	}
	
	/**
	 * @return pageCommand
	 */
	public String getPageCommand() {
		return pageCommand;
	}
	
	/**
	 * @param pageCommand セットする pageCommand
	 */
	public void setPageCommand(String pageCommand) {
		this.pageCommand = pageCommand;
	}
	
	/**
	 * @return selectIndex
	 */
	public String getSelectIndex() {
		return selectIndex;
	}
	
	/**
	 * @param selectIndex セットする selectIndex
	 */
	public void setSelectIndex(String selectIndex) {
		this.selectIndex = selectIndex;
	}
	
	/**
	 * @return dataPerPage
	 */
	public int getDataPerPage() {
		return dataPerPage;
	}
	
	/**
	 * @param dataPerPage セットする dataPerPage
	 */
	public void setDataPerPage(int dataPerPage) {
		this.dataPerPage = dataPerPage;
	}
	
	/**
	 * @return isAscending
	 */
	public boolean isAscending() {
		return isAscending;
	}
	
	/**
	 * @param isAscending セットする isAscending
	 */
	public void setAscending(boolean isAscending) {
		this.isAscending = isAscending;
	}
	
	/**
	 * @return comparatorName
	 */
	public String getComparatorName() {
		return comparatorName;
	}
	
	/**
	 * @param comparatorName セットする comparatorName
	 */
	public void setComparatorName(String comparatorName) {
		this.comparatorName = comparatorName;
	}
	
	/**
	 * @return list
	 */
	public List<? extends BaseDtoInterface> getList() {
		return list;
	}
	
	/**
	 * @param list セットする list
	 */
	public void setList(List<? extends BaseDtoInterface> list) {
		this.list = list;
	}
	
}
