/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util;

import java.util.Date;

public class WindowsDate
extends Date
implements Cloneable {
    public static final long TIME_DIFFERENCE = 116444736000000000L;
    private int NanoSecounds;

    public WindowsDate() {
        this.NanoSecounds = 0;
        this.checkRange();
    }

    public WindowsDate(Date date) {
        super(date.getTime());
        if (date instanceof WindowsDate) {
            this.NanoSecounds = ((WindowsDate)date).NanoSecounds;
        } else {
            this.NanoSecounds = 0;
            this.checkRange();
        }
    }

    public WindowsDate(long time) {
        super(0L <= time ? (time - 116444736000000000L) / 10000L : ((time >>> 1) - 58222368000000000L) / 5000L);
        this.NanoSecounds = (int)((time >>> 1) % 5000L * 2L + (time & 1L)) * 100;
    }

    public Object clone() {
        return new WindowsDate(this);
    }

    public void setYear(int year) {
        long temp = this.getTime();
        try {
            super.setYear(year);
            this.checkRange();
        }
        catch (IllegalArgumentException exception) {
            this.setTime(temp);
            throw exception;
        }
    }

    public void setMonth(int month) {
        long temp = this.getTime();
        try {
            super.setMonth(month);
            this.checkRange();
        }
        catch (IllegalArgumentException exception) {
            this.setTime(temp);
            throw exception;
        }
    }

    public void setDate(int date) {
        long temp = this.getTime();
        try {
            super.setDate(date);
            this.checkRange();
        }
        catch (IllegalArgumentException exception) {
            this.setTime(temp);
            throw exception;
        }
    }

    public void setHours(int hours) {
        long temp = this.getTime();
        try {
            super.setHours(hours);
            this.checkRange();
        }
        catch (IllegalArgumentException exception) {
            this.setTime(temp);
            throw exception;
        }
    }

    public void setMinutes(int minutes) {
        long temp = this.getTime();
        try {
            super.setMinutes(minutes);
            this.checkRange();
        }
        catch (IllegalArgumentException exception) {
            this.setTime(temp);
            throw exception;
        }
    }

    public void setSeconds(int seconds) {
        long temp = this.getTime();
        try {
            super.setSeconds(seconds);
            this.checkRange();
        }
        catch (IllegalArgumentException exception) {
            this.setTime(temp);
            throw exception;
        }
    }

    public void setTime(long time) {
        long temp = this.getTime();
        try {
            super.setTime(time);
            this.checkRange();
        }
        catch (IllegalArgumentException exception) {
            this.setTime(temp);
            throw exception;
        }
    }

    public void setWindowsTime(long time) {
        super.setTime(0L <= time ? (time - 116444736000000000L) / 10000L : ((time >>> 1) - 58222368000000000L) / 5000L);
        this.NanoSecounds = (int)((time >>> 1) % 5000L * 2L + (time & 1L)) * 100;
    }

    public long getWindowsTime() {
        return super.getTime() * 10000L + 116444736000000000L + (long)(this.NanoSecounds / 100);
    }

    private void checkRange() {
        long time = super.getTime();
        if (-933981677285477L > time || time > 1833029933770955L) {
            throw new IllegalArgumentException("outside of range of Windows FILETIME format. ");
        }
    }
}

