/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.platform.human.constant;

/**
 * MosPプラットフォーム人事管理機能で用いる定数を宣言する。<br>
 */
public class PlatformHumanConst {
	
	/**
	 * 他クラスからのインスタンス化を防止する。<br>
	 */
	private PlatformHumanConst() {
		// 処理無し
	}
	

	/**
	 * ファイルパス(MosPプラットフォーム人事管理共通JSP)。
	 */
	public static final String	PATH_HUMAN_COMMON_INFO_JSP		= "/jsp/platform/human/humanCommonInfo.jsp";
	
	/**
	 * 人事管理共通情報表示モード(全て表示)。
	 */
	public static final String	MODE_HUMAN_SHOW_ALL				= "all";
	
	/**
	 * 人事管理共通情報表示モード(社員コード、氏名のみ表示)。
	 */
	public static final String	MODE_HUMAN_CODE_AND_NAME		= "codeAndName";
	
	/**
	 * 人事管理共通情報表示モード(再表示なし)。
	 */
	public static final String	MODE_HUMAN_NO_ACTIVATE_DATE		= "noActiveDate";
	
	/**
	 * パラメータID(譲渡社員コード)。
	 */
	public static final String	PRM_TRANSFERRED_EMPLOYEE_CODE	= "transferredEmployeeCode";
	
	/**
	 * パラメータID(譲渡有効日)。
	 */
	public static final String	PRM_TRANSFERRED_ACTIVATE_DATE	= "transferredActivateDate";
	
}
