CREATE TABLE pfa_human_concurrent
(
  pfa_human_concurrent_id bigint NOT NULL DEFAULT 0, 
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying, 
  start_date date NOT NULL, 
  end_date date, 
  section_code character varying(10) NOT NULL DEFAULT ''::character varying, 
  position_code character varying(10) NOT NULL DEFAULT ''::character varying, 
  concurrent_remark text NOT NULL DEFAULT ''::text,
  delete_flag integer NOT NULL DEFAULT 0, 
  insert_date timestamp without time zone NOT NULL, 
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying,
  update_date timestamp without time zone NOT NULL,
  update_user character varying(50) NOT NULL DEFAULT ''::character varying,
  CONSTRAINT pft_human_concurrent_pkey PRIMARY KEY (pfa_human_concurrent_id)
);
COMMENT ON TABLE pfa_human_concurrent IS '人事兼務情報';
COMMENT ON COLUMN pfa_human_concurrent.pfa_human_concurrent_id IS 'レコード識別ID';
COMMENT ON COLUMN pfa_human_concurrent.personal_id IS '個人ID';
COMMENT ON COLUMN pfa_human_concurrent.start_date IS '開始日';
COMMENT ON COLUMN pfa_human_concurrent.end_date IS '終了日';
COMMENT ON COLUMN pfa_human_concurrent.section_code IS '所属コード';
COMMENT ON COLUMN pfa_human_concurrent.position_code IS '職位コード';
COMMENT ON COLUMN pfa_human_concurrent.concurrent_remark IS '備考';
COMMENT ON COLUMN pfa_human_concurrent.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pfa_human_concurrent.insert_date IS '登録日';
COMMENT ON COLUMN pfa_human_concurrent.insert_user IS '登録者';
COMMENT ON COLUMN pfa_human_concurrent.update_date IS '更新日';
COMMENT ON COLUMN pfa_human_concurrent.update_user IS '更新者';



CREATE TABLE pfa_human_entrance
(
  pfa_human_entrance_id bigint NOT NULL DEFAULT 0, 
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying,
  entrance_date date NOT NULL, 
  delete_flag integer NOT NULL DEFAULT 0, 
  insert_date timestamp without time zone NOT NULL, 
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, 
  update_date timestamp without time zone NOT NULL, 
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, 
  CONSTRAINT pft_human_entrance_pkey PRIMARY KEY (pfa_human_entrance_id)
)
;
COMMENT ON TABLE pfa_human_entrance IS '人事入社情報';
COMMENT ON COLUMN pfa_human_entrance.pfa_human_entrance_id IS 'レコード識別ID';
COMMENT ON COLUMN pfa_human_entrance.personal_id IS '個人ID';
COMMENT ON COLUMN pfa_human_entrance.entrance_date IS '入社日';
COMMENT ON COLUMN pfa_human_entrance.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pfa_human_entrance.insert_date IS '登録日';
COMMENT ON COLUMN pfa_human_entrance.insert_user IS '登録者';
COMMENT ON COLUMN pfa_human_entrance.update_date IS '更新日';
COMMENT ON COLUMN pfa_human_entrance.update_user IS '更新者';


CREATE TABLE pfa_human_retirement
(
  pfa_human_retirement_id bigint NOT NULL DEFAULT 0, 
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying, 
  retirement_date date NOT NULL, 
  retirement_reason character varying(10) NOT NULL DEFAULT ''::character varying,
  retirement_detail text NOT NULL DEFAULT ''::text, 
  delete_flag integer NOT NULL DEFAULT 0, 
  insert_date timestamp without time zone NOT NULL, 
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying,
  update_date timestamp without time zone NOT NULL, 
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, 
  CONSTRAINT pft_human_retirement_pkey PRIMARY KEY (pfa_human_retirement_id)
)
;
COMMENT ON TABLE pfa_human_retirement IS '人事退職情報';
COMMENT ON COLUMN pfa_human_retirement.pfa_human_retirement_id IS 'レコード識別ID';
COMMENT ON COLUMN pfa_human_retirement.personal_id IS '個人ID';
COMMENT ON COLUMN pfa_human_retirement.retirement_date IS '退職日';
COMMENT ON COLUMN pfa_human_retirement.retirement_reason IS '退職理由';
COMMENT ON COLUMN pfa_human_retirement.retirement_detail IS '詳細';
COMMENT ON COLUMN pfa_human_retirement.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pfa_human_retirement.insert_date IS '登録日';
COMMENT ON COLUMN pfa_human_retirement.insert_user IS '登録者';
COMMENT ON COLUMN pfa_human_retirement.update_date IS '更新日';
COMMENT ON COLUMN pfa_human_retirement.update_user IS '更新者';


CREATE TABLE pfa_human_suspension
(
  pfa_human_suspension_id bigint NOT NULL DEFAULT 0,
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying, 
  start_date date NOT NULL, 
  end_date date, 
  schedule_end_date date NOT NULL, 
  allowance_type character varying(10) NOT NULL DEFAULT ''::character varying, 
  suspension_reason text NOT NULL DEFAULT ''::text, 
  delete_flag integer NOT NULL DEFAULT 0,
  insert_date timestamp without time zone NOT NULL, 
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, 
  update_date timestamp without time zone NOT NULL, 
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, 
  CONSTRAINT pft_human_suspension_pkey PRIMARY KEY (pfa_human_suspension_id)
)
;
COMMENT ON TABLE pfa_human_suspension IS '人事休職情報';
COMMENT ON COLUMN pfa_human_suspension.pfa_human_suspension_id IS 'レコード識別ID';
COMMENT ON COLUMN pfa_human_suspension.personal_id IS '個人ID';
COMMENT ON COLUMN pfa_human_suspension.start_date IS '開始日';
COMMENT ON COLUMN pfa_human_suspension.end_date IS '終了日';
COMMENT ON COLUMN pfa_human_suspension.schedule_end_date IS '終了予定日';
COMMENT ON COLUMN pfa_human_suspension.allowance_type IS '給与区分';
COMMENT ON COLUMN pfa_human_suspension.suspension_reason IS '理由';
COMMENT ON COLUMN pfa_human_suspension.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pfa_human_suspension.insert_date IS '登録日';
COMMENT ON COLUMN pfa_human_suspension.insert_user IS '登録者';
COMMENT ON COLUMN pfa_human_suspension.update_date IS '更新日';
COMMENT ON COLUMN pfa_human_suspension.update_user IS '更新者';



CREATE TABLE pfa_user_password
(
  pfa_user_password_id bigint NOT NULL DEFAULT 0, 
  user_id character varying(50) NOT NULL DEFAULT ''::character varying, 
  change_date date NOT NULL, 
  "password" character varying(50) NOT NULL DEFAULT ''::character varying, 
  delete_flag integer NOT NULL DEFAULT 0, 
  insert_date timestamp without time zone NOT NULL, 
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, 
  update_date timestamp without time zone NOT NULL, 
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, 
  CONSTRAINT pft_password_pkey PRIMARY KEY (pfa_user_password_id)
)
;
COMMENT ON TABLE pfa_user_password IS 'ユーザパスワード情報';
COMMENT ON COLUMN pfa_user_password.pfa_user_password_id IS 'レコード識別ID';
COMMENT ON COLUMN pfa_user_password.user_id IS 'ユーザID';
COMMENT ON COLUMN pfa_user_password.change_date IS '変更日';
COMMENT ON COLUMN pfa_user_password."password" IS 'パスワード';
COMMENT ON COLUMN pfa_user_password.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pfa_user_password.insert_date IS '登録日';
COMMENT ON COLUMN pfa_user_password.insert_user IS '登録者';
COMMENT ON COLUMN pfa_user_password.update_date IS '更新日';
COMMENT ON COLUMN pfa_user_password.update_user IS '更新者';



CREATE TABLE pfg_genaral
(
  pfg_genaral_id bigint NOT NULL DEFAULT 0,
  general_type character varying(255) NOT NULL DEFAULT ''::character varying,
  general_code character varying(255) NOT NULL DEFAULT ''::character varying,
  general_date date,
  general_char1 character varying(255) DEFAULT ''::character varying,
  general_char2 character varying(255) DEFAULT ''::character varying,
  general_numeric double precision NOT NULL DEFAULT 0,
  general_time timestamp without time zone,
  general_binary bytea,
  delete_flag integer NOT NULL DEFAULT 0,
  insert_date timestamp without time zone NOT NULL,
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying,
  update_date timestamp without time zone NOT NULL,
  update_user character varying(50) NOT NULL DEFAULT ''::character varying,
  CONSTRAINT pfg_genaral_pkey PRIMARY KEY (pfg_genaral_id)
)
;
COMMENT ON TABLE pfg_genaral IS 'MosP汎用テーブル';
COMMENT ON COLUMN pfg_genaral.pfg_genaral_id IS 'レコード識別ID';
COMMENT ON COLUMN pfg_genaral.general_type IS '汎用区分';
COMMENT ON COLUMN pfg_genaral.general_code IS '汎用コード';
COMMENT ON COLUMN pfg_genaral.general_date IS '汎用日付';
COMMENT ON COLUMN pfg_genaral.general_char1 IS '汎用文字列1';
COMMENT ON COLUMN pfg_genaral.general_char2 IS '汎用文字列2';
COMMENT ON COLUMN pfg_genaral.general_numeric IS '汎用数値';
COMMENT ON COLUMN pfg_genaral.general_time IS '汎用日時';
COMMENT ON COLUMN pfg_genaral.general_binary IS '汎用バイナリ';
COMMENT ON COLUMN pfg_genaral.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pfg_genaral.insert_date IS '登録日';
COMMENT ON COLUMN pfg_genaral.insert_user IS '登録者';
COMMENT ON COLUMN pfg_genaral.update_date IS '更新日';
COMMENT ON COLUMN pfg_genaral.update_user IS '更新者';



CREATE TABLE pfm_employment_contract
(
  pfm_employment_contract_id bigint NOT NULL DEFAULT 0, 
  employment_contract_code character varying(10) NOT NULL DEFAULT ''::character varying, 
  activate_date date NOT NULL, 
  employment_contract_name character varying(50) NOT NULL DEFAULT ''::character varying, 
  employment_contract_abbr character varying(5) NOT NULL DEFAULT ''::character varying, 
  inactivate_flag integer NOT NULL DEFAULT 0,
  delete_flag integer NOT NULL DEFAULT 0, 
  insert_date timestamp without time zone NOT NULL, 
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying,
  update_date timestamp without time zone NOT NULL, 
  update_user character varying(50) NOT NULL DEFAULT ''::character varying,
  CONSTRAINT pfm_employment_contract_pkey PRIMARY KEY (pfm_employment_contract_id)
)
;
COMMENT ON TABLE pfm_employment_contract IS '雇用契約マスタ';
COMMENT ON COLUMN pfm_employment_contract.pfm_employment_contract_id IS 'レコード識別ID';
COMMENT ON COLUMN pfm_employment_contract.employment_contract_code IS '雇用契約コード';
COMMENT ON COLUMN pfm_employment_contract.activate_date IS '有効日';
COMMENT ON COLUMN pfm_employment_contract.employment_contract_name IS '雇用契約名称';
COMMENT ON COLUMN pfm_employment_contract.employment_contract_abbr IS '雇用契約略称';
COMMENT ON COLUMN pfm_employment_contract.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN pfm_employment_contract.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pfm_employment_contract.insert_date IS '登録日';
COMMENT ON COLUMN pfm_employment_contract.insert_user IS '登録者';
COMMENT ON COLUMN pfm_employment_contract.update_date IS '更新日';
COMMENT ON COLUMN pfm_employment_contract.update_user IS '更新者';


CREATE TABLE pfm_human
(
  pfm_human_id bigint NOT NULL DEFAULT 0, 
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying, 
  activate_date date NOT NULL,
  employee_code character varying(10) NOT NULL DEFAULT ''::character varying, 
  last_name character varying(50) NOT NULL DEFAULT ''::character varying,
  first_name character varying(50) NOT NULL DEFAULT ''::character varying, 
  last_kana character varying(50) NOT NULL DEFAULT ''::character varying,
  first_kana character varying(50) NOT NULL DEFAULT ''::character varying, 
  employment_contract_code character varying(10) NOT NULL DEFAULT ''::character varying, 
  section_code character varying(10) NOT NULL DEFAULT ''::character varying,
  position_code character varying(10) NOT NULL DEFAULT ''::character varying,
  work_place_code character varying(10) NOT NULL DEFAULT ''::character varying, 
  mail character varying(50) NOT NULL DEFAULT ''::character varying, 
  delete_flag integer NOT NULL DEFAULT 0, 
  insert_date timestamp without time zone NOT NULL, 
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying,
  update_date timestamp without time zone NOT NULL, 
  update_user character varying(50) NOT NULL DEFAULT ''::character varying,
  CONSTRAINT pfm_human_basis_pkey PRIMARY KEY (pfm_human_id)
)
;
COMMENT ON TABLE pfm_human IS '人事マスタ';
COMMENT ON COLUMN pfm_human.pfm_human_id IS 'レコード識別ID';
COMMENT ON COLUMN pfm_human.personal_id IS '個人ID';
COMMENT ON COLUMN pfm_human.activate_date IS '有効日';
COMMENT ON COLUMN pfm_human.employee_code IS '社員コード';
COMMENT ON COLUMN pfm_human.last_name IS '姓';
COMMENT ON COLUMN pfm_human.first_name IS '名';
COMMENT ON COLUMN pfm_human.last_kana IS 'カナ姓';
COMMENT ON COLUMN pfm_human.first_kana IS 'カナ名';
COMMENT ON COLUMN pfm_human.employment_contract_code IS '雇用契約コード';
COMMENT ON COLUMN pfm_human.section_code IS '所属コード';
COMMENT ON COLUMN pfm_human.position_code IS '職位コード';
COMMENT ON COLUMN pfm_human.work_place_code IS '勤務地コード';
COMMENT ON COLUMN pfm_human.mail IS 'メールアドレス';
COMMENT ON COLUMN pfm_human.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pfm_human.insert_date IS '登録日';
COMMENT ON COLUMN pfm_human.insert_user IS '登録者';
COMMENT ON COLUMN pfm_human.update_date IS '更新日';
COMMENT ON COLUMN pfm_human.update_user IS '更新者';



CREATE TABLE pfm_position
(
  pfm_position_id bigint NOT NULL DEFAULT 0, 
  position_code character varying(10) NOT NULL DEFAULT ''::character varying, 
  activate_date date NOT NULL,  
  position_name character varying(50) NOT NULL DEFAULT ''::character varying, 
  position_abbr character varying(5) NOT NULL DEFAULT ''::character varying, 
  position_grade integer NOT NULL DEFAULT 0, 
  position_level integer NOT NULL DEFAULT 0, 
  inactivate_flag integer NOT NULL DEFAULT 0, 
  delete_flag integer NOT NULL DEFAULT 0, 
  insert_date timestamp without time zone NOT NULL, 
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, 
  update_date timestamp without time zone NOT NULL,
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, 
  CONSTRAINT pfm_position_pkey PRIMARY KEY (pfm_position_id)
)
;
COMMENT ON TABLE pfm_position IS '職位マスタ';
COMMENT ON COLUMN pfm_position.pfm_position_id IS 'レコード識別ID';
COMMENT ON COLUMN pfm_position.position_code IS '職位コード';
COMMENT ON COLUMN pfm_position.activate_date IS '有効日';
COMMENT ON COLUMN pfm_position.position_name IS '職位名称';
COMMENT ON COLUMN pfm_position.position_abbr IS '職位略称';
COMMENT ON COLUMN pfm_position.position_grade IS '等級';
COMMENT ON COLUMN pfm_position.position_level IS '号数';
COMMENT ON COLUMN pfm_position.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN pfm_position.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pfm_position.insert_date IS '登録日';
COMMENT ON COLUMN pfm_position.insert_user IS '登録者';
COMMENT ON COLUMN pfm_position.update_date IS '更新日';
COMMENT ON COLUMN pfm_position.update_user IS '更新者';


CREATE TABLE pfm_section
(
  pfm_section_id bigint NOT NULL DEFAULT 0, 
  section_code character varying(10) NOT NULL DEFAULT ''::character varying, 
  activate_date date NOT NULL, 
  section_name character varying(50) NOT NULL DEFAULT ''::character varying, 
  section_abbr character varying(5) NOT NULL DEFAULT ''::character varying, 
  section_display character varying(50) NOT NULL DEFAULT ''::character varying, 
  class_route text NOT NULL DEFAULT ''::text, 
  close_flag integer NOT NULL DEFAULT 0, 
  delete_flag integer NOT NULL DEFAULT 0, 
  insert_date timestamp without time zone NOT NULL, 
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, 
  update_date timestamp without time zone NOT NULL, 
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, 
  CONSTRAINT pfm_section_pkey PRIMARY KEY (pfm_section_id)
)
;
COMMENT ON TABLE pfm_section IS '所属マスタ';
COMMENT ON COLUMN pfm_section.pfm_section_id IS 'レコード識別ID';
COMMENT ON COLUMN pfm_section.section_code IS '所属コード';
COMMENT ON COLUMN pfm_section.activate_date IS '有効日';
COMMENT ON COLUMN pfm_section.section_name IS '所属名称';
COMMENT ON COLUMN pfm_section.section_abbr IS '所属略称';
COMMENT ON COLUMN pfm_section.section_display IS '所属表示名称';
COMMENT ON COLUMN pfm_section.class_route IS '階層経路';
COMMENT ON COLUMN pfm_section.close_flag IS '閉鎖フラグ';
COMMENT ON COLUMN pfm_section.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pfm_section.insert_date IS '登録日';
COMMENT ON COLUMN pfm_section.insert_user IS '登録者';
COMMENT ON COLUMN pfm_section.update_date IS '更新日';
COMMENT ON COLUMN pfm_section.update_user IS '更新者';


CREATE TABLE pfm_user
(
  pfm_user_id bigint NOT NULL DEFAULT 0, 
  user_id character varying(50) NOT NULL DEFAULT ''::character varying, 
  activate_date date NOT NULL, 
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying,
  role_code character varying(50) NOT NULL DEFAULT ''::character varying, 
  inactivate_flag integer NOT NULL DEFAULT 0,
  delete_flag integer NOT NULL DEFAULT 0, 
  insert_date timestamp without time zone NOT NULL, 
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, 
  update_date timestamp without time zone NOT NULL, 
  update_user character varying(50) NOT NULL DEFAULT ''::character varying,
  CONSTRAINT pfm_user_pkey PRIMARY KEY (pfm_user_id)
)
;
COMMENT ON TABLE pfm_user IS 'ユーザマスタ';
COMMENT ON COLUMN pfm_user.pfm_user_id IS 'レコード識別ID';
COMMENT ON COLUMN pfm_user.user_id IS 'ユーザID';
COMMENT ON COLUMN pfm_user.activate_date IS '有効日';
COMMENT ON COLUMN pfm_user.personal_id IS '個人ID';
COMMENT ON COLUMN pfm_user.role_code IS 'ロールコード';
COMMENT ON COLUMN pfm_user.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN pfm_user.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pfm_user.insert_date IS '登録日';
COMMENT ON COLUMN pfm_user.insert_user IS '登録者';
COMMENT ON COLUMN pfm_user.update_date IS '更新日';
COMMENT ON COLUMN pfm_user.update_user IS '更新者';



CREATE TABLE pfm_work_place
(
  pfm_work_place_id bigint NOT NULL DEFAULT 0,
  work_place_code character varying(10) NOT NULL DEFAULT ''::character varying, 
  activate_date date NOT NULL,  
  work_place_name character varying(50) NOT NULL DEFAULT ''::character varying, 
  work_place_kana character varying(50) NOT NULL DEFAULT ''::character varying,   work_place_abbr character varying(5) NOT NULL DEFAULT ''::character varying,    prefecture character varying(10) NOT NULL DEFAULT ''::character varying, 
  address_1 character varying(50) NOT NULL DEFAULT ''::character varying, 
  address_2 character varying(50) NOT NULL DEFAULT ''::character varying, 
  address_3 character varying(50) NOT NULL DEFAULT ''::character varying, 
  postal_code_1 character varying(3) NOT NULL DEFAULT ''::character varying, 
  postal_code_2 character varying(4) NOT NULL DEFAULT ''::character varying, 
  phone_number_1 character varying(5) NOT NULL DEFAULT ''::character varying, 
  phone_number_2 character varying(4) NOT NULL DEFAULT ''::character varying, 
  phone_number_3 character varying(4) NOT NULL DEFAULT ''::character varying, 
  inactivate_flag integer NOT NULL DEFAULT 0, 
  delete_flag integer NOT NULL DEFAULT 0, 
  insert_date timestamp without time zone NOT NULL, 
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, 
  update_date timestamp without time zone NOT NULL, 
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, 
  CONSTRAINT pfm_work_place_pkey PRIMARY KEY (pfm_work_place_id)
)
;
COMMENT ON TABLE pfm_work_place IS '勤務地マスタ';
COMMENT ON COLUMN pfm_work_place.pfm_work_place_id IS 'レコード識別ID';
COMMENT ON COLUMN pfm_work_place.work_place_code IS '勤務地コード';
COMMENT ON COLUMN pfm_work_place.activate_date IS '有効日';
COMMENT ON COLUMN pfm_work_place.work_place_name IS '勤務地名称';
COMMENT ON COLUMN pfm_work_place.work_place_kana IS '勤務地カナ';
COMMENT ON COLUMN pfm_work_place.work_place_abbr IS '勤務地略称';
COMMENT ON COLUMN pfm_work_place.prefecture IS '勤務地都道府県';
COMMENT ON COLUMN pfm_work_place.address_1 IS '勤務地市区町村';
COMMENT ON COLUMN pfm_work_place.address_2 IS '勤務地番地';
COMMENT ON COLUMN pfm_work_place.address_3 IS '勤務地建物情報';
COMMENT ON COLUMN pfm_work_place.postal_code_1 IS '勤務地郵便番号1';
COMMENT ON COLUMN pfm_work_place.postal_code_2 IS '勤務地郵便番号2';
COMMENT ON COLUMN pfm_work_place.phone_number_1 IS '勤務地電話番号1';
COMMENT ON COLUMN pfm_work_place.phone_number_2 IS '勤務地電話番号2';
COMMENT ON COLUMN pfm_work_place.phone_number_3 IS '勤務地電話番号3';
COMMENT ON COLUMN pfm_work_place.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN pfm_work_place.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pfm_work_place.insert_date IS '登録日';
COMMENT ON COLUMN pfm_work_place.insert_user IS '登録者';
COMMENT ON COLUMN pfm_work_place.update_date IS '更新日';
COMMENT ON COLUMN pfm_work_place.update_user IS '更新者';



CREATE TABLE pft_workflow
(
  pft_workflow_id bigint NOT NULL DEFAULT 0,
  workflow bigint NOT NULL DEFAULT 0,
  workflow_stage integer NOT NULL DEFAULT 0,
  workflow_status character varying(10) NOT NULL DEFAULT ''::character varying,
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying,
  workflow_date date NOT NULL,
  route_code character varying(10) NOT NULL DEFAULT ''::character varying,
  function_code character varying(10) NOT NULL DEFAULT ''::character varying,
  approver_id text NOT NULL DEFAULT ''::text,
  delete_flag integer NOT NULL DEFAULT 0,
  insert_date timestamp without time zone NOT NULL,
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying,
  update_date timestamp without time zone NOT NULL,
  update_user character varying(50) NOT NULL DEFAULT ''::character varying,
  CONSTRAINT pft_workflow_pkey PRIMARY KEY (pft_workflow_id)
)
;
COMMENT ON TABLE pft_workflow IS 'ワークフロー';
COMMENT ON COLUMN pft_workflow.pft_workflow_id IS 'レコード識別ID';
COMMENT ON COLUMN pft_workflow.workflow IS 'ワークフロー番号';
COMMENT ON COLUMN pft_workflow.workflow_stage IS '段階';
COMMENT ON COLUMN pft_workflow.workflow_status IS '状況';
COMMENT ON COLUMN pft_workflow.personal_id IS '申請者個人ID';
COMMENT ON COLUMN pft_workflow.workflow_date IS 'ワークフロー対象日';
COMMENT ON COLUMN pft_workflow.route_code IS 'ルートコード';
COMMENT ON COLUMN pft_workflow.function_code IS '機能コード';
COMMENT ON COLUMN pft_workflow.approver_id IS '承認者個人ID';
COMMENT ON COLUMN pft_workflow.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pft_workflow.insert_date IS '登録日';
COMMENT ON COLUMN pft_workflow.insert_user IS '登録者';
COMMENT ON COLUMN pft_workflow.update_date IS '更新日';
COMMENT ON COLUMN pft_workflow.update_user IS '更新者';



CREATE TABLE pft_workflow_comment
(
  pft_workflow_comment_id bigint NOT NULL DEFAULT 0, 
  workflow bigint NOT NULL DEFAULT 0,
  workflow_stage integer NOT NULL DEFAULT 0, 
  workflow_status character varying(10) NOT NULL DEFAULT ''::character varying, 
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying, 
  workflow_comment character varying(50) NOT NULL DEFAULT ''::character varying,
  workflow_date timestamp without time zone NOT NULL,
  delete_flag integer NOT NULL DEFAULT 0, 
  insert_date timestamp without time zone NOT NULL, 
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, 
  update_date timestamp without time zone NOT NULL, 
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, 
  CONSTRAINT pft_workflow_comment_pkey PRIMARY KEY (pft_workflow_comment_id)
)
;
COMMENT ON TABLE pft_workflow_comment IS 'ワークフローコメント';
COMMENT ON COLUMN pft_workflow_comment.pft_workflow_comment_id IS 'レコード識別ID';
COMMENT ON COLUMN pft_workflow_comment.workflow IS 'ワークフロー番号';
COMMENT ON COLUMN pft_workflow_comment.workflow_stage IS '段階';
COMMENT ON COLUMN pft_workflow_comment.workflow_status IS '状況';
COMMENT ON COLUMN pft_workflow_comment.personal_id IS '個人ID';
COMMENT ON COLUMN pft_workflow_comment.workflow_comment IS 'コメント';
COMMENT ON COLUMN pft_workflow_comment.workflow_date IS '日時';
COMMENT ON COLUMN pft_workflow_comment.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pft_workflow_comment.insert_date IS '登録日';
COMMENT ON COLUMN pft_workflow_comment.insert_user IS '登録者';
COMMENT ON COLUMN pft_workflow_comment.update_date IS '更新日';
COMMENT ON COLUMN pft_workflow_comment.update_user IS '更新者';



CREATE TABLE pfm_approval_unit
(
  pfm_approval_unit_id bigint NOT NULL DEFAULT 0, 
  unit_code character varying(10) NOT NULL DEFAULT ''::character varying, 
  activate_date date NOT NULL,
  unit_name character varying(50) NOT NULL DEFAULT ''::character varying, 
  unit_type character varying(10) NOT NULL DEFAULT ''::character varying, 
  approver_personal_id character varying(250) NOT NULL DEFAULT ''::character varying, 
  approver_section_code character varying(10) NOT NULL DEFAULT ''::character varying, 
  approver_position_code character varying(10) NOT NULL DEFAULT ''::character varying, 
  route_stage integer NOT NULL DEFAULT 0, 
  inactivate_flag integer NOT NULL DEFAULT 0, 
  delete_flag integer NOT NULL DEFAULT 0, 
  insert_date timestamp without time zone NOT NULL, 
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, 
  update_date timestamp without time zone NOT NULL, 
  update_user character varying(50) NOT NULL DEFAULT ''::character varying,
  CONSTRAINT pfm_approval_unit_pkey PRIMARY KEY (pfm_approval_unit_id)
)
;
COMMENT ON TABLE pfm_approval_unit IS '承認ユニットマスタ';
COMMENT ON COLUMN pfm_approval_unit.pfm_approval_unit_id IS 'レコード識別ID';
COMMENT ON COLUMN pfm_approval_unit.unit_code IS 'ユニットコード';
COMMENT ON COLUMN pfm_approval_unit.activate_date IS '有効日';
COMMENT ON COLUMN pfm_approval_unit.unit_name IS 'ユニット名称';
COMMENT ON COLUMN pfm_approval_unit.unit_type IS 'ユニット区分';
COMMENT ON COLUMN pfm_approval_unit.approver_personal_id IS '承認者個人ID';
COMMENT ON COLUMN pfm_approval_unit.approver_section_code IS '承認者所属コード';
COMMENT ON COLUMN pfm_approval_unit.approver_position_code IS '承認者職位コード';
COMMENT ON COLUMN pfm_approval_unit.route_stage IS '複数決済';
COMMENT ON COLUMN pfm_approval_unit.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN pfm_approval_unit.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pfm_approval_unit.insert_date IS '登録日';
COMMENT ON COLUMN pfm_approval_unit.insert_user IS '登録者';
COMMENT ON COLUMN pfm_approval_unit.update_date IS '更新日';
COMMENT ON COLUMN pfm_approval_unit.update_user IS '更新者';

CREATE TABLE pfm_approval_route
(
  pfm_approval_route_id bigint NOT NULL DEFAULT 0, 
  route_code character varying(10) NOT NULL DEFAULT ''::character varying, 
  activate_date date NOT NULL, 
  route_name character varying(50) NOT NULL DEFAULT ''::character varying,
  approval_count integer NOT NULL DEFAULT 0, 
  inactivate_flag integer NOT NULL DEFAULT 0, 
  delete_flag integer NOT NULL DEFAULT 0, 
  insert_date timestamp without time zone NOT NULL,
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying,
  update_date timestamp without time zone NOT NULL,
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, 
  CONSTRAINT pfm_approval_route_pkey PRIMARY KEY (pfm_approval_route_id)
)
;
COMMENT ON TABLE pfm_approval_route IS '承認ルートマスタ';
COMMENT ON COLUMN pfm_approval_route.pfm_approval_route_id IS 'レコード識別ID';
COMMENT ON COLUMN pfm_approval_route.route_code IS 'ルートコード';
COMMENT ON COLUMN pfm_approval_route.activate_date IS '有効日';
COMMENT ON COLUMN pfm_approval_route.route_name IS 'ルート名称';
COMMENT ON COLUMN pfm_approval_route.approval_count IS '承認階層';
COMMENT ON COLUMN pfm_approval_route.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN pfm_approval_route.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pfm_approval_route.insert_date IS '登録日';
COMMENT ON COLUMN pfm_approval_route.insert_user IS '登録者';
COMMENT ON COLUMN pfm_approval_route.update_date IS '更新日';
COMMENT ON COLUMN pfm_approval_route.update_user IS '更新者';


CREATE TABLE pfa_approval_route_unit
(
  pfa_approval_route_unit_id bigint NOT NULL DEFAULT 0, 
  route_code character varying(10) NOT NULL DEFAULT ''::character varying, 
  activate_date date NOT NULL, 
  approval_stage integer NOT NULL DEFAULT 0, 
  unit_code character varying(10) NOT NULL DEFAULT ''::character varying, 
  inactivate_flag integer NOT NULL DEFAULT 0, 
  delete_flag integer NOT NULL DEFAULT 0, 
  insert_date timestamp without time zone NOT NULL, 
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, 
  update_date timestamp without time zone NOT NULL, 
  update_user character varying(50) NOT NULL DEFAULT ''::character varying,
  CONSTRAINT pfa_approval_route_unit_pkey PRIMARY KEY (pfa_approval_route_unit_id)
)
;
COMMENT ON TABLE pfa_approval_route_unit IS '承認ルートユニットマスタ';
COMMENT ON COLUMN pfa_approval_route_unit.pfa_approval_route_unit_id IS 'レコード識別ID';
COMMENT ON COLUMN pfa_approval_route_unit.route_code IS 'ルートコード';
COMMENT ON COLUMN pfa_approval_route_unit.activate_date IS '有効日';
COMMENT ON COLUMN pfa_approval_route_unit.approval_stage IS '承認段階';
COMMENT ON COLUMN pfa_approval_route_unit.unit_code IS 'ユニットコード';
COMMENT ON COLUMN pfa_approval_route_unit.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN pfa_approval_route_unit.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pfa_approval_route_unit.insert_date IS '登録日';
COMMENT ON COLUMN pfa_approval_route_unit.insert_user IS '登録者';
COMMENT ON COLUMN pfa_approval_route_unit.update_date IS '更新日';
COMMENT ON COLUMN pfa_approval_route_unit.update_user IS '更新者';



CREATE TABLE pft_message
(
  pft_message_id bigint NOT NULL DEFAULT 0, 
  message_no character varying(10) NOT NULL DEFAULT ''::character varying, 
  start_date date NOT NULL, 
  end_date date NOT NULL, 
  message_type integer NOT NULL DEFAULT 0, 
  message_importance integer NOT NULL DEFAULT 0, 
  message_title character varying(255) NOT NULL DEFAULT ''::character varying, 
  message_body text NOT NULL DEFAULT ''::character varying, 
  application_type integer NOT NULL DEFAULT 0, 
  work_place_code character varying(10) NOT NULL DEFAULT ''::character varying,
  employment_contract_code character varying(10) NOT NULL DEFAULT ''::character varying, 
  section_code character varying(10) NOT NULL DEFAULT ''::character varying, 
  position_code character varying(10) NOT NULL DEFAULT ''::character varying, 
  personal_ids text NOT NULL DEFAULT ''::character varying,
  inactivate_flag integer NOT NULL DEFAULT 0, 
  delete_flag integer NOT NULL DEFAULT 0, 
  insert_date timestamp without time zone NOT NULL, 
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, 
  update_date timestamp without time zone NOT NULL, 
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, 
  CONSTRAINT pft_message_pkey PRIMARY KEY (pft_message_id)
)
;
COMMENT ON TABLE pft_message IS 'メッセージテーブル';
COMMENT ON COLUMN pft_message.pft_message_id IS 'レコード識別ID';
COMMENT ON COLUMN pft_message.message_no IS 'メッセージNo';
COMMENT ON COLUMN pft_message.start_date IS '公開開始日';
COMMENT ON COLUMN pft_message.end_date IS '公開終了日';
COMMENT ON COLUMN pft_message.message_type IS 'メッセージ区分';
COMMENT ON COLUMN pft_message.message_importance IS '重要度';
COMMENT ON COLUMN pft_message.message_title IS 'メッセージタイトル';
COMMENT ON COLUMN pft_message.message_body IS 'メッセージ本文';
COMMENT ON COLUMN pft_message.application_type IS 'メッセージ適用範囲区分';
COMMENT ON COLUMN pft_message.work_place_code IS '勤務地コード';
COMMENT ON COLUMN pft_message.employment_contract_code IS '雇用契約コード';
COMMENT ON COLUMN pft_message.section_code IS '所属コード';
COMMENT ON COLUMN pft_message.position_code IS '職位コード';
COMMENT ON COLUMN pft_message.personal_ids IS '個人ID';
COMMENT ON COLUMN pft_message.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN pft_message.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pft_message.insert_date IS '登録日';
COMMENT ON COLUMN pft_message.insert_user IS '登録者';
COMMENT ON COLUMN pft_message.update_date IS '更新日';
COMMENT ON COLUMN pft_message.update_user IS '更新者';



CREATE TABLE pft_sub_approver
(
  pft_sub_approver_id bigint NOT NULL DEFAULT 0, 
  sub_approver_no character varying(10) NOT NULL DEFAULT ''::character varying, 
  personal_id character varying(10) NOT NULL DEFAULT ''::character varying, 
  workflow_type integer NOT NULL DEFAULT 0,
  start_date date NOT NULL, 
  end_date date NOT NULL, 
  sub_approver_id character varying(10) NOT NULL DEFAULT ''::character varying, 
  inactivate_flag integer NOT NULL DEFAULT 0, 
  delete_flag integer NOT NULL DEFAULT 0,
  insert_date timestamp without time zone NOT NULL, 
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, 
  update_date timestamp without time zone NOT NULL, 
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, 
  CONSTRAINT pft_sub_approver_pkey PRIMARY KEY (pft_sub_approver_id)
)
;
COMMENT ON TABLE pft_sub_approver IS '代理承認者テーブル';
COMMENT ON COLUMN pft_sub_approver.pft_sub_approver_id IS 'レコード識別ID';
COMMENT ON COLUMN pft_sub_approver.sub_approver_no IS '代理承認者登録No';
COMMENT ON COLUMN pft_sub_approver.personal_id IS '代理元個人ID';
COMMENT ON COLUMN pft_sub_approver.workflow_type IS 'フロー区分';
COMMENT ON COLUMN pft_sub_approver.start_date IS '代理開始日';
COMMENT ON COLUMN pft_sub_approver.end_date IS '代理終了日';
COMMENT ON COLUMN pft_sub_approver.sub_approver_id IS '代理承認者個人ID';
COMMENT ON COLUMN pft_sub_approver.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN pft_sub_approver.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pft_sub_approver.insert_date IS '登録日';
COMMENT ON COLUMN pft_sub_approver.insert_user IS '登録者';
COMMENT ON COLUMN pft_sub_approver.update_date IS '更新日';
COMMENT ON COLUMN pft_sub_approver.update_user IS '更新者';



CREATE TABLE pfm_route_application
(
  pfm_route_application_id bigint NOT NULL DEFAULT 0, 
  route_application_code character varying(10) NOT NULL DEFAULT ''::character varying, 
  activate_date date NOT NULL, 
  route_application_name character varying(50) NOT NULL DEFAULT ''::character varying, 
  route_code character varying(10) NOT NULL DEFAULT ''::character varying, 
  workflow_type integer NOT NULL DEFAULT 0, 
  route_application_type integer NOT NULL DEFAULT 0, 
  work_place_code character varying(10) NOT NULL DEFAULT ''::character varying, 
  employment_contract_code character varying(10) NOT NULL DEFAULT ''::character varying, 
  section_code character varying(10) NOT NULL DEFAULT ''::character varying, 
  position_code character varying(10) NOT NULL DEFAULT ''::character varying, 
  personal_ids text NOT NULL DEFAULT ''::character varying,
  inactivate_flag integer NOT NULL DEFAULT 0, 
  delete_flag integer NOT NULL DEFAULT 0, 
  insert_date timestamp without time zone NOT NULL, 
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, 
  update_date timestamp without time zone NOT NULL, 
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, 
  CONSTRAINT pfm_approval_route_application_pkey PRIMARY KEY (pfm_route_application_id)
)
;
COMMENT ON TABLE pfm_route_application IS 'ルート適用マスタ';
COMMENT ON COLUMN pfm_route_application.pfm_route_application_id IS 'レコード識別ID';
COMMENT ON COLUMN pfm_route_application.route_application_code IS 'ルート適用コード';
COMMENT ON COLUMN pfm_route_application.activate_date IS '有効日';
COMMENT ON COLUMN pfm_route_application.route_application_name IS 'ルート適用名称';
COMMENT ON COLUMN pfm_route_application.route_code IS 'ルートコード';
COMMENT ON COLUMN pfm_route_application.workflow_type IS 'フロー区分';
COMMENT ON COLUMN pfm_route_application.route_application_type IS 'ルート適用区分';
COMMENT ON COLUMN pfm_route_application.work_place_code IS '勤務地コード';
COMMENT ON COLUMN pfm_route_application.employment_contract_code IS '雇用契約コード';
COMMENT ON COLUMN pfm_route_application.section_code IS '所属コード';
COMMENT ON COLUMN pfm_route_application.position_code IS '職位コード';
COMMENT ON COLUMN pfm_route_application.personal_ids IS '個人ID';
COMMENT ON COLUMN pfm_route_application.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN pfm_route_application.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pfm_route_application.insert_date IS '登録日';
COMMENT ON COLUMN pfm_route_application.insert_user IS '登録者';
COMMENT ON COLUMN pfm_route_application.update_date IS '更新日';
COMMENT ON COLUMN pfm_route_application.update_user IS '更新者';



CREATE TABLE pfm_import
(
  pfm_import_id bigint NOT NULL DEFAULT 0, 
  import_code character varying(10) NOT NULL DEFAULT ''::character varying, 
  import_name character varying(50) NOT NULL DEFAULT ''::character varying,
  import_table character varying(50) NOT NULL DEFAULT ''::character varying, 
  type character varying(50) NOT NULL DEFAULT ''::character varying, 
  header integer NOT NULL DEFAULT 0,
  inactivate_flag integer NOT NULL DEFAULT 0, 
  delete_flag integer NOT NULL DEFAULT 0, 
  insert_date timestamp without time zone NOT NULL, 
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying,
  update_date timestamp without time zone NOT NULL, 
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, 
  CONSTRAINT pfm_import_pkey PRIMARY KEY (pfm_import_id)
)
;
COMMENT ON TABLE pfm_import IS 'インポートマスタ';
COMMENT ON COLUMN pfm_import.pfm_import_id IS 'レコード識別ID';
COMMENT ON COLUMN pfm_import.import_code IS 'インポートコード';
COMMENT ON COLUMN pfm_import.import_name IS 'インポート名称';
COMMENT ON COLUMN pfm_import.import_table IS 'データ区分';
COMMENT ON COLUMN pfm_import.type IS 'データ型';
COMMENT ON COLUMN pfm_import.header IS 'ヘッダ有無';
COMMENT ON COLUMN pfm_import.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN pfm_import.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pfm_import.insert_date IS '登録日';
COMMENT ON COLUMN pfm_import.insert_user IS '登録者';
COMMENT ON COLUMN pfm_import.update_date IS '更新日';
COMMENT ON COLUMN pfm_import.update_user IS '更新者';



CREATE TABLE pfa_import_field
(
  pfa_import_field_id bigint NOT NULL DEFAULT 0,
  import_code character varying(10) NOT NULL DEFAULT ''::character varying, 
  field_name character varying(50) NOT NULL DEFAULT ''::character varying, 
  field_order integer NOT NULL DEFAULT 0, 
  inactivate_flag integer NOT NULL DEFAULT 0, 
  delete_flag integer NOT NULL DEFAULT 0,
  insert_date timestamp without time zone NOT NULL, 
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, 
  update_date timestamp without time zone NOT NULL, 
  update_user character varying(50) NOT NULL DEFAULT ''::character varying,
  CONSTRAINT pfa_import_field_pkey PRIMARY KEY (pfa_import_field_id)
)
;
COMMENT ON TABLE pfa_import_field IS 'インポートフィールド情報';
COMMENT ON COLUMN pfa_import_field.pfa_import_field_id IS 'レコード識別ID';
COMMENT ON COLUMN pfa_import_field.import_code IS 'インポートコード';
COMMENT ON COLUMN pfa_import_field.field_name IS 'フィールド名称';
COMMENT ON COLUMN pfa_import_field.field_order IS 'フィールド順番';
COMMENT ON COLUMN pfa_import_field.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN pfa_import_field.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pfa_import_field.insert_date IS '登録日';
COMMENT ON COLUMN pfa_import_field.insert_user IS '登録者';
COMMENT ON COLUMN pfa_import_field.update_date IS '更新日';
COMMENT ON COLUMN pfa_import_field.update_user IS '更新者';



CREATE TABLE pfm_export
(
  pfm_export_id bigint NOT NULL DEFAULT 0, 
  export_code character varying(10) NOT NULL DEFAULT ''::character varying,
  export_name character varying(50) NOT NULL DEFAULT ''::character varying, 
  export_table character varying(50) NOT NULL DEFAULT ''::character varying, 
  type character varying(50) NOT NULL DEFAULT ''::character varying,
  header integer NOT NULL DEFAULT 0, 
  inactivate_flag integer NOT NULL DEFAULT 0,
  delete_flag integer NOT NULL DEFAULT 0, 
  insert_date timestamp without time zone NOT NULL, 
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying,
  update_date timestamp without time zone NOT NULL, 
  update_user character varying(50) NOT NULL DEFAULT ''::character varying,
  CONSTRAINT pfm_export_pkey PRIMARY KEY (pfm_export_id)
)
;
COMMENT ON TABLE pfm_export IS 'エクスポートマスタ';
COMMENT ON COLUMN pfm_export.pfm_export_id IS 'レコード識別ID';
COMMENT ON COLUMN pfm_export.export_code IS 'エクスポートコード';
COMMENT ON COLUMN pfm_export.export_name IS 'エクスポート名称';
COMMENT ON COLUMN pfm_export.export_table IS 'データ区分';
COMMENT ON COLUMN pfm_export.type IS 'データ型';
COMMENT ON COLUMN pfm_export.header IS 'ヘッダ有無';
COMMENT ON COLUMN pfm_export.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN pfm_export.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pfm_export.insert_date IS '登録日';
COMMENT ON COLUMN pfm_export.insert_user IS '登録者';
COMMENT ON COLUMN pfm_export.update_date IS '更新日';
COMMENT ON COLUMN pfm_export.update_user IS '更新者';
CREATE TABLE pfa_export_field
(
  pfa_export_field_id bigint NOT NULL DEFAULT 0,
  export_code character varying(10) NOT NULL DEFAULT ''::character varying, 
  field_name character varying(50) NOT NULL DEFAULT ''::character varying, 
  field_order integer NOT NULL DEFAULT 0, 
  inactivate_flag integer NOT NULL DEFAULT 0,
  delete_flag integer NOT NULL DEFAULT 0, 
  insert_date timestamp without time zone NOT NULL,
  insert_user character varying(50) NOT NULL DEFAULT ''::character varying, 
  update_date timestamp without time zone NOT NULL, 
  update_user character varying(50) NOT NULL DEFAULT ''::character varying, 
  CONSTRAINT pfa_export_field_pkey PRIMARY KEY (pfa_export_field_id)
)
;
COMMENT ON TABLE pfa_export_field IS 'エクスポートフィールド情報';
COMMENT ON COLUMN pfa_export_field.pfa_export_field_id IS 'レコード識別ID';
COMMENT ON COLUMN pfa_export_field.export_code IS 'エクスポートコード';
COMMENT ON COLUMN pfa_export_field.field_name IS 'フィールド名称';
COMMENT ON COLUMN pfa_export_field.field_order IS 'フィールド順番';
COMMENT ON COLUMN pfa_export_field.inactivate_flag IS '無効フラグ';
COMMENT ON COLUMN pfa_export_field.delete_flag IS '削除フラグ';
COMMENT ON COLUMN pfa_export_field.insert_date IS '登録日';
COMMENT ON COLUMN pfa_export_field.insert_user IS '登録者';
COMMENT ON COLUMN pfa_export_field.update_date IS '更新日';
COMMENT ON COLUMN pfa_export_field.update_user IS '更新者';

