<%--
MosP - Mind Open Source Project    http://www.mosp.jp/
Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/

This program is free software: you can redistribute it and/or
modify it under the terms of the GNU Affero General Public License
as published by the Free Software Foundation, either version 3
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
--%>
<%@ page
language     = "java"
pageEncoding = "UTF-8"
buffer       = "64kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@page
import = "jp.mosp.framework.base.MospParams"
import = "jp.mosp.framework.constant.MospConst"
import = "jp.mosp.framework.utils.HtmlUtility"
import = "jp.mosp.platform.constant.PlatformConst"
import = "jp.mosp.time.constant.TimeConst"
import = "jp.mosp.time.constant.TimeMessageConst"
import = "jp.mosp.time.input.action.ScheduleReferenceAction"
import = "jp.mosp.time.input.vo.ScheduleReferenceVo"
%><%
MospParams params = (MospParams)request.getAttribute(MospConst.ATT_MOSP_PARAMS);
ScheduleReferenceVo vo = (ScheduleReferenceVo)params.getVo();
%>

<div class="ListHeader">
	<table class="SubTable">
		<tr>
			<td><button type="button" class="Name5Button" id="btnExport" onclick="submitFile(event, null, null, '<%= ScheduleReferenceAction.CMD_OUTPUT %>');"><%= params.getName("Schedule") %><%= params.getName("Book") %><%= params.getName("Output") %></button></td>
		</tr>
	</table>
	<table class="EmployeeLabelTable">
		<jsp:include page="<%= TimeConst.PATH_TIME_COMMON_INFO_JSP %>" flush="false" />
	</table>
	<table class="ShortLabelTable">
		<tr>
			<td class="TitleSelectTd" id="lblApplicationSchedule"><%= params.getName("PresentTime") %><%= params.getName("Of") %><%= params.getName("Calendar") %><%= params.getName("Colon") %>&nbsp;<%= HtmlUtility.escapeHTML(vo.getLblApplicationSchedule()) %></td>
		</tr>
	</table>
	<table class="DateChangeTable">
		<tr>
			<td>
				<a class="RollLink" id="eventFormer" name="eventFormer" onclick="submitTransfer(event, null, null, new Array('<%= TimeConst.PRM_TRANSFERRED_YEAR %>', '<%= vo.getPrevMonthYear() %>', '<%= TimeConst.PRM_TRANSFERRED_MONTH %>', '<%= vo.getPrevMonthMonth() %>'), '<%= ScheduleReferenceAction.CMD_SEARCH %>');">&lt;&lt;</a>
			</td>
			<td class="RangeSelectTd">
				&nbsp;
				<select class="Number4PullDown" id="pltSelectYear" name="pltSelectYear">
					<%= HtmlUtility.getSelectOption(vo.getAryPltSelectYear(), vo.getPltSelectYear()) %>
				</select>
				<%= params.getName("Year") %>&nbsp;
				<select class="Number2PullDown" id="pltSelectMonth" name="pltSelectMonth">
					<%= HtmlUtility.getSelectOption(vo.getAryPltSelectMonth(), vo.getPltSelectMonth()) %>
				</select>
				<%= params.getName("Month") %>
				<input type="hidden" id ="hdnSearchCommand" value="<%= ScheduleReferenceAction.CMD_SEARCH %>" />
			</td>
			<td>
				<a class="RollLink" id="eventNext" name="eventNext" onclick="submitTransfer(event, null, null, new Array('<%= TimeConst.PRM_TRANSFERRED_YEAR %>', '<%= vo.getNextMonthYear() %>', '<%= TimeConst.PRM_TRANSFERRED_MONTH %>', '<%= vo.getNextMonthMonth() %>'), '<%= ScheduleReferenceAction.CMD_SEARCH %>');">&gt;&gt;</a>
			</td>
			<td class="BetweenTd" class=""></td>
			<td>
				<button type="button" class="Name2Button" id="btnReset" onclick="submitTransfer(event, null, null, new Array('<%= TimeConst.PRM_TRANSFERRED_YEAR %>', '<%= vo.getThisMonthYear() %>', '<%= TimeConst.PRM_TRANSFERRED_MONTH %>', '<%= vo.getThisMonthMonth() %>'), '<%= ScheduleReferenceAction.CMD_SEARCH %>');"><%= params.getName("Now") %><%= params.getName("Month") %></button>
			</td>
		</tr>
	</table>
</div>
<%
if (vo.getAryLblDate().length == 0){
	return;
}
%>
<div class="List" id="calenderList">
	<table class="ListTable" id="list">
		<thead>
			<tr>
				<th class="ListSelectTh" id="thButton"></th>
				<th class="ListSelectTh" id="thTime"><%= params.getName("Day") %></th>
				<th class="ListSelectTh" id="thSingle"><%= params.getName("TheWeek") %></th>
				<th class="ListSelectTh" id="thTime"><%= params.getName("Form") %></th>
				<th class="ListSelectTh" id="thTime"><%= params.getName("StartWork") %></th>
				<th class="ListSelectTh" id="thTime"><%= params.getName("EndWork") %></th>
				<th class="ListSelectTh" id="thTime"><%= params.getName("WorkTime") %></th>
				<th class="ListSelectTh" id="thTime"><%= params.getName("RestTime") %></th>
				<th class="ListSelectTh" id="thTime"><%= params.getName("Tardiness") %></th>
				<th class="ListSelectTh" id="thTime"><%= params.getName("LeaveEarly") %></th>
				<th class="ListSelectTh" id="thTime"><%= params.getName("Inside") %><%= params.getName("Remainder") %></th>
				<th class="ListSelectTh" id="thTime"><%= params.getName("Outside") %><%= params.getName("Remainder") %></th>
				<th class="ListSelectTh" id="thTime"><%= params.getName("WorkingHoliday") %></th>
				<th class="ListSelectTh" id="thTime"><%= params.getName("Midnight") %></th>
				<th class="ListSelectTh" id="thState"><%= params.getName("State") %></th>
				<th class="ListSelectTh" id="thRemark"><%= params.getName("Remarks") %></th>
				<th class="ListSelectTh" id="thSingle"></th>
				<th class="ListSelectTh" id="thSingle"></th>
			</tr>
		</thead>
		<tbody>
<% for (int i = 0; i < vo.getAryLblDate().length; i++) { %>
			<tr>
				<td class="ListSelectTd"></td>
				<td class="ListSelectTd"><%= HtmlUtility.escapeHTML(vo.getAryLblDate     (i)) %></td>
				<td class="ListSelectTd"><span <%= vo.getAryWorkDayOfWeekStyle(i) %>><%= HtmlUtility.escapeHTML(vo.getAryLblWeek(i)) %></span></td>
				<td class="ListSelectTd"><%= HtmlUtility.escapeHTML(vo.getAryLblWorkType (i)) %></td>
				<td class="ListSelectTd"><%= HtmlUtility.escapeHTML(vo.getAryLblStartTime(i)) %></td>
				<td class="ListSelectTd"><%= HtmlUtility.escapeHTML(vo.getAryLblEndTime  (i)) %></td>
				<td class="ListSelectTd"><%= HtmlUtility.escapeHTML(vo.getAryLblWorkTime (i)) %></td>
				<td class="ListSelectTd"><%= HtmlUtility.escapeHTML(vo.getAryLblRestTime (i)) %></td>
				<td class="ListSelectTd"><%= params.getName("Hyphen") %></td>
				<td class="ListSelectTd"><%= params.getName("Hyphen") %></td>
				<td class="ListSelectTd"><%= params.getName("Hyphen") %></td>
				<td class="ListSelectTd"><%= params.getName("Hyphen") %></td>
				<td class="ListSelectTd"><%= params.getName("Hyphen") %></td>
				<td class="ListSelectTd"><%= params.getName("Hyphen") %></td>
				<td class="ListSelectTd"><%= params.getName("Hyphen") %></td>
				<td class="ListInputTd"><%= HtmlUtility.escapeHTML(vo.getAryLblRemark(i)) %></td>
				<td class="ListSelectTd"></td>
				<td class="ListSelectTd"></td>
			</tr>
<% } %>
			<tr>
				<th class="ListSelectTh" id="thButton"></th>
				<th class="ListSelectTh" id="thTime"><%= params.getName("Day") %></th>
				<th class="ListSelectTh" id="thSingle"><%= params.getName("TheWeek") %></th>
				<th class="ListSelectTh" id="thTime"><%= params.getName("Form") %></th>
				<th class="ListSelectTh" id="thTime"><%= params.getName("StartWork") %></th>
				<th class="ListSelectTh" id="thTime"><%= params.getName("EndWork") %></th>
				<th class="ListSelectTh" id="thTime"><%= params.getName("WorkTime") %></th>
				<th class="ListSelectTh" id="thTime"><%= params.getName("RestTime") %></th>
				<th class="ListSelectTh" id="thTime"><%= params.getName("Tardiness") %></th>
				<th class="ListSelectTh" id="thTime"><%= params.getName("LeaveEarly") %></th>
				<th class="ListSelectTh" id="thTime"><%= params.getName("Inside") %><%= params.getName("Remainder") %></th>
				<th class="ListSelectTh" id="thTime"><%= params.getName("Outside") %><%= params.getName("Remainder") %></th>
				<th class="ListSelectTh" id="thTime"><%= params.getName("WorkingHoliday") %></th>
				<th class="ListSelectTh" id="thTime"><%= params.getName("Midnight") %></th>
				<th class="ListSelectTh" id="thState"><%= params.getName("State") %></th>
				<th class="ListSelectTh" id="thRemark"><%= params.getName("Remarks") %></th>
				<th class="ListSelectTh" id="thSingle"></th>
				<th class="ListSelectTh" id="thSingle"></th>
			</tr>
		</tbody>
	</table>
</div>
<div class="List">
	<table class="LeftListTable">
		<tr>
			<th class="ListSelectTh" id="thTotalTime" rowspan="2">
				<div><%= params.getName("SumTotal") %></div>
				<div><%= params.getName("Time") %></div>
			</th>
			<th class="ListSelectTh" id="thTotalTime"            ><%= params.getName("Work"      ) %></th>
			<th class="ListSelectTh" id="thTotalTime"            ><%= params.getName("RestTime"  ) %></th>
			<th class="ListSelectTh" id="thTotalTime" rowspan="2"><%= params.getName("Frequency" ) %></th>
			<th class="ListSelectTh" id="thTotalTime"            ><%= params.getName("GoingWork" ) %></th>
			<th class="ListSelectTh" id="thTotalTime" rowspan="2"><%= params.getName("Holiday"   ) %></th>
			<th class="ListSelectTh" id="thTotalTime"            ><%= params.getName("Legal"     ) %></th>
			<th class="ListSelectTh" id="thTotalTime"            ><%= params.getName("Prescribed") %></th>
			<td class="Blank" colspan="7" rowspan="2"></td>
		</tr>
		<tr>
			<td class="SelectTd"><%= vo.getLblTotalWork             () %></td>
			<td class="SelectTd"><%= vo.getLblTotalRest             () %></td>
			<td class="SelectTd"><%= vo.getLblTimesWork             () %></td>
			<td class="SelectTd"><%= vo.getLblTimesLegalHoliday     () %></td>
			<td class="SelectTd"><%= vo.getLblTimesPrescribedHoliday() %></td>
		</tr>
	</table>
</div>
