/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * 
 */
package jp.mosp.time.bean.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.time.bean.AttendanceCorrectionRegistBeanInterface;
import jp.mosp.time.constant.TimeConst;
import jp.mosp.time.dao.settings.AttendanceCorrectionDaoInterface;
import jp.mosp.time.dao.settings.AttendanceDaoInterface;
import jp.mosp.time.dao.settings.GoOutDaoInterface;
import jp.mosp.time.dao.settings.RestDaoInterface;
import jp.mosp.time.dto.settings.AllowanceDtoInterface;
import jp.mosp.time.dto.settings.AttendanceCorrectionDtoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.GoOutDtoInterface;
import jp.mosp.time.dto.settings.RestDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdAttendanceCorrectionDto;

/**
 * 勤怠データ修正情報登録クラス。
 */
public class AttendanceCorrectionRegistBean extends PlatformBean implements AttendanceCorrectionRegistBeanInterface {
	
	/**
	 * 勤怠修正データDAOクラス。<br>
	 */
	AttendanceCorrectionDaoInterface	attendanceCorrectionDao;
	
	/**
	 * 勤怠データDAOクラス。<br>
	 */
	AttendanceDaoInterface				attendanceDao;
	
	/**
	 * 勤怠データDAOクラス。<br>
	 */
	RestDaoInterface					restDao;
	
	/**
	 * 休出DAOクラス。<br>
	 */
	GoOutDaoInterface					goOutDao;
	

	/**
	 * 勤怠データDAOクラス。<br>
	 */
	
	/**
	 * {@link PlatformBean#PlatformBean()}を実行する。<br>
	 */
	public AttendanceCorrectionRegistBean() {
		super();
	}
	
	/**
	 * {@link PlatformBean#PlatformBean(MospParams, Connection)}を実行する。<br>
	 * @param mospParams MosPパラメータクラス
	 * @param connection DBコネクション
	 */
	public AttendanceCorrectionRegistBean(MospParams mospParams, Connection connection) {
		super(mospParams, connection);
	}
	
	@Override
	public void initBean() throws MospException {
		attendanceCorrectionDao = (AttendanceCorrectionDaoInterface)createDao(AttendanceCorrectionDaoInterface.class);
		attendanceDao = (AttendanceDaoInterface)createDao(AttendanceDaoInterface.class);
		restDao = (RestDaoInterface)createDao(RestDaoInterface.class);
		goOutDao = (GoOutDaoInterface)createDao(GoOutDaoInterface.class);
		
	}
	
	@Override
	public AttendanceCorrectionDtoInterface getInitDto() {
		return new TmdAttendanceCorrectionDto();
	}
	
	@Override
	public void insert(AttendanceCorrectionDtoInterface dto) throws MospException {
		// ロック対象テーブルの追加
		addTargetTable(attendanceCorrectionDao.getTable(attendanceCorrectionDao.getClass()), true);
		// ロック開始
		lockTables();
		if (mospParams.hasErrorMessage()) {
			// ロック解除
			unLockTable();
			return;
		}
		// レコード識別ID最大値をインクリメントしてDTOに設定
		dto.setTmdAttendanceCorrectionId(findForMaxId(attendanceCorrectionDao) + 1);
		// 登録処理
		attendanceCorrectionDao.insert(dto);
		// ロック解除
		unLockTable();
	}
	
	@Override
	public void update(AttendanceCorrectionDtoInterface dto) {
		// 現在使用しないメソッド
	}
	
	@Override
	public void insertAttendance(AttendanceCorrectionDtoInterface dto, AttendanceDtoInterface oldDto,
			AttendanceDtoInterface newDto) throws MospException {
		// DTOの妥当性確認
		validate(dto);
		// 変更部分の検索
		List<AttendanceCorrectionDtoInterface> list = setChangePointAttendance(oldDto, newDto);
		for (AttendanceCorrectionDtoInterface attendanceCorrectionDto : list) {
			if (null == attendanceCorrectionDto) {
				continue;
			}
			// 勤怠情報設定
			setValueAttendanceCorrection(dto, attendanceCorrectionDto);
			// 登録
			insert(dto);
		}
	}
	
	@Override
	public void insertAllowance(AttendanceCorrectionDtoInterface dto, AllowanceDtoInterface oldAllowanceDto,
			AllowanceDtoInterface newAllowanceDto) throws MospException {
		// DTOの妥当性確認
		validate(dto);
		// 変更部分の検索
		AttendanceCorrectionDtoInterface newAttendanceCorrection = setChangePointAllowance(dto, oldAllowanceDto,
				newAllowanceDto);
		// 勤怠情報設定
		setValueAttendanceCorrection(dto, newAttendanceCorrection);
		// 
		if (mospParams.hasErrorMessage()) {
			return;
		}
		// ロック対象テーブルの追加
		addTargetTable(attendanceCorrectionDao.getTable(attendanceCorrectionDao.getClass()), true);
		// ロック開始
		lockTables();
		if (mospParams.hasErrorMessage()) {
			// ロック解除
			unLockTable();
			return;
		}
		// レコード識別ID最大値をインクリメントしてDTOに設定
		dto.setTmdAttendanceCorrectionId(findForMaxId(attendanceCorrectionDao) + 1);
		// 登録処理
		attendanceCorrectionDao.insert(dto);
		// ロック解除
		unLockTable();
	}
	
	@Override
	public void insertRest(AttendanceCorrectionDtoInterface dto, RestDtoInterface oldRestDto,
			RestDtoInterface newRestDto) throws MospException {
		// DTOの妥当性確認
		validate(dto);
		// 変更部分の検索
		AttendanceCorrectionDtoInterface newAttendanceCorrection = setChangePointRest(dto, oldRestDto, newRestDto);
		if (null == newAttendanceCorrection) {
			return;
		}
		// 勤怠情報設定
		setValueAttendanceCorrection(dto, newAttendanceCorrection);
		// 登録
		insert(dto);
	}
	
	public void insertaGoOut(AttendanceCorrectionDtoInterface dto, GoOutDtoInterface oldGoOutDto,
			GoOutDtoInterface newGoOutDto) throws MospException {
		// DTOの妥当性確認
		validate(dto);
		// 変更部分の検索
		AttendanceCorrectionDtoInterface newAttendanceCorrection = setChangePointGoOut(dto, oldGoOutDto, newGoOutDto);
		if (null == newAttendanceCorrection) {
			return;
		}
		// 勤怠情報設定
		setValueAttendanceCorrection(dto, newAttendanceCorrection);
		// 登録
		insert(dto);
	}
	
	/**
	 * 登録情報の妥当性を確認する。
	 * @param dto 対象DTO
	 */
	protected void validate(AttendanceCorrectionDtoInterface dto) {
		// TODO 保留
	}
	
	/**
	 * 修正前/修正後のDTOを見て修正コメントを作成する。
	 * @param oldDto 修正前データ
	 * @param newDto 修正後データ
	 * @return 修正コメント
	 */
	protected List<AttendanceCorrectionDtoInterface> setChangePointAttendance(AttendanceDtoInterface oldDto,
			AttendanceDtoInterface newDto) {
		final String HYPHEN = mospParams.getName("Hyphen");
		List<AttendanceCorrectionDtoInterface> list = new ArrayList<AttendanceCorrectionDtoInterface>();
		// 修正前データの有無
		boolean noPreviousData = null == oldDto || null == oldDto.getWorkTypeCode() || null == oldDto.getStartTime()
				|| null == oldDto.getEndTime() || null == oldDto.getTimeComment() || null == oldDto.getLateReason()
				|| null == oldDto.getLateComment() || null == oldDto.getLeaveEarlyReason()
				|| null == oldDto.getLeaveEarlyComment();
		if (noPreviousData) {
			// 修正前データが無し
			
			// 勤務形態
			list.add(getAttendanceCorrectionDto(TimeConst.CODE_ATTENDANCE_ITEM_NAME_WORKTYPECODE, HYPHEN, newDto
				.getWorkTypeCode()));
			// 出勤時刻
			list.add(getAttendanceCorrectionDto(TimeConst.CODE_ATTENDANCE_ITEM_NAME_STARTTIME, HYPHEN, DateUtility
				.getStringTime(newDto.getStartTime())));
			// 退勤時刻
			list.add(getAttendanceCorrectionDto(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ENDTIME, HYPHEN, DateUtility
				.getStringTime(newDto.getEndTime())));
			// 直行
			list.add(getAttendanceCorrectionDto(TimeConst.CODE_ATTENDANCE_ITEM_NAME_DIRECTSTART, HYPHEN, String
				.valueOf(newDto.getDirectStart())));
			// 直帰
			list.add(getAttendanceCorrectionDto(TimeConst.CODE_ATTENDANCE_ITEM_NAME_DIRECTEND, HYPHEN, String
				.valueOf(newDto.getDirectEnd())));
			// 勤怠コメント
			list.add(getAttendanceCorrectionDto(TimeConst.CODE_ATTENDANCE_ITEM_NAME_TIMECOMMENT, HYPHEN, newDto
				.getTimeComment()));
			// 遅刻理由
			list.add(getAttendanceCorrectionDto(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LATEREASON, HYPHEN, newDto
				.getLateReason()));
			// 遅刻証明書
			list.add(getAttendanceCorrectionDto(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LATECERTIFICATE, HYPHEN, newDto
				.getLateCertificate()));
			// 遅刻コメント
			list.add(getAttendanceCorrectionDto(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LATECOMMENT, HYPHEN, newDto
				.getLateComment()));
			// 早退理由
			list.add(getAttendanceCorrectionDto(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LEAVEEARLYREASON, HYPHEN, newDto
				.getLeaveEarlyReason()));
			// 早退証明書
			list.add(getAttendanceCorrectionDto(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LEAVEEARLYCERTIFICATE, HYPHEN,
					newDto.getLeaveEarlyCertificate()));
			// 早退コメント
			list.add(getAttendanceCorrectionDto(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LEAVEEARLYCOMMENT, HYPHEN, newDto
				.getLeaveEarlyComment()));
		} else {
			// 勤務形態
			if (!oldDto.getWorkTypeCode().equals(newDto.getWorkTypeCode())) {
				list.add(getAttendanceCorrectionDto(TimeConst.CODE_ATTENDANCE_ITEM_NAME_WORKTYPECODE, oldDto
					.getWorkTypeCode(), newDto.getWorkTypeCode()));
			}
			// 出勤時刻
			if (oldDto.getStartTime().getTime() != newDto.getStartTime().getTime()) {
				list.add(getAttendanceCorrectionDto(TimeConst.CODE_ATTENDANCE_ITEM_NAME_STARTTIME, DateUtility
					.getStringTime(oldDto.getStartTime()), DateUtility.getStringTime(newDto.getStartTime())));
			}
			// 退勤時刻
			if (oldDto.getEndTime().getTime() != newDto.getEndTime().getTime()) {
				list.add(getAttendanceCorrectionDto(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ENDTIME, DateUtility
					.getStringTime(oldDto.getEndTime()), DateUtility.getStringTime(newDto.getEndTime())));
			}
			// 直行
			if (oldDto.getDirectStart() != newDto.getDirectStart()) {
				list.add(getAttendanceCorrectionDto(TimeConst.CODE_ATTENDANCE_ITEM_NAME_DIRECTSTART, String
					.valueOf(oldDto.getDirectStart()), String.valueOf(newDto.getDirectStart())));
			}
			// 直帰
			if (oldDto.getDirectEnd() != newDto.getDirectEnd()) {
				list.add(getAttendanceCorrectionDto(TimeConst.CODE_ATTENDANCE_ITEM_NAME_DIRECTEND, String
					.valueOf(oldDto.getDirectEnd()), String.valueOf(newDto.getDirectEnd())));
			}
			// 勤怠コメント
			if (!oldDto.getTimeComment().equals(newDto.getTimeComment())) {
				list.add(getAttendanceCorrectionDto(TimeConst.CODE_ATTENDANCE_ITEM_NAME_TIMECOMMENT, oldDto
					.getTimeComment(), newDto.getTimeComment()));
			}
			// 遅刻理由
			if (!oldDto.getLateReason().equals(newDto.getLateReason())) {
				getAttendanceCorrectionDto(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LATEREASON, oldDto.getLateReason(),
						newDto.getLateReason());
			}
			// 遅刻証明書
			if (!oldDto.getLateCertificate().equals(newDto.getLateCertificate())) {
				list.add(getAttendanceCorrectionDto(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LATECERTIFICATE, oldDto
					.getLateCertificate(), newDto.getLateCertificate()));
			}
			// 遅刻コメント
			if (!oldDto.getLateComment().equals(newDto.getLateComment())) {
				list.add(getAttendanceCorrectionDto(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LATECOMMENT, oldDto
					.getLateComment(), newDto.getLateComment()));
			}
			// 早退理由
			if (!oldDto.getLeaveEarlyReason().equals(newDto.getLeaveEarlyReason())) {
				list.add(getAttendanceCorrectionDto(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LEAVEEARLYREASON, oldDto
					.getLeaveEarlyReason(), newDto.getLeaveEarlyReason()));
			}
			// 早退証明書
			if (!oldDto.getLeaveEarlyCertificate().equals(newDto.getLeaveEarlyCertificate())) {
				list.add(getAttendanceCorrectionDto(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LEAVEEARLYCERTIFICATE, oldDto
					.getLeaveEarlyCertificate(), newDto.getLeaveEarlyCertificate()));
			}
			// 早退コメント
			if (!oldDto.getLeaveEarlyComment().equals(newDto.getLeaveEarlyComment())) {
				list.add(getAttendanceCorrectionDto(TimeConst.CODE_ATTENDANCE_ITEM_NAME_LEAVEEARLYCOMMENT, oldDto
					.getLeaveEarlyComment(), newDto.getLeaveEarlyComment()));
			}
		}
		return list;
	}
	
	private AttendanceCorrectionDtoInterface getAttendanceCorrectionDto(String type, String before, String after) {
		// 項目に設定しない項目
		final String NO_CHECK = "0";
		final String BLANK = "";
		if (TimeConst.CODE_ATTENDANCE_ITEM_NAME_DIRECTSTART.equals(type)
				|| TimeConst.CODE_ATTENDANCE_ITEM_NAME_DIRECTEND.equals(type)) {
			if (NO_CHECK.equals(after)) {
				return null;
			}
		} else {
			if (BLANK.equals(after)) {
				return null;
			}
		}
		// 項目設定
		TmdAttendanceCorrectionDto dto = new TmdAttendanceCorrectionDto();
		dto.setCorrectionType(type);
		dto.setCorrectionBefore(before);
		dto.setCorrectionAfter(after);
		return dto;
	}
	
	/**
	 * 登録情報の妥当性を確認する。
	 * @param dto 対象DTO
	 * @param oldAllowanceDto 修正前データ
	 * @param newAllowanceDto 修正後データ
	 * @return 修正コメント
	 */
	protected AttendanceCorrectionDtoInterface setChangePointAllowance(AttendanceCorrectionDtoInterface dto,
			AllowanceDtoInterface oldAllowanceDto, AllowanceDtoInterface newAllowanceDto) {
		if (newAllowanceDto.getAllowanceCode().equals(TimeConst.CODE_ALLOWANCE_CODE_INFO1)) {
			dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE1);
			dto.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto.setCorrectionAfter(String.valueOf(newAllowanceDto.getAllowance()));
			if (oldAllowanceDto != null) {
				if (oldAllowanceDto.getAllowanceCode() != null) {
					dto.setCorrectionBefore(String.valueOf(oldAllowanceDto.getAllowance()));
				}
			}
		}
		if (newAllowanceDto.getAllowanceCode().equals(TimeConst.CODE_ALLOWANCE_CODE_INFO2)) {
			dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE2);
			dto.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto.setCorrectionAfter(String.valueOf(newAllowanceDto.getAllowance()));
			if (oldAllowanceDto != null) {
				if (oldAllowanceDto.getAllowanceCode() != null) {
					dto.setCorrectionBefore(String.valueOf(oldAllowanceDto.getAllowance()));
				}
			}
		}
		if (newAllowanceDto.getAllowanceCode().equals(TimeConst.CODE_ALLOWANCE_CODE_INFO3)) {
			dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE3);
			dto.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto.setCorrectionAfter(String.valueOf(newAllowanceDto.getAllowance()));
			if (oldAllowanceDto != null) {
				if (oldAllowanceDto.getAllowanceCode() != null) {
					dto.setCorrectionBefore(String.valueOf(oldAllowanceDto.getAllowance()));
				}
			}
		}
		if (newAllowanceDto.getAllowanceCode().equals(TimeConst.CODE_ALLOWANCE_CODE_INFO4)) {
			dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE4);
			dto.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto.setCorrectionAfter(String.valueOf(newAllowanceDto.getAllowance()));
			if (oldAllowanceDto != null) {
				if (oldAllowanceDto.getAllowanceCode() != null) {
					dto.setCorrectionBefore(String.valueOf(oldAllowanceDto.getAllowance()));
				}
			}
		}
		if (newAllowanceDto.getAllowanceCode().equals(TimeConst.CODE_ALLOWANCE_CODE_INFO5)) {
			dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE5);
			dto.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto.setCorrectionAfter(String.valueOf(newAllowanceDto.getAllowance()));
			if (oldAllowanceDto != null) {
				if (oldAllowanceDto.getAllowanceCode() != null) {
					dto.setCorrectionBefore(String.valueOf(oldAllowanceDto.getAllowance()));
				}
			}
		}
		if (newAllowanceDto.getAllowanceCode().equals(TimeConst.CODE_ALLOWANCE_CODE_INFO6)) {
			dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE6);
			dto.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto.setCorrectionAfter(String.valueOf(newAllowanceDto.getAllowance()));
			if (oldAllowanceDto != null) {
				if (oldAllowanceDto.getAllowanceCode() != null) {
					dto.setCorrectionBefore(String.valueOf(oldAllowanceDto.getAllowance()));
				}
			}
		}
		if (newAllowanceDto.getAllowanceCode().equals(TimeConst.CODE_ALLOWANCE_CODE_INFO7)) {
			dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE7);
			dto.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto.setCorrectionAfter(String.valueOf(newAllowanceDto.getAllowance()));
			if (oldAllowanceDto != null) {
				if (oldAllowanceDto.getAllowanceCode() != null) {
					dto.setCorrectionBefore(String.valueOf(oldAllowanceDto.getAllowance()));
				}
			}
		}
		if (newAllowanceDto.getAllowanceCode().equals(TimeConst.CODE_ALLOWANCE_CODE_INFO8)) {
			dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE8);
			dto.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto.setCorrectionAfter(String.valueOf(newAllowanceDto.getAllowance()));
			if (oldAllowanceDto != null) {
				if (oldAllowanceDto.getAllowanceCode() != null) {
					dto.setCorrectionBefore(String.valueOf(oldAllowanceDto.getAllowance()));
				}
			}
		}
		if (newAllowanceDto.getAllowanceCode().equals(TimeConst.CODE_ALLOWANCE_CODE_INFO9)) {
			dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE9);
			dto.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto.setCorrectionAfter(String.valueOf(newAllowanceDto.getAllowance()));
			if (oldAllowanceDto != null) {
				if (oldAllowanceDto.getAllowanceCode() != null) {
					dto.setCorrectionBefore(String.valueOf(oldAllowanceDto.getAllowance()));
				}
			}
		}
		if (newAllowanceDto.getAllowanceCode().equals(TimeConst.CODE_ALLOWANCE_CODE_INF10)) {
			dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_ALLOWANCE10);
			dto.setCorrectionBefore(mospParams.getName("Hyphen"));
			dto.setCorrectionAfter(String.valueOf(newAllowanceDto.getAllowance()));
			if (oldAllowanceDto != null) {
				if (oldAllowanceDto.getAllowanceCode() != null) {
					dto.setCorrectionBefore(String.valueOf(oldAllowanceDto.getAllowance()));
				}
			}
		}
		return dto;
	}
	
	/**
	 * 登録情報の妥当性を確認する。
	 * @param dto 対象DTO
	 * @param oldDto 修正前データ
	 * @param newDto 修正後データ
	 * @return 修正コメント
	 */
	protected AttendanceCorrectionDtoInterface setChangePointRest(AttendanceCorrectionDtoInterface dto,
			RestDtoInterface oldDto, RestDtoInterface newDto) {
		final String EXCEPT_TIME = "00:00";
		final String HYPHEN = mospParams.getName("Hyphen");
		// 項目に設定しない項目
		if (EXCEPT_TIME.equals(DateUtility.getStringTime(newDto.getRestStart()))
				|| EXCEPT_TIME.equals(DateUtility.getStringTime(newDto.getRestEnd()))) {
			return null;
		}
		if (newDto.getRest() == 1) {
			dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_BREAK1);
		}
		if (newDto.getRest() == 2) {
			dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_BREAK2);
		}
		if (newDto.getRest() == 3) {
			dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_BREAK3);
		}
		if (newDto.getRest() == 4) {
			dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_BREAK4);
		}
		if (newDto.getRest() == 5) {
			dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_BREAK5);
		}
		if (newDto.getRest() == 6) {
			dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_BREAK6);
		}
		dto.setCorrectionAfter(DateUtility.getStringTime(newDto.getRestStart()) + HYPHEN
				+ DateUtility.getStringTime(newDto.getRestEnd()));
		
		if (null == oldDto.getRestStart()) {
			dto.setCorrectionBefore(HYPHEN);
		} else {
			dto.setCorrectionBefore(DateUtility.getStringTime(oldDto.getRestStart()) + HYPHEN
					+ DateUtility.getStringTime(oldDto.getRestEnd()));
		}
		return dto;
	}
	
	/**
	 * 登録情報の妥当性を確認する。
	 * @param dto 対象DTO
	 * @param oldGoOutDto 旧外出データDTO
	 * @param newGoOutDto 新外出データDTO
	 * @return 変更箇所
	 */
	protected AttendanceCorrectionDtoInterface setChangePointGoOut(AttendanceCorrectionDtoInterface dto,
			GoOutDtoInterface oldGoOutDto, GoOutDtoInterface newGoOutDto) {
		final String EXCEPT_TIME = "00:00";
		final String HYPHEN = mospParams.getName("Hyphen");
		// 公用外出
		final int GO_OUT_PUBLIC = 1;
		// 私用外出
		final int GO_OUT_PRIVATE = 2;
		// 項目に設定しない項目
		if (EXCEPT_TIME.equals(DateUtility.getStringTime(newGoOutDto.getGoOutStart()))
				|| EXCEPT_TIME.equals(DateUtility.getStringTime(newGoOutDto.getGoOutEnd()))) {
			return null;
		}
		// 公用
		if (GO_OUT_PUBLIC == newGoOutDto.getGoOutType()) {
			if (newGoOutDto.getTimesGoOut() == 1) {
				dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_OFFICIAL_GOING_OUT1);
			}
			if (newGoOutDto.getTimesGoOut() == 2) {
				dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_OFFICIAL_GOING_OUT2);
			}
		}
		// 私用
		if (GO_OUT_PRIVATE == newGoOutDto.getGoOutType()) {
			if (newGoOutDto.getTimesGoOut() == 1) {
				dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_PRIVATE_GOING_OUT1);
			}
			if (newGoOutDto.getTimesGoOut() == 2) {
				dto.setCorrectionType(TimeConst.CODE_ATTENDANCE_ITEM_NAME_PRIVATE_GOING_OUT2);
			}
		}
		if (oldGoOutDto != null) {
			if (oldGoOutDto.getGoOutStart() != null) {
				dto.setCorrectionBefore(DateUtility.getStringTime(oldGoOutDto.getGoOutStart()) + HYPHEN
						+ DateUtility.getStringTime(oldGoOutDto.getGoOutEnd()));
			} else {
				dto.setCorrectionBefore(HYPHEN);
			}
		} else {
			dto.setCorrectionBefore(HYPHEN);
		}
		dto.setCorrectionAfter(DateUtility.getStringTime(newGoOutDto.getGoOutStart()) + HYPHEN
				+ DateUtility.getStringTime(newGoOutDto.getGoOutEnd()));
		return dto;
	}
	
	/**
	 * 登録情報の妥当性を確認する。
	 * @param contentsDto 変更内容情報のDTO
	 * @param registerDto 登録用DTO
	 */
	protected void setValueAttendanceCorrection(AttendanceCorrectionDtoInterface contentsDto,
			AttendanceCorrectionDtoInterface registerDto) {
		contentsDto.setCorrectionType(registerDto.getCorrectionType());
		contentsDto.setCorrectionBefore(registerDto.getCorrectionBefore());
		contentsDto.setCorrectionAfter(registerDto.getCorrectionAfter());
	}
	
	@Override
	public void delete(String personalId, Date workDate, int timesWork) throws MospException {
		// ロック対象テーブルの追加
		addTargetTable(attendanceCorrectionDao.getTable(attendanceCorrectionDao.getClass()), true);
		// ロック開始
		lockTables();
		List<AttendanceCorrectionDtoInterface> list = attendanceCorrectionDao.findForHistory(personalId, workDate,
				timesWork);
		for (AttendanceCorrectionDtoInterface dto : list) {
			// 論理削除
			logicalDelete(attendanceCorrectionDao, dto.getTmdAttendanceCorrectionId());
		}
		// ロック解除
		unLockTable();
	}
}
