/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * 
 */
package jp.mosp.time.bean;

import java.util.List;

import jp.mosp.framework.base.MospException;
import jp.mosp.time.dto.settings.CutoffErrorListDtoInterface;
import jp.mosp.time.dto.settings.TotalAbsenceDtoInterface;
import jp.mosp.time.dto.settings.TotalAllowanceDtoInterface;
import jp.mosp.time.dto.settings.TotalLeaveDtoInterface;
import jp.mosp.time.dto.settings.TotalOtherVacationDtoInterface;
import jp.mosp.time.dto.settings.TotalTimeDataDtoInterface;

/**
 * 勤怠集計インターフェース。
 */
public interface TotalTimeCalcBeanInterface {
	
	/**
	 * 勤怠集計。
	 * @param dto 対象DTO
	 * @param personalId 個人ID
	 * @param calculationYear 年
	 * @param calculationMonth 月
	 * @param cutoffCode 締日コード
	 * @return 集計時エラー内容リスト
	 * @throws MospException インスタンスの取得、或いはSQL実行に失敗した場合
	 */
	List<CutoffErrorListDtoInterface> calc(TotalTimeDataDtoInterface dto, String personalId, int calculationYear,
			int calculationMonth, String cutoffCode) throws MospException;
	
	/**
	 * 特別休暇集計。
	 * @param personalId 個人ID
	 * @param calculationYear 年
	 * @param calculationMonth 月
	 * @param cutoffCode 締日コード
	 * @param holidayCode 休暇コード
	 * @return 特別休暇集計データ
	 * @throws MospException インスタンスの取得、或いはSQL実行に失敗した場合
	 */
	TotalLeaveDtoInterface calcTotalLeave(String personalId, int calculationYear, int calculationMonth,
			String cutoffCode, String holidayCode) throws MospException;
	
	/**
	 * その他休暇集計。
	 * @param personalId 個人ID
	 * @param calculationYear 年
	 * @param calculationMonth 月
	 * @param cutoffCode 締日コード
	 * @param holidayCode 休暇コード
	 * @return その他休暇集計データ
	 * @throws MospException インスタンスの取得、或いはSQL実行に失敗した場合
	 */
	TotalOtherVacationDtoInterface calcTotalOtherVacation(String personalId, int calculationYear, int calculationMonth,
			String cutoffCode, String holidayCode) throws MospException;
	
	/**
	 * 欠勤集計。
	 * @param personalId 個人ID
	 * @param calculationYear 年
	 * @param calculationMonth 月
	 * @param cutoffCode 締日コード
	 * @param absenceCode 欠勤コード
	 * @return 欠勤集計データ
	 * @throws MospException インスタンスの取得、或いはSQL実行に失敗した場合
	 */
	TotalAbsenceDtoInterface calcTotalAbsence(String personalId, int calculationYear, int calculationMonth,
			String cutoffCode, String absenceCode) throws MospException;
	
	/**
	 * 手当集計。
	 * @param personalId 個人ID
	 * @param calculationYear 年
	 * @param calculationMonth 月
	 * @param cutoffCode 締日コード
	 * @param allowanceCode 手当コード
	 * @return 手当集計データ
	 * @throws MospException インスタンスの取得、或いはSQL実行に失敗した場合
	 */
	TotalAllowanceDtoInterface calcTotalAllowance(String personalId, int calculationYear, int calculationMonth,
			String cutoffCode, String allowanceCode) throws MospException;
	
	/**
	 * 承認状況取得。
	 * @param personalId 個人ID
	 * @param year 年
	 * @param month 月
	 * @return 未承認がない場合は0、未承認がある場合は1
	 * @throws MospException インスタンスの取得、或いはSQL実行に失敗した場合
	 */
	int getApprovalStatus(String personalId, int year, int month) throws MospException;
	
}
