/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.workflow.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.kintai.common.dao.CtWorkflowDao;
import jp.mosp.workflow.dto.CtOvertimeRequestDto;

/**
 * CT_OVERTIME_REQUEST(cƐ\e[u)DAONX B
 */
public class CtOvertimeRequestDao extends BaseDao {
	
	// e[uyуL[
	/**
	 * CT_OVERTIME_REQUEST(cƐ\e[u)B
	 */
	public static final String	TABLE			= "CT_OVERTIME_REQUEST";
	
	/**
	 * KEY_1 = VOUCHER(cƐ\`[ԍ)B
	 */
	public static final String	KEY_1			= "VOUCHER";
	
	// 
	/**
	 * VOUCHER(cƐ\`[ԍ)B
	 */
	public static final String	COL_VOUCHER		= "VOUCHER";
	/**
	 * WORKFLOW([Nt[ԍ)B
	 */
	public static final String	COL_WORKFLOW	= "WORKFLOW";
	/**
	 * KCODE(ЈR[h)B
	 */
	public static final String	COL_KCODE		= "KCODE";
	/**
	 * REQUESTDATE(\)B
	 */
	public static final String	COL_REQUESTDATE	= "REQUESTDATE";
	/**
	 * WORKDATE(Ζ)B
	 */
	public static final String	COL_WORKDATE	= "WORKDATE";
	/**
	 * OVERTIME(\)B
	 */
	public static final String	COL_OVERTIME	= "OVERTIME";
	/**
	 * REASON(R)B
	 */
	public static final String	COL_REASON		= "REASON";
	/**
	 * DELETEFLAG(폜tO)B
	 */
	public static final String	COL_DELETEFLAG	= "DELETEFLAG";
	

	/**
	 * RXgN^B
	 */
	public CtOvertimeRequestDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException SQLOꍇ
	 */
	private List<CtOvertimeRequestDto> mappingAll() throws SQLException {
		List<CtOvertimeRequestDto> all = new ArrayList<CtOvertimeRequestDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return CtOvertimeRequestDto CT_OVERTIME_REQUESTR[h
	 * @throws SQLException SQLOꍇ
	 */
	private CtOvertimeRequestDto mapping() throws SQLException {
		CtOvertimeRequestDto dto = new CtOvertimeRequestDto();
		dto.setVoucher(rs.getInt(COL_VOUCHER));
		dto.setWorkflow(rs.getLong(COL_WORKFLOW));
		dto.setKCode(rs.getString(COL_KCODE));
		dto.setRequestDate(rs.getDate(COL_REQUESTDATE));
		dto.setWorkDate(rs.getDate(COL_WORKDATE));
		dto.setOverTime(rs.getInt(COL_OVERTIME));
		dto.setReason(rs.getString(COL_REASON));
		dto.setDeleteFlag(rs.getInt(COL_DELETEFLAG));
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<CtOvertimeRequestDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param voucher cƐ\`[ԍ
	 * @return CtOvertimeRequestDto (DTO)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public CtOvertimeRequestDto findForKey(int voucher) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, voucher);
			executeQuery();
			CtOvertimeRequestDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param voucher cƐ\`[ԍ
	 * @return CtOvertimeRequestDto (DTO)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public CtOvertimeRequestDto findForUpdate(int voucher) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, voucher);
			executeQuery();
			CtOvertimeRequestDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param voucher cƐ\`[ԍ
	 * @return List (DTOList)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<CtOvertimeRequestDto> findForCondition(int voucher) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_VOUCHER);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, voucher);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param kCode ΏێЈR[h
	 * @param startDate 
	 * @param endDate 
	 * @return List (DTOList)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<CtOvertimeRequestDto> findForCondition(String kCode, Date startDate, Date endDate) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_DELETEFLAG);
		sb.append(" = " + MospConst.DELETE_FLAG_OFF);
		sb.append(" AND ");
		sb.append(COL_KCODE);
		sb.append(" = ? ");
		sb.append(" AND ");
		sb.append(COL_WORKDATE);
		sb.append(" >= ? ");
		sb.append(" AND ");
		sb.append(COL_WORKDATE);
		sb.append(" <= ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kCode);
			setParam(index++, startDate);
			setParam(index++, endDate);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param kCode ΏێЈR[h
	 * @param startDate 
	 * @param endDate 
	 * @param layer 
	 * @param status 
	 * @return List (DTOList)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<CtOvertimeRequestDto> findForCondition(String kCode, Date startDate, Date endDate, int layer,
			String status) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_DELETEFLAG);
		sb.append(" = " + MospConst.DELETE_FLAG_OFF);
		sb.append(" AND ");
		sb.append(COL_KCODE);
		sb.append(" = ? ");
		sb.append(" AND ");
		sb.append(COL_WORKDATE);
		sb.append(" >= ? ");
		sb.append(" AND ");
		sb.append(COL_WORKDATE);
		sb.append(" <= ? ");
		if (status.length() != 0) {
			sb.append(" AND ");
			sb.append(COL_WORKFLOW);
			sb.append(" IN (");
			sb.append(CtWorkflowDao.getSubQueryWorkflowStatus());
			sb.append(") ");
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kCode);
			setParam(index++, startDate);
			setParam(index++, endDate);
			if (status.length() != 0) {
				setParam(index++, layer);
				setParam(index++, status);
			}
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param kCode ΏێЈR[h
	 * @param workdate 
	 * @return CtOvertimeRequestDto (DTO)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public CtOvertimeRequestDto findForWorkDate(String kCode, Date workdate) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append(" WHERE ");
			sb.append(COL_DELETEFLAG);
			sb.append(" = " + MospConst.DELETE_FLAG_OFF);
			sb.append(" AND ");
			sb.append(COL_KCODE);
			sb.append(" = ? ");
			sb.append(" AND ");
			sb.append(COL_WORKDATE);
			sb.append(" = ? ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, kCode);
			setParam(index++, workdate);
			executeQuery();
			CtOvertimeRequestDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * maxl擾
	 * @return String@őA
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public String findForMax() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			String maxVaoucher = "";
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("SELECT MAX(");
			sb.append(COL_VOUCHER);
			sb.append(") FROM ");
			sb.append(TABLE);
			prepareStatement(sb.toString());
			executeQuery();
			if (rs.next()) {
				maxVaoucher = String.valueOf(rs.getInt(1));
			}
			return maxVaoucher;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int insert(CtOvertimeRequestDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int update(CtOvertimeRequestDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getVoucher());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int delete(CtOvertimeRequestDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getVoucher());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException SQLOꍇ
	 */
	private void setParams(CtOvertimeRequestDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getVoucher());
		setParam(index++, dto.getWorkflow());
		setParam(index++, dto.getKCode());
		setParam(index++, dto.getRequestDate());
		setParam(index++, dto.getWorkDate());
		setParam(index++, dto.getOverTime());
		setParam(index++, dto.getReason());
		setParam(index++, dto.getDeleteFlag());
		setCommonParams(isInsert);
	}
	
}
