/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.payment.action;

import java.sql.SQLException;

import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.payroll.base.PayrollAction;
import jp.mosp.payroll.dao.CmCityDao;
import jp.mosp.payroll.dto.CmCityDto;
import jp.mosp.payroll.payment.vo.CityCardVo;

public class CityCardAction extends PayrollAction {
	
	// R}h
	private static final String	CMD_CITY_CARD_SHOW		= "U5270";	// \(ǉ)
	private static final String	CMD_CITY_CARD_SELECT	= "U5271";	// \(I)
	private static final String	CMD_CITY_CARD_INSERT	= "U5272";	// o^
	private static final String	CMD_CITY_CARD_UPDATE	= "U5273";	// XV
	private static final String	CMD_CITY_CARD_DELETE	= "U5274";	// 폜
																	
	
	/**
	 * Action̏sB<br><br>
	 * ȉ̏sB
	 * <ul><li>
	 * {@link PayrollAction#PayrollAction()}
	 * </li></ul>
	 */
	public CityCardAction() {
		super();
	}
	
	/* (non-Javadoc)
	 * @see jp.mosp.common.common.BaseAction#getSpecificVo()
	 */
	@Override
	protected BaseVo getSpecificVo() {
		return new CityCardVo();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// PAYROLLmF
		confirmPayrollAuth();
		// VO擾yѐݒ
		prepareVo();
		CityCardVo vo = (CityCardVo)getVo();
		vo.setMode(CityCardVo.MODE_INSERT);
		// ЋsR[h擾
		vo.aryPltCoBankCode = getCoBankArray();
		// R}h̏
		// DTO̎擾
		CmCityDto dto;
		Object obj = session.getAttribute(MospConst.ATT_DTO);
		dto = obj instanceof CmCityDto ? (CmCityDto)obj : null;
		vo.setParams(request);
		if (cmd.equals(CMD_CITY_CARD_SHOW)) {
			// \
			// lɃZbg
			vo.setTxtCityCode("");
			vo.setTxtCityName("");
			vo.setTxtCityKana("");
			vo.setTxtDesignatedNumber("");
			vo.setPltCoBankCode("");
			vo.setMode(CityCardVo.MODE_INSERT);
		} else if (cmd.equals(CMD_CITY_CARD_SELECT)) {
			// ZbVDTOZbg
			dto = select(vo);
			vo.setMode(CityCardVo.MODE_UPDATE);
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else if (cmd.equals(CMD_CITY_CARD_INSERT)) {
			// VKo^
			dto = insert(vo);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else if (cmd.equals(CMD_CITY_CARD_UPDATE)) {
			// XV
			dto = update(vo, dto);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else if (cmd.equals(CMD_CITY_CARD_DELETE)) {
			// 폜
			delete(vo, dto);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	private CmCityDto select(CityCardVo vo) throws MospException, SQLException, IllegalAccessException,
			NoSuchFieldException {
		CmCityDao cmCityDao = new CmCityDao();
		cmCityDao.initDao(cfg, cmd, aspUser, user, conn);
		// \(L[ŏ)
		// f[^̎擾
		CmCityDto cmCityDto = cmCityDao.findForKey(key1);
		chkExist(cmCityDto);
		// VOɏZbg
		vo.setFields(cmCityDto);
		return cmCityDto;
	}
	
	/**
	 * f[^}
	 * @param vo ΏVO
	 * @return f[^}ΏDTO
	 * @throws Exception
	 */
	public CmCityDto insert(CityCardVo vo) throws Exception {
		// RlNV̎擾yDAȌ
		getConnection();
		// p[^̑ÓmF
		vo.validate();
		CmCityDao cmCityDao = new CmCityDao();
		cmCityDao.initDao(cfg, cmd, aspUser, user, conn);
		// ݃`FbN
		chkDuplicate(cmCityDao.findForKey(vo.getTxtCityCode()), vo);
		// DTȌ
		CmCityDto cmCityDto = new CmCityDto();
		vo.setDtoFields(cmCityDto);
		// f[^̑}
		cmCityDao.insert(cmCityDto);
		// DTO̍Ď擾
		cmCityDto = cmCityDao.findForKey(cmCityDto.getCityCode());
		
		// R~bg
		commit();
		// [hݒ
		vo.setMode(CityCardVo.MODE_UPDATE);
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_INSERT, ""));
		return cmCityDto;
	}
	
	/**
	 * f[^XV
	 * @param vo ΏVO
	 * @param dto ΏDTO
	 * @return f[^}ΏDTO
	 * @throws Exception
	 */
	public CmCityDto update(CityCardVo vo, CmCityDto dto) throws Exception {
		// RlNV̎擾yDAȌ
		getConnection();
		
		vo.setMode(CityCardVo.MODE_UPDATE);
		// p[^̑ÓmF
		vo.validate();
		CmCityDao cmCityDao = new CmCityDao();
		cmCityDao.initDao(cfg, cmd, aspUser, user, conn);
		// rmF
		chkExclusive(dto, cmCityDao.findForUpdate(vo.getTxtCityCode()), vo);
		// DTȌ
		vo.setDtoFields(dto);
		// f[^̍XV
		cmCityDao.update(dto);
		// DTO̍Ď擾
		CmCityDto retDto = cmCityDao.findForKey(dto.getCityCode());
		chkUpdate(retDto);
		
		// R~bg
		commit();
		// [hݒ
		vo.setMode(CityCardVo.MODE_UPDATE);
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
		return retDto;
	}
	
	/**
	 * f[^폜
	 * @param vo ΏVO
	 * @param dto ΏDTO
	 * @throws Exception
	 */
	public void delete(CityCardVo vo, CmCityDto dto) throws Exception {
		// RlNV̎擾yDAȌ
		getConnection();
		CmCityDao cmCityDao = new CmCityDao();
		cmCityDao.initDao(cfg, cmd, aspUser, user, conn);
		vo.setDtoFields(dto);
		// f[^̍XV
		cmCityDao.delete(dto);
		// R~bg
		commit();
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_DELETE, ""));
	}
	
}
