/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.dto;

import jp.mosp.common.common.BaseDto;

public class ResideTransferFBDataDto extends BaseDto {
	
	private static final long	serialVersionUID	= 3322927888185971287L;
	
	// tB[h
	private String				cityCode;									// sR[h
	private String				cityKana;									// sJi
	private String				designatedNumber;							// wԍ
	private int					paymentCount;								// ^
	private String				paymentTax;								// ^Ŋz
	private int					retireTax;									// ސEŊz
	private int					retireCount;								// ސEl
	private int					totalCount;								// v
	private int					totalTax;									// vŊz
	private String				cityChanges;								// ٓL
	private long				cityPayAmount;								// xz
	private int					cityTax;									// s
	private int					prefectureTax;								// {
																			
	
	/**
	 * RXgN^
	 */
	public ResideTransferFBDataDto() {
		super();
	}
	
	/**
	 * RXgN^
	 */
	public ResideTransferFBDataDto(ResideTransferFBDataDto resideTransferFBDataDto, CmCityDto cmCityDto,
			CtRetireDetailDto ctRetireDetailDto) {
		if (resideTransferFBDataDto != null) {
			paymentCount = resideTransferFBDataDto.getPaymentCount();
			paymentTax = resideTransferFBDataDto.getPaymentTax();
		}
		if (cmCityDto != null) {
			cityCode = cmCityDto.getCityCode();
			cityKana = cmCityDto.getCityKana();
			designatedNumber = cmCityDto.getDesignatedNumber();
		}
		
		if (ctRetireDetailDto != null) {
			cityChanges = getStringParam(ctRetireDetailDto.getCityChanges());
			retireCount = ctRetireDetailDto.getRetireCount();
			cityPayAmount = ctRetireDetailDto.getCityPayAmount();
			cityTax = ctRetireDetailDto.getCityTax();
			prefectureTax = ctRetireDetailDto.getPrefectureTax();
		} else {
			cityChanges = "";
			retireCount = 0;
			cityPayAmount = 0;
			cityTax = 0;
			prefectureTax = 0;
		}
		cityChanges = "";
		retireCount = 0;
		cityPayAmount = 0;
		cityTax = 0;
		prefectureTax = 0;
		
		// ސEŊz擾
		calcRetireTax();
		// vݒ
		calcTotal();
	}
	
	/**
	 * ސEŊz擾
	 *
	 */
	private void calcRetireTax() {
		retireTax = cityTax + prefectureTax;
		
	}
	
	/**
	 * v擾
	 *
	 */
	private void calcTotal() {
		if (paymentTax == null) {
			paymentTax = "0";
			
		}
		totalCount = retireCount + paymentCount;
		totalTax = retireTax + Integer.parseInt(paymentTax);
	}
	
	/**
	 * ݒ
	 * @param strTarget
	 * @return
	 */
	
	private String getStringParam(String strTarget) {
		// NULL̏ꍇݒ
		if (strTarget == null) {
			return "";
		}
		return strTarget;
		
	}
	
	// ANZT\bh
	public String getCityCode() {
		return cityCode;
	} // sR[h
	
	public String getCityKana() {
		return cityKana;
	} // sJi
	
	public String getDesignatedNumber() {
		return designatedNumber;
	} // wԍ
	
	public int getPaymentCount() {
		return paymentCount;
	} // ^
	
	public String getPaymentTax() {
		return paymentTax;
	} // ^Ŋz
	
	public int getRetireTax() {
		return retireTax;
	} // ސEŊz
	
	public int getTotalCount() {
		return totalCount;
	} // v
	
	public int getTotalTax() {
		return totalTax;
	} // vŊz
	
	public String getCityChanges() {
		return cityChanges;
	} // ٓL
	
	public int getRetireCount() {
		return retireCount;
	} // ސEl
	
	public long getCityPayAmount() {
		return cityPayAmount;
	} // xz
	
	public int getCityTax() {
		return cityTax;
	} // s
	
	public int getPrefectureTax() {
		return prefectureTax;
	} // {
	
	public void setCityCode(String cityCode) {
		this.cityCode = cityCode;
	} // sR[h
	
	public void setCityKana(String cityKana) {
		this.cityKana = cityKana;
	} // sJi
	
	public void setDesignatedNumber(String designatedNumber) {
		this.designatedNumber = designatedNumber;
	} // wԍ
	
	public void setPaymentCount(int paymentCount) {
		this.paymentCount = paymentCount;
	} // ^
	
	public void setPaymentTax(String paymentTax) {
		this.paymentTax = paymentTax;
	} // ^Ŋz
	
	public void setRetireTax(int retireTax) {
		this.retireTax = retireTax;
	} // ސEŊz
	
	public void setTotalCount(int totalCount) {
		this.totalCount = totalCount;
	} // v
	
	public void setTotalTax(int totalTax) {
		this.totalTax = totalTax;
	} // vŊz
	
	public void setCityChanges(String cityChanges) {
		this.cityChanges = cityChanges;
	} // ٓL
	
	public void setRetireCount(int retireCount) {
		this.retireCount = retireCount;
	} // ސEl
	
	public void setCityPayAmount(int cityPayAmount) {
		this.cityPayAmount = cityPayAmount;
	} // xz
	
	public void setCityTax(int cityTax) {
		this.cityTax = cityTax;
	} // s
	
	public void setPrefectureTax(int prefectureTax) {
		this.prefectureTax = prefectureTax;
	} // {	
	
}
