/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.action;

import java.util.Date;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.kintai.common.action.KintaiCommonAction;
import jp.mosp.payroll.vo.AttendanceExportCardVo;

/**
 * @author yoshida
 *
 */
public class AttendanceExportCardAction extends KintaiCommonAction {
	
	// R}h
	private static final String	CMD_EXPORT_CARD_SHOW	= "P1050";
	

	/**
	 * RXgN^
	 */
	public AttendanceExportCardAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾
		prepareVo(false);
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_EXPORT_CARD_SHOW)) {
			// \			
			show();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new AttendanceExportCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// PAYROLLmF
		confirmPayrollAuth();
		// [U[擾
		getInfo(user.getUserId());
		AttendanceExportCardVo vo = (AttendanceExportCardVo)getVo();
		// v_E擾
		if (hasCalculateAuth()) {
			vo.aryPltSection = StringUtil.addArrayFirstRowValue(getSectionArrayAll(),
					CommonConst.NAM_COMMON_STRING_INITIAL_VALUE, CommonConst.NAM_ALL_SECTION);
		} else {
			vo.aryPltSection = getSectionArrayForManager();
		}
		// NxXg擾
		vo.aryPltYear = StringUtil.getYearArray(MospUtility.getYear(getCalcMonth()), 1, 1);
		// Xg擾
		vo.aryPltMonth = StringUtil.getMonthArray();
	}
	
	/**
	 * \
	 * @throws Exception 	Oꍇ
	 */
	@Override
	protected void show() throws Exception {
		AttendanceExportCardVo vo = (AttendanceExportCardVo)getVo();
		// ΑӌvZΏ۔N擾
		Date current = getCalcMonth();
		vo.setPltYear(String.valueOf(MospUtility.getYear(current)));
		vo.setPltMonth(String.valueOf(MospUtility.getMonth(current)));
		vo.setPltSection(userBasis.getSCode());
	}
	
}
