/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.workflow.action;

import java.util.Date;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.TimeUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.action.MosPWorkflowAction;
import jp.mosp.kintai.common.part.KintaiApprovalPart;
import jp.mosp.kintai.common.part.KintaiCommonPart;
import jp.mosp.kintai.dto.MSyukkinboDto;
import jp.mosp.kintai.workflow.vo.ApprovalCardVo;
import jp.mosp.workflow.dto.CtOvertimeRequestDto;

/**
 * @author yoshida
 *
 */
public class ApprovalCardAction extends MosPWorkflowAction {
	
	// R}h
	private static final String	CMD_APPROVAL_CARD_SELECT	= "K2126";
	private static final String	CMD_APPROVAL_CARD_REGIST	= "K2127";
	private static final String	CMD_APPROVAL_CARD_RETURN	= "K2129";
	

	/**
	 * RXgN^
	 */
	public ApprovalCardAction() {
		super();
	}
	
	public void action() throws Exception {
		// VO̎擾
		prepareVo(false);
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_APPROVAL_CARD_SELECT)) {
			// I
			select();
		} else if (cmd.equals(CMD_APPROVAL_CARD_REGIST)) {
			// F
			approved();
		} else if (cmd.equals(CMD_APPROVAL_CARD_RETURN)) {
			// 
			returned();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new ApprovalCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		// MANAGERmF
		confirmManagerAuth();
		ApprovalCardVo vo = (ApprovalCardVo)getVo();
		// [U[擾
		getInfo(user.getUserId());
		// 蓖ꗗ
		vo.setAryAllowance(getMosPCodeArray(CommonConst.TID_ALLOWANCE_NAME));
	}
	
	/**
	 * ΑӏFΏۓ擾
	 * @throws Exception	Oꍇ
	 */
	@Override
	protected void select() throws Exception {
		ApprovalCardVo vo = (ApprovalCardVo)getVo();
		vo.setParams(request);
		vo.setHidKCode(key1);
		vo.setHidDate(key2);
		// FΏۏݒ
		setAttendanceInfo(kintai().getSyukkinboInfo(vo.getHidKCode(), vo.getHidDate()));
	}
	
	/**
	 * ΑӏF
	 * @throws Exception	Oꍇ
	 */
	private void approved() throws Exception {
		// DTO̎擾
		MSyukkinboDto dto = (MSyukkinboDto)getSessionDto();
		ApprovalCardVo vo = (ApprovalCardVo)getVo();
		vo.setParams(request);
		// rmF
		chkExclusive(dto, kintai().getSyukkinboInfo(dto.getKCode(), dto.getHizuke(), true));
		// DTO̍Ď擾
		MSyukkinboDto retDto = dto;
		// F
		if (runDailyApprovalProcess(dto.getKCode(), DateUtil.convStringDateToDate(dto.getHizuke()), "", true)) {
			// R~bg
			commit();
			// DTO̍Ď擾
			retDto = kintai().getSyukkinboInfo(dto.getKCode(), dto.getHizuke());
			chkUpdate(retDto);
			// bZ[Wݒ
			if (KintaiApprovalPart.is1stApproved(retDto)) {
				setMessage(getMessage(CommonConst.MSG_DONE, CommonConst.NAM_1ST_APPROVED));
			}
			if (KintaiApprovalPart.is2ndApproved(retDto)) {
				setMessage(getMessage(CommonConst.MSG_DONE, CommonConst.NAM_2ND_APPROVED));
			}
		}
		// [hݒ
		setAttendanceInfo(retDto);
	}
	
	/**
	 * ΑӍߏ
	 * @throws Exception	Oꍇ
	 */
	private void returned() throws Exception {
		// DTO̎擾
		MSyukkinboDto dto = (MSyukkinboDto)getSessionDto();
		ApprovalCardVo vo = (ApprovalCardVo)getVo();
		vo.setParams(request);
		// p[^̑ÓmF
		vo.validate();
		// rmF
		chkExclusive(dto, kintai().getSyukkinboInfo(dto.getKCode(), dto.getHizuke(), true));
		// DTO̍Ď擾
		MSyukkinboDto retDto = dto;
		// ߏ
		if (runDailyApprovalProcess(dto.getKCode(), DateUtil.convStringDateToDate(dto.getHizuke()), vo.getTxtComment(),
				false)) {
			// R~bg
			commit();
			// bZ[Wݒ
			setMessage(getMessage(CommonConst.MSG_APPROVAL_RETURNED, ""));
			// DTO̍Ď擾
			retDto = kintai().getSyukkinboInfo(dto.getKCode(), dto.getHizuke());
			chkUpdate(retDto);
		}
		// [hݒ
		setAttendanceInfo(retDto);
	}
	
	/**
	 * FΏۏݒ
	 * @param dto	ΏDTO
	 * @throws Exception	Oꍇ
	 */
	private void setAttendanceInfo(MSyukkinboDto dto) throws Exception {
		ApprovalCardVo vo = (ApprovalCardVo)getVo();
		String kCode;
		Date targetDate;
		String statusCode = "";
		MSyukkinboDto retDto = null;
		// [hݒ
		vo.setMode(ApprovalCardVo.MODE_VIEW);
		if (!KintaiApprovalPart.isDraft(dto) && VariousUtil.isNotNull(dto)) {
			retDto = dto;
			kCode = retDto.getKCode();
			targetDate = DateUtil.convStringDateToDate(retDto.getHizuke());
			vo.setHidKCode(kCode);
			vo.setHidDate(retDto.getHizuke());
			statusCode = retDto.getSnRiyuu();
			// FҊmF
			if (part().kintaiApproval().isApprover(kCode, userBasis.getKCode(), statusCode, targetDate)) {
				vo.setMode(ApprovalCardVo.MODE_APPROVAL);
			}
		} else {
			kCode = vo.getHidKCode();
			targetDate = DateUtil.convStringDateToDate(vo.getHidDate());
			retDto = KintaiCommonPart.createBaseSyukkinboInfo(kCode, targetDate);
		}
		// ̂̕ϊ
		kintai().replaceCodeToName(retDto);
		// VOɏZbg
		vo.setFields(retDto);
		vo.setLblDate(DateUtil.convDateToFormatDateJP(targetDate));
		vo.setLblStatus(getApprovalName(statusCode));
		// l{擾
		setLabelBasisInfo(part().human().getBasisInfo(kCode));
		// Jgݒ
		setLaborAgreementInfo(kCode, targetDate);
		// ԊOxΉ
		vo.setCaution(checkCautionOverTimeMonthly(kCode, targetDate));
		// 60ԎԊOxΉ
		vo.setWarning(checkWarningOverTimeMonthly(kCode, targetDate));
		// xɐ\
		vo.setAryLblHolidayRequest(getLabelHolidayRequestStatusArray(kCode, targetDate));
		// cƐ\
		CtOvertimeRequestDto overtimeDto = getOverTimeRequest(kCode, targetDate);
		if (VariousUtil.isNotNull(overtimeDto)) {
			StringBuffer sb = new StringBuffer();
			statusCode = toKintaiApprovalStatus(overtimeDto.getWorkflow());
			// ȊO
			if (!KintaiApprovalPart.isDraft(statusCode)) {
				// \
				sb.append(TimeUtil.convIntegerTimeToJPHours(overtimeDto.getOverTime()));
				// F
				sb.append(StringUtil.surroundBracket(getApprovalName(statusCode)));
				vo.setLblOverTimeRequest(sb.toString());
			}
		}
		// ZbVDTOZbg
		setSessionDto(retDto);
	}
}
