/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.kintai.common.dto.MKihonDto;

/**
 * @author yoshida
 *
 */
public class EmployeeApprovalListVo extends MosPVo {
	
	private static final long	serialVersionUID	= -2944600739302499938L;
	
	// p[^	
	/**
	 * pltYear
	 */
	public static final String	PRM_PLT_YEAR		= "pltYear";
	/**
	 * pltMonth
	 */
	public static final String	PRM_PLT_MONTH		= "pltMonth";
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_K_CODE;
	/**
	 * 
	 */
	public int					LEN_K_CODE;
	/**
	 * 
	 */
	public int					LEN_K_NAME;
	
	// tB[h
	private String[]			arySelectDate;
	private String[]			aryKCode;
	private String[]			aryKName;
	private String[]			arySection;
	private String[]			aryPosition;
	
	private String				pltSelectYear;
	private String				pltSelectMonth;
	
	// v_EXg
	/**
	 * 
	 */
	public String[][]			arySectionAll;
	/**
	 * 
	 */
	public String[][]			aryPositionAll;
	
	/**
	 * 
	 */
	public String[][]			aryPltYear;
	/**
	 * 
	 */
	public String[][]			aryPltMonth;
	
	// \[gL[
	/**
	 * keyKCode
	 */
	public final String			KEY_K_CODE			= "keyKCode";
	/**
	 * keyKName
	 */
	public final String			KEY_K_NAME			= "keyKName";
	/**
	 * keySection
	 */
	public final String			KEY_SECTION			= "keySection";
	/**
	 * keyPosition
	 */
	public final String			KEY_POSITION		= "keyPosition";
	

	/**
	 * RXgN^
	 */
	public EmployeeApprovalListVo() {
		super();
		setViewPath(getClassName());
		arySelectDate = new String[0];
		aryKCode = new String[0];
		aryKName = new String[0];
		arySection = new String[0];
		aryPosition = new String[0];
		setFormerKey(KEY_K_CODE);
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_EMPLOYEE_APPROVAL;
		createAryMenu(CMD_MENU_MAMAGE, MosPMenuConst.getMenuManagerApproval());
	}
	
	@Override
	protected void setFieldsName() {
		NAM_K_CODE = CommonConst.NAM_K_CODE;
		LEN_K_CODE = CommonConst.LEN_K_CODE;
		LEN_K_NAME = CommonConst.LEN_K_NAME;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		pltSelectYear = request.getParameter(PRM_PLT_YEAR);
		pltSelectMonth = request.getParameter(PRM_PLT_MONTH);
	}
	
	@Override
	public void setFields(List<?> list) {
		// Xg̐ݒ
		this.list = list;
		// f[^̎擾
		count = list.size();
		// z̏
		arySelectDate = new String[count];
		aryKCode = new String[count];
		aryKName = new String[count];
		arySection = new String[count];
		aryPosition = new String[count];
		// f[^̐ݒ
		int i = 0;
		Iterator<?> it = list.iterator();
		while (it.hasNext()) {
			MKihonDto dto = (MKihonDto)it.next();
			arySelectDate[i] = escapeHTML(StringUtil.combineByHyphen(pltSelectYear, pltSelectMonth));
			aryKCode[i] = escapeHTML(dto.getKCode());
			aryKName[i] = escapeHTML(dto.getSimei());
			arySection[i] = getCodeName(dto.getSCode(), arySectionAll);
			aryPosition[i] = "";
			for (String[] element : aryPositionAll) {
				if (element[0].equals(dto.getYCode()) && element[2].equals(dto.getTokyu())) {
					aryPosition[i] = escapeHTML(element[1]);
					break;
				}
			}
			i++;
		}
	}
	
	// ANZT\bh
	
	/**
	 * @return arySelectDate
	 */
	public String[] getArySelectDate() {
		return arySelectDate.clone();
	}
	
	/**
	 * @return aryKCode
	 */
	public String[] getAryKCode() {
		return aryKCode.clone();
	}
	
	/**
	 * @return aryKName
	 */
	public String[] getAryKName() {
		return aryKName.clone();
	}
	
	/**
	 * @return arySection
	 */
	public String[] getArySection() {
		return arySection.clone();
	}
	
	/**
	 * @return aryPosition
	 */
	public String[] getAryPosition() {
		return aryPosition.clone();
	}
	
	/**
	 * @return pltSelectYear
	 */
	public String getPltSelectYear() {
		return pltSelectYear;
	}
	
	/**
	 * @return pltSelectMonth
	 */
	public String getPltSelectMonth() {
		return pltSelectMonth;
	}
	
	/**
	 * @param arySelectDate Zbg arySelectDate
	 */
	public void setArySelectDate(String[] arySelectDate) {
		this.arySelectDate = arySelectDate.clone();
	}
	
	/**
	 * @param aryKCode Zbg aryKCode
	 */
	public void setAryKCode(String[] aryKCode) {
		this.aryKCode = aryKCode.clone();
	}
	
	/**
	 * @param aryKName Zbg aryKName
	 */
	public void setAryKName(String[] aryKName) {
		this.aryKName = aryKName.clone();
	}
	
	/**
	 * @param arySection Zbg arySection
	 */
	public void setArySection(String[] arySection) {
		this.arySection = arySection.clone();
	}
	
	/**
	 * @param aryPosition Zbg aryPosition
	 */
	public void setAryPosition(String[] aryPosition) {
		this.aryPosition = aryPosition.clone();
	}
	
	/**
	 * @param pltSelectYear Zbg pltSelectYear
	 */
	public void setPltSelectYear(String pltSelectYear) {
		this.pltSelectYear = pltSelectYear;
	}
	
	/**
	 * @param pltSelectMonth Zbg pltSelectMonth
	 */
	public void setPltSelectMonth(String pltSelectMonth) {
		this.pltSelectMonth = pltSelectMonth;
	}
	
}
